/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ExportOperation
extends AbstractRepositoryOperation {
    protected String path;
    protected int depth;
    protected boolean ignoreExternals;

    public ExportOperation(IRepositoryResource[] resources, String path, int depth, boolean ignoreExternals) {
        super("Operation_ExportRevision", SVNMessages.class, resources);
        this.path = path;
        this.depth = depth;
        this.ignoreExternals = ignoreExternals;
    }

    public ExportOperation(IRepositoryResourceProvider provider, String path, int depth, boolean ignoreExternals) {
        super("Operation_ExportRevision", SVNMessages.class, provider);
        this.path = path;
        this.depth = depth;
        this.ignoreExternals = ignoreExternals;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            final String path = String.valueOf(this.path) + "/" + resources[i].getName();
            final SVNEntryRevisionReference entryRef = SVNUtility.getEntryRevisionReference(resources[i]);
            this.writeToConsole(0, "svn export \"" + resources[i].getUrl() + "@" + resources[i].getPegRevision() + "\" -r " + resources[i].getSelectedRevision() + SVNUtility.getIgnoreExternalsArg(this.ignoreExternals) + " \"" + FileUtility.normalizePath(path) + "\"" + SVNUtility.getDepthArg(this.depth) + " --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    long options = 4L;
                    if (ExportOperation.this.ignoreExternals) {
                        options |= 1L;
                    }
                    proxy.doExport(entryRef, path, null, ExportOperation.this.depth, options, new SVNProgressMonitor(ExportOperation.this, monitor, null));
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.operableData()[0].getUrl()});
    }
}

