/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.remote.BranchTagOperation;
import org.eclipse.team.svn.core.operation.remote.CopyResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.CreateFolderOperation;
import org.eclipse.team.svn.core.operation.remote.SetRevisionAuthorNameOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;

public class PreparedBranchTagOperation
extends CompositeOperation
implements IRepositoryResourceProvider {
    protected IRepositoryResource destination;
    protected IRepositoryResource[] resources;
    protected String message;
    protected String operationName;
    protected boolean forceCreate;
    protected IRepositoryResource[] targets;
    protected IResource[] wcResources;

    public PreparedBranchTagOperation(String operationName, IResource[] wcResources, IRepositoryResource[] resources, IRepositoryResource destination, String message, boolean forceCreate) {
        this(operationName, resources, destination, message, forceCreate);
        this.wcResources = wcResources;
    }

    public PreparedBranchTagOperation(String operationName, IRepositoryResource[] resources, IRepositoryResource destination, String message, boolean forceCreate) {
        super("Operation_Prepared" + operationName, SVNMessages.class);
        this.operationName = operationName;
        this.resources = resources;
        this.destination = destination;
        this.message = message;
        this.forceCreate = forceCreate;
    }

    public IRepositoryResource[] getRepositoryResources() {
        return this.targets;
    }

    public IRepositoryResource getDestination() {
        return this.destination;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() < 5 || this.wcResources != null) {
            IRepositoryResource parent = PreparedBranchTagOperation.getExistentParent(this.destination);
            if (parent == null) {
                throw new UnreportableException(SVNMessages.getErrorString("Error_RepositoryInaccessible"));
            }
            this.targets = new IRepositoryResource[this.resources.length];
            CreateFolderOperation op = null;
            boolean createLastSegment = false;
            if (parent != this.destination) {
                Path newFolderPath = new Path(this.destination.getUrl().substring(parent.getUrl().length() + 1));
                IPath cutPath = newFolderPath.removeLastSegments(1);
                boolean bl = createLastSegment = this.resources.length == 1 && !newFolderPath.isEmpty() && !this.forceCreate;
                if (this.resources.length != 1 || !cutPath.isEmpty() || this.forceCreate) {
                    String folderName = this.resources.length == 1 && !cutPath.isEmpty() && !this.forceCreate ? cutPath.toString() : newFolderPath.toString();
                    op = new CreateFolderOperation(parent, folderName, this.message);
                    this.add(op);
                    this.add(new SetRevisionAuthorNameOperation(op, 4L));
                }
            }
            int i = 0;
            while (i < this.targets.length) {
                String targetUrl = this.destination.getUrl();
                if (!createLastSegment) {
                    targetUrl = String.valueOf(targetUrl) + "/" + this.resources[i].getName();
                }
                IRepositoryResource iRepositoryResource = this.targets[i] = this.resources[i] instanceof IRepositoryFile ? this.destination.asRepositoryFile(targetUrl, false) : this.destination.asRepositoryContainer(targetUrl, false);
                if (this.wcResources != null) {
                    IActionOperation[] iActionOperationArray;
                    org.eclipse.team.svn.core.operation.local.BranchTagOperation branchTagOperation = new org.eclipse.team.svn.core.operation.local.BranchTagOperation(this.operationName, new IResource[]{this.wcResources[i]}, this.targets[i], this.message);
                    if (op == null) {
                        iActionOperationArray = null;
                    } else {
                        IActionOperation[] iActionOperationArray2 = new IActionOperation[1];
                        iActionOperationArray = iActionOperationArray2;
                        iActionOperationArray2[0] = op;
                    }
                    this.add(branchTagOperation, iActionOperationArray);
                }
                ++i;
            }
            if (this.wcResources == null) {
                IActionOperation[] iActionOperationArray;
                BranchTagOperation branchtagOp = new BranchTagOperation(this.operationName, SVNMessages.class, this.resources, this.destination, this.message);
                if (op == null) {
                    iActionOperationArray = null;
                } else {
                    IActionOperation[] iActionOperationArray3 = new IActionOperation[1];
                    iActionOperationArray = iActionOperationArray3;
                    iActionOperationArray3[0] = op;
                }
                this.add(branchtagOp, iActionOperationArray);
                this.add(new SetRevisionAuthorNameOperation(branchtagOp, 4L));
            }
        } else {
            CopyResourcesOperation branchtagOp = this.forceCreate ? new CopyResourcesOperation(this.destination, this.resources, this.message, this.resources[0].getName()) : new CopyResourcesOperation(this.destination.getParent(), this.resources, this.message, this.destination.getName());
            this.add(branchtagOp);
            this.add(new SetRevisionAuthorNameOperation(branchtagOp, 4L));
        }
        super.runImpl(monitor);
    }

    protected static IRepositoryResource getExistentParent(IRepositoryResource notExistentResource) throws Exception {
        if (notExistentResource == null) {
            return null;
        }
        return notExistentResource.exists() ? notExistentResource : PreparedBranchTagOperation.getExistentParent(notExistentResource.getParent());
    }
}

