/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;

public class SetRevisionAuthorNameOperation
extends AbstractActionOperation {
    protected IRevisionProvider provider;
    protected long options;

    public SetRevisionAuthorNameOperation(final IRevisionProvider.RevisionPair[] revisions, long options) {
        this(new IRevisionProvider(){

            public IRevisionProvider.RevisionPair[] getRevisions() {
                return revisions;
            }
        }, options);
    }

    public SetRevisionAuthorNameOperation(IRevisionProvider provider, long options) {
        super("Operation_SetRevisionAuthorName", SVNMessages.class);
        this.provider = provider;
        this.options = options;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRevisionProvider.RevisionPair[] revisions = this.provider.getRevisions();
        if (revisions == null) {
            return;
        }
        int i = 0;
        while (i < revisions.length) {
            IRepositoryLocation location;
            if (revisions[i] != null && (location = revisions[i].location).isAuthorNameEnabled()) {
                final ISVNConnector proxy = location.acquireSVNProxy();
                final SVNRevision.Number rev = SVNRevision.fromNumber(revisions[i].revision);
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        proxy.setRevisionProperty(new SVNEntryReference(location.getUrl(), rev), "svn:author", location.getAuthorName(), SetRevisionAuthorNameOperation.this.options, new SVNProgressMonitor(SetRevisionAuthorNameOperation.this, monitor, null));
                    }
                }, monitor, 1);
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }
}

