/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.variant.BaseFileVariant;
import org.eclipse.team.svn.core.synchronize.variant.BaseFolderVariant;
import org.eclipse.team.svn.core.synchronize.variant.RemoteFileVariant;
import org.eclipse.team.svn.core.synchronize.variant.RemoteFolderVariant;
import org.eclipse.team.svn.core.synchronize.variant.VirtualRemoteFileVariant;
import org.eclipse.team.svn.core.synchronize.variant.VirtualRemoteFolderVariant;

public abstract class AbstractSVNSyncInfo
extends SyncInfo {
    protected ILocalResource local;
    protected IResourceChange remoteStatus;

    public AbstractSVNSyncInfo(ILocalResource local, IResourceChange remote, IResourceVariantComparator comparator) {
        this(local, AbstractSVNSyncInfo.makeBaseVariant(local), AbstractSVNSyncInfo.makeRemoteVariant(local, remote), comparator, remote);
    }

    protected AbstractSVNSyncInfo(ILocalResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator, IResourceChange remoteStatus) {
        super(local.getResource(), base, remote, comparator);
        this.local = local;
        this.remoteStatus = remoteStatus;
    }

    public ILocalResource getLocalResource() {
        return this.local;
    }

    public IResourceChange getRemoteResource() {
        return this.remoteStatus;
    }

    public ILocalResource getRemoteChangeResource() {
        return this.remoteStatus != null ? this.remoteStatus : this.local;
    }

    public ILocalResource getBaseChangeResource() {
        return this.local;
    }

    protected boolean isLinked(String kind, int mask) {
        return IStateFilter.SF_LINKED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isReplaced(String kind, int mask) {
        return AbstractSVNSyncInfo.isReplaced(this.getLocal(), kind, mask);
    }

    protected static boolean isReplaced(IResource resource, String kind, int mask) {
        return IStateFilter.SF_PREREPLACEDREPLACED.accept(resource, kind, mask);
    }

    protected boolean isDeleted(String kind, int mask) {
        return AbstractSVNSyncInfo.isDeleted(this.getLocal(), kind, mask);
    }

    protected static boolean isDeleted(IResource resource, String kind, int mask) {
        return IStateFilter.SF_DELETED.accept(resource, kind, mask);
    }

    protected boolean isModified(String kind, int mask) {
        return IStateFilter.SF_MODIFIED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isConflicted(String kind, int mask) {
        return IStateFilter.SF_CONFLICTING.accept(this.getLocal(), kind, mask);
    }

    protected boolean isTreeConflicted(String kind, int mask) {
        return IStateFilter.SF_TREE_CONFLICTING.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNotModified(String kind, int mask) {
        return IStateFilter.SF_NOTMODIFIED.accept(this.getLocal(), kind, mask);
    }

    protected boolean isNonVersioned(String kind, int mask) {
        return AbstractSVNSyncInfo.isNonVersioned(this.getLocal(), kind, mask);
    }

    protected static boolean isNonVersioned(IResource resource, String kind, int mask) {
        return IStateFilter.SF_UNVERSIONED.accept(resource, kind, mask);
    }

    protected boolean isNotExists(String kind, int mask) {
        return AbstractSVNSyncInfo.isNotExists(this.getLocal(), kind, mask);
    }

    protected static boolean isNotExists(IResource resource, String kind, int mask) {
        return IStateFilter.SF_NOTEXISTS.accept(resource, kind, mask);
    }

    protected boolean isIgnored(String kind, int mask) {
        return AbstractSVNSyncInfo.isIgnored(this.getLocal(), kind, mask);
    }

    protected static boolean isIgnored(IResource resource, String kind, int mask) {
        return IStateFilter.SF_IGNORED.accept(resource, kind, mask);
    }

    protected boolean isAdded(String kind, int mask) {
        return AbstractSVNSyncInfo.isAdded(this.getLocal(), kind, mask);
    }

    protected static boolean isAdded(IResource resource, String kind, int mask) {
        return IStateFilter.SF_ADDED.accept(resource, kind, mask);
    }

    protected static IResourceVariant makeBaseVariant(ILocalResource local) {
        if (local == null) {
            return null;
        }
        if (local.getRevision() == -1L) {
            return null;
        }
        return local instanceof ILocalFolder ? new BaseFolderVariant(local) : new BaseFileVariant(local);
    }

    protected static IResourceVariant makeRemoteVariant(ILocalResource local, ILocalResource remote) {
        int remoteMask;
        String localKind = local == null ? IStateFilter.ST_NOTEXISTS : local.getStatus();
        int localMask = local == null ? 0 : local.getChangeMask();
        IResource resource = local.getResource();
        String remoteKind = remote == null ? (AbstractSVNSyncInfo.isNonVersioned(resource, localKind, localMask) ? IStateFilter.ST_NOTEXISTS : "Normal") : remote.getStatus();
        int n = remoteMask = remote == null ? 0 : remote.getChangeMask();
        if (AbstractSVNSyncInfo.isNonVersioned(resource, remoteKind, remoteMask)) {
            return null;
        }
        if (!AbstractSVNSyncInfo.isReplaced(resource, remoteKind, remoteMask) && AbstractSVNSyncInfo.isDeleted(resource, remoteKind, remoteMask)) {
            return null;
        }
        if (remote == null && AbstractSVNSyncInfo.isAdded(resource, localKind, localMask)) {
            return null;
        }
        if (remote == null) {
            return local instanceof ILocalFolder ? new VirtualRemoteFolderVariant(local) : new VirtualRemoteFileVariant(local);
        }
        return remote instanceof ILocalFolder ? new RemoteFolderVariant(remote) : new RemoteFileVariant(remote);
    }
}

