/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.console;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.console.SVNConsoleFactory;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class SVNConsole
extends MessageConsole
implements IPropertyChangeListener {
    public static final String SVN_CONSOLE_TYPE = "org.eclipse.team.svn.ui.console.SVNConsole";
    protected MessageConsoleStream cmdStream;
    protected MessageConsoleStream okStream;
    protected MessageConsoleStream warningStream;
    protected MessageConsoleStream errorStream;
    protected int autoshow;
    protected boolean enabled;

    public SVNConsole() {
        super(SVNUIMessages.SVNConsole_Name, SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/console.gif"));
        super.setType(SVN_CONSOLE_TYPE);
        super.init();
        this.setTabWidth(4);
        this.cmdStream = this.newMessageStream();
        this.okStream = this.newMessageStream();
        this.warningStream = this.newMessageStream();
        this.errorStream = this.newMessageStream();
        this.loadPreferences();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IConsoleStream getConsoleStream() {
        return new SVNConsoleStream();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("preference.console.")) {
            this.loadPreferences();
        }
    }

    public void shutdown() {
        super.dispose();
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        this.enabled = false;
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        Color tmp1 = this.cmdStream.getColor();
        Color tmp2 = this.okStream.getColor();
        Color tmp3 = this.warningStream.getColor();
        Color tmp4 = this.errorStream.getColor();
        try {
            this.cmdStream.close();
        }
        catch (Exception exception) {}
        try {
            this.okStream.close();
        }
        catch (Exception exception) {}
        try {
            this.warningStream.close();
        }
        catch (Exception exception) {}
        try {
            this.errorStream.close();
        }
        catch (Exception exception) {}
        if (tmp1 != null) {
            tmp1.dispose();
        }
        if (tmp1 != null) {
            tmp2.dispose();
        }
        if (tmp1 != null) {
            tmp3.dispose();
        }
        if (tmp1 != null) {
            tmp4.dispose();
        }
    }

    protected void init() {
        this.enabled = true;
    }

    protected void dispose() {
        this.enabled = false;
    }

    protected void loadPreferences() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Color tmp = this.cmdStream.getColor();
        this.cmdStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), SVNTeamPreferences.getConsoleRGB(store, "command")));
        if (tmp != null && !tmp.equals((Object)this.cmdStream.getColor())) {
            tmp.dispose();
        }
        tmp = this.okStream.getColor();
        this.okStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), SVNTeamPreferences.getConsoleRGB(store, "ok")));
        if (tmp != null && !tmp.equals((Object)this.okStream.getColor())) {
            tmp.dispose();
        }
        tmp = this.warningStream.getColor();
        this.warningStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), SVNTeamPreferences.getConsoleRGB(store, "warning")));
        if (tmp != null && !tmp.equals((Object)this.warningStream.getColor())) {
            tmp.dispose();
        }
        tmp = this.errorStream.getColor();
        this.errorStream.setColor(new Color((Device)UIMonitorUtility.getDisplay(), SVNTeamPreferences.getConsoleRGB(store, "error")));
        if (tmp != null && !tmp.equals((Object)this.errorStream.getColor())) {
            tmp.dispose();
        }
        if (SVNTeamPreferences.getConsoleBoolean(store, "wrapEnabled")) {
            this.setConsoleWidth(SVNTeamPreferences.getConsoleInt(store, "wrapWidth"));
        } else {
            this.setConsoleWidth(-1);
        }
        this.autoshow = SVNTeamPreferences.getConsoleInt(store, "autoshow");
        if (SVNTeamPreferences.getConsoleBoolean(store, "limitEnabled")) {
            int limit = SVNTeamPreferences.getConsoleInt(store, "limitRange");
            this.setWaterMarks(1000 < limit ? 1000 : limit - 1, limit);
        } else {
            this.setWaterMarks(-1, 0);
        }
        UIMonitorUtility.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SVNConsole.this.setFont(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(SVNTeamPreferences.fullConsoleName("font")));
            }
        });
    }

    public class SVNConsoleListener
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == SVNConsole.this) {
                    SVNConsole.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == SVNConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    SVNConsole.this.dispose();
                }
                ++i;
            }
        }
    }

    protected class SVNConsoleStream
    implements IConsoleStream {
        protected long start;
        protected String buffer;
        protected boolean outputStarted;
        protected boolean hasError;
        protected boolean hasWarning;
        protected boolean activated;
        protected boolean cancelled;

        public void markEnd() {
            if (this.outputStarted) {
                this.write(0, "*** ");
                if (this.hasError) {
                    this.write(3, SVNUIMessages.SVNConsole_Error);
                } else if (this.hasWarning) {
                    this.write(2, SVNUIMessages.SVNConsole_Warning);
                } else {
                    this.write(0, this.cancelled ? SVNUIMessages.SVNConsole_Cancelled : SVNUIMessages.SVNConsole_Ok);
                }
                this.write(0, " " + SVNUIMessages.format((String)SVNUIMessages.SVNConsole_Took, (Object[])new String[]{new SimpleDateFormat("mm:ss.SSS").format(new Date(System.currentTimeMillis() - this.start))}) + "\n\n");
            }
        }

        public void markStart(String data) {
            this.start = System.currentTimeMillis();
            this.buffer = data;
        }

        public void doComplexWrite(Runnable runnable) {
            this.flushBuffer();
            runnable.run();
        }

        public void write(int severity, String data) {
            this.flushBuffer();
            if (SVNConsole.this.enabled && !this.activated) {
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)SVNConsole.this);
                this.activated = true;
            } else if (!SVNConsole.this.enabled && this.canShowConsoleAutomatically(severity)) {
                SVNConsoleFactory.showConsole();
                this.activated = true;
            }
            if (this.activated) {
                switch (severity) {
                    case 0: {
                        this.print(SVNConsole.this.cmdStream, data);
                        break;
                    }
                    case 1: {
                        this.print(SVNConsole.this.okStream, data);
                        break;
                    }
                    case 2: {
                        this.hasWarning = true;
                        this.print(SVNConsole.this.warningStream, data);
                        break;
                    }
                    default: {
                        this.hasError = true;
                        this.print(SVNConsole.this.errorStream, data);
                    }
                }
            }
        }

        protected boolean canShowConsoleAutomatically(int severity) {
            return SVNConsole.this.autoshow == 1 || SVNConsole.this.autoshow == 2 && severity == 3 || SVNConsole.this.autoshow == 3 && (severity == 3 || severity == 2);
        }

        public void markCancelled() {
            this.cancelled = true;
        }

        protected void print(final MessageConsoleStream stream, final String data) {
            if (UIMonitorUtility.getDisplay().getThread() == Thread.currentThread()) {
                ProgressMonitorUtility.doTaskScheduledDefault((IActionOperation)new AbstractActionOperation("Operation_WriteToConsoleResources", SVNUIMessages.class){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        stream.print(data);
                    }
                }, (boolean)true);
            } else {
                stream.print(data);
            }
        }

        protected void flushBuffer() {
            this.outputStarted = true;
            if (this.buffer != null) {
                String tmp = this.buffer;
                this.buffer = null;
                this.write(0, "*** ");
                this.write(0, tmp);
                this.write(0, "\n");
            }
        }
    }
}

