/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.remote;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.DepthSelectionComposite;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.ExistingResourceVerifier;

public class ExportPanel
extends AbstractDialogPanel {
    protected Text locationField;
    protected String location;
    protected RevisionComposite revisionComposite;
    protected IRepositoryResource selectedResource;
    protected DepthSelectionComposite depthSelector;

    public ExportPanel(IRepositoryResource baseResource) {
        this.dialogTitle = SVNUIMessages.ExportPanel_Title;
        this.dialogDescription = SVNUIMessages.ExportPanel_Description;
        this.defaultMessage = SVNUIMessages.ExportPanel_Message;
        this.selectedResource = baseResource;
    }

    public SVNRevision getSelectedRevision() {
        return this.revisionComposite != null ? this.revisionComposite.getSelectedRevision() : SVNRevision.INVALID_REVISION;
    }

    protected void saveChangesImpl() {
        this.location = this.locationField.getText();
    }

    protected void cancelChangesImpl() {
    }

    public int getDepth() {
        if (this.depthSelector == null) {
            return 3;
        }
        return this.depthSelector.getDepth();
    }

    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite folderComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        folderComposite.setLayout((Layout)layout);
        data = new GridData(768);
        folderComposite.setLayoutData((Object)data);
        Label label = new Label(folderComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.ExportPanel_Folder);
        this.locationField = new Text(folderComposite, 2052);
        data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        this.attachTo((Control)this.locationField, new ExistingResourceVerifier(label.getText(), false));
        Button browseButton = new Button(folderComposite, 8);
        browseButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browseButton);
        browseButton.setLayoutData((Object)data);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog fileDialog = new DirectoryDialog(ExportPanel.this.manager.getShell());
                fileDialog.setText(SVNUIMessages.ExportPanel_ExportFolder);
                fileDialog.setMessage(SVNUIMessages.ExportPanel_ExportFolder_Msg);
                String path = fileDialog.open();
                if (path != null) {
                    ExportPanel.this.locationField.setText(path);
                }
            }
        });
        if (this.selectedResource != null) {
            this.revisionComposite = new RevisionComposite(parent, this, false, null, SVNRevision.HEAD, false);
            data = new GridData(768);
            this.revisionComposite.setLayoutData(data);
            this.revisionComposite.setSelectedResource(this.selectedResource);
        }
        if (this.selectedResource instanceof IRepositoryContainer || this.selectedResource == null) {
            Label separator = new Label(parent, 258);
            separator.setLayoutData((Object)new GridData(768));
            separator.setVisible(false);
            this.depthSelector = new DepthSelectionComposite(parent, 0);
            data = new GridData(768);
            this.depthSelector.setLayoutData(data);
        }
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.remote_exportDialogContext";
    }

    public String getLocation() {
        return this.location;
    }
}

