/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph;

import java.util.Iterator;
import org.eclipse.team.svn.revision.graph.NodeConnections;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPath;
import org.eclipse.team.svn.revision.graph.cache.CacheRevision;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.operation.PathRevisionConnectionsValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathRevision
extends NodeConnections<PathRevision> {
    protected final int pathIndex;
    protected final CacheRevision cacheRevision;
    public final ReviosionNodeType type;
    public final RevisionNodeAction action;
    protected PathRevisionConnectionsValidator validator;

    public PathRevision(CacheRevision revisionData, int pathIndex, RevisionNodeAction action, ReviosionNodeType type) {
        this.cacheRevision = revisionData;
        this.pathIndex = pathIndex;
        this.action = action;
        this.type = type;
    }

    public int getPathIndex() {
        return this.pathIndex;
    }

    public long getRevision() {
        return this.cacheRevision.getRevision();
    }

    public long getDate() {
        return this.cacheRevision.getDate();
    }

    public int getAuthorIndex() {
        return this.cacheRevision.getAuthorIndex();
    }

    public int getMessageIndex() {
        return this.cacheRevision.getMessageIndex();
    }

    public CacheChangedPath[] getChangedPaths() {
        return this.cacheRevision.getChangedPaths();
    }

    public void insertNodeInRevisionsChain(PathRevision node) {
        NodeConnections prevNodeToProcess = null;
        Iterator iter = this.iterateRevisionsChain();
        while (iter.hasNext()) {
            PathRevision nodeToProcess = (PathRevision)iter.next();
            if (nodeToProcess.getRevision() >= node.getRevision()) break;
            prevNodeToProcess = nodeToProcess;
        }
        if (prevNodeToProcess == null) {
            node.setNext((PathRevision)this.getStartNodeInChain());
        } else if (prevNodeToProcess.getNext() == null) {
            prevNodeToProcess.setNext(node);
        } else {
            PathRevision tmpNode = (PathRevision)prevNodeToProcess.getNext();
            prevNodeToProcess.setNext(node);
            node.setNext(tmpNode);
        }
    }

    public PathRevision findNodeInChain(long revision) {
        Iterator iter = this.iterateRevisionsChain();
        while (iter.hasNext()) {
            PathRevision nodeToProcess = (PathRevision)iter.next();
            if (nodeToProcess.getRevision() != revision) continue;
            return nodeToProcess;
        }
        return null;
    }

    public String toString() {
        return String.format("%d@%d, action:%s", new Object[]{this.pathIndex, this.getRevision(), this.action});
    }

    public String toString(RepositoryCache repositoryCache) {
        return String.format("%s@%d, action:%s", new Object[]{repositoryCache.getPathStorage().getPath(this.pathIndex), this.getRevision(), this.action});
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PathRevision) {
            PathRevision node = (PathRevision)obj;
            return this.getRevision() == node.getRevision() && this.getPathIndex() == node.getPathIndex() && this.action == node.action;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = (int)((long)result + 31L * this.getRevision());
        result += 31 * this.getPathIndex();
        return result += 31 * this.action.hashCode();
    }

    public PathRevision[] getCopiedTo() {
        return (PathRevision[])super.getCopiedTo((NodeConnections[])new PathRevision[0]);
    }

    public CacheRevision getRevisionData() {
        return this.cacheRevision;
    }

    public void setValidator(PathRevisionConnectionsValidator validator) {
        this.validator = validator;
    }

    @Override
    protected void validate() {
        if (this.validator != null) {
            this.validator.validate(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReviosionNodeType {
        TRUNK,
        BRANCH,
        TAG,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RevisionNodeAction {
        ADD,
        DELETE,
        MODIFY,
        COPY,
        RENAME,
        NONE;

    }
}

