/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.preferences.SVNRevisionGraphPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCachesManager
implements IPropertyChangeListener {
    public static final String ADD_CACHES_PROPERTY = "addCaches";
    public static final String REMOVE_CACHES_PROPERTY = "removeCaches";
    protected static final String REPOSITORIES_FILE_NAME = "repositories.data";
    protected Map<String, RepositoryCacheInfo> caches = new HashMap<String, RepositoryCacheInfo>();
    protected File cacheFolder;
    protected final Object lock = new Object();
    protected Set<IPropertyChangeListener> listeners = Collections.synchronizedSet(new HashSet());

    public RepositoryCachesManager(File cacheFolder) throws IOException {
        this.cacheFolder = cacheFolder;
        if (!this.cacheFolder.exists()) {
            this.cacheFolder.mkdirs();
        } else {
            this.load();
        }
        SVNRevisionGraphPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void save() throws IOException {
        File file = new File(this.cacheFolder, REPOSITORIES_FILE_NAME);
        RepositoryCachesManager.saveRepositoryCachesData(file, this.caches.values());
    }

    protected static void saveRepositoryCachesData(File file, Collection<RepositoryCacheInfo> caches) throws IOException {
        if (!caches.isEmpty()) {
            PrintWriter out = new PrintWriter(file, "UTF-8");
            try {
                for (RepositoryCacheInfo cache : caches) {
                    out.println(cache.getRepositoryName());
                    out.println(cache.getMetaDataFile().getName());
                }
            }
            finally {
                out.close();
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    protected final void load() throws IOException {
        File file = new File(this.cacheFolder, REPOSITORIES_FILE_NAME);
        Map<String, String> rawData = RepositoryCachesManager.loadRawRepositoryCachesData(file);
        for (Map.Entry<String, String> entry : rawData.entrySet()) {
            String url = entry.getKey();
            String fileName = entry.getValue();
            File metadataFile = new File(this.cacheFolder, fileName);
            RepositoryCacheInfo cacheInfo = new RepositoryCacheInfo(url, metadataFile);
            cacheInfo.load();
            this.caches.put(url, cacheInfo);
        }
    }

    protected static Map<String, String> loadRawRepositoryCachesData(File file) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (file.exists()) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            try {
                String fileName;
                String url;
                while ((url = in.readLine()) != null && (fileName = in.readLine()) != null) {
                    result.put(url, fileName);
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryCacheInfo getCache(IRepositoryResource resource) throws IOException {
        RepositoryCacheInfo cacheInfo;
        Object object = this.lock;
        synchronized (object) {
            String url = RepositoryCachesManager.getRepositoryRoot(resource);
            cacheInfo = this.caches.get(url);
            if (cacheInfo == null) {
                File metadataFile = new File(this.cacheFolder, String.valueOf(RepositoryCachesManager.escapeUrl(url)) + ".meta");
                cacheInfo = new RepositoryCacheInfo(url, metadataFile);
                this.caches.put(url, cacheInfo);
                this.save();
            }
        }
        this.fireEvent(new PropertyChangeEvent((Object)this, ADD_CACHES_PROPERTY, null, (Object)new RepositoryCacheInfo[]{cacheInfo}));
        return cacheInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryCacheInfo[] getCaches() {
        Object object = this.lock;
        synchronized (object) {
            return this.caches.values().toArray(new RepositoryCacheInfo[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RepositoryCacheInfo[] cachesInfo) {
        if (cachesInfo.length > 0) {
            ArrayList<RepositoryCacheInfo> removedCaches = new ArrayList<RepositoryCacheInfo>();
            Object object = this.lock;
            synchronized (object) {
                RepositoryCacheInfo[] repositoryCacheInfoArray = cachesInfo;
                int n = cachesInfo.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryCacheInfo cache = repositoryCacheInfoArray[n2];
                    if (this.caches.containsKey(cache.getRepositoryName()) && cache.remove()) {
                        this.caches.remove(cache.getRepositoryName());
                        removedCaches.add(cache);
                    }
                    ++n2;
                }
                if (!removedCaches.isEmpty()) {
                    try {
                        this.save();
                    }
                    catch (IOException e) {
                        LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)e);
                    }
                }
            }
            if (!removedCaches.isEmpty()) {
                this.fireEvent(new PropertyChangeEvent((Object)this, REMOVE_CACHES_PROPERTY, null, (Object)removedCaches.toArray(new RepositoryCacheInfo[0])));
            }
        }
    }

    public void export(final File destinationFolder, final RepositoryCacheInfo[] cachesInfo) {
        if (cachesInfo.length > 0) {
            AbstractActionOperation op = new AbstractActionOperation("Operation_ExportCaches", SVNRevisionGraphMessages.class){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    if (!destinationFolder.exists() && !destinationFolder.mkdirs()) {
                        throw new UnreportableException("Failed to create destination folder: " + destinationFolder);
                    }
                    Object object = RepositoryCachesManager.this.lock;
                    synchronized (object) {
                        final ArrayList<RepositoryCacheInfo> exportedCaches = new ArrayList<RepositoryCacheInfo>();
                        RepositoryCacheInfo[] repositoryCacheInfoArray = cachesInfo;
                        int n = cachesInfo.length;
                        int n2 = 0;
                        while (n2 < n) {
                            final RepositoryCacheInfo cache = repositoryCacheInfoArray[n2];
                            if (monitor.isCanceled()) {
                                return;
                            }
                            this.protectStep(new IUnprotectedOperation(){

                                public void run(IProgressMonitor monitor) throws Exception {
                                    if ((this).RepositoryCachesManager.this.caches.containsKey(cache.getRepositoryName()) && cache.export(destinationFolder, monitor)) {
                                        exportedCaches.add(cache);
                                    }
                                }
                            }, monitor, cachesInfo.length, 1);
                            ++n2;
                        }
                        if (!exportedCaches.isEmpty()) {
                            File repositoriesFile = new File(destinationFolder, RepositoryCachesManager.REPOSITORIES_FILE_NAME);
                            RepositoryCachesManager.saveRepositoryCachesData(repositoriesFile, exportedCaches);
                        }
                    }
                }
            };
            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, (boolean)true);
        }
    }

    public void importCache(final File cacheDataFolder) {
        AbstractActionOperation op = new AbstractActionOperation("Operation_ImportCaches", SVNRevisionGraphMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (!cacheDataFolder.exists()) {
                    return;
                }
                File file = new File(cacheDataFolder, RepositoryCachesManager.REPOSITORIES_FILE_NAME);
                Map<String, String> rawRepositoriesData = RepositoryCachesManager.loadRawRepositoryCachesData(file);
                if (!rawRepositoriesData.isEmpty()) {
                    final ArrayList importedCaches = new ArrayList();
                    for (final Map.Entry<String, String> entry : rawRepositoriesData.entrySet()) {
                        if (monitor.isCanceled()) continue;
                        this.protectStep(new IUnprotectedOperation(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(IProgressMonitor monitor) throws Exception {
                                String url = (String)entry.getKey();
                                String metaFileName = (String)entry.getValue();
                                File metadataFile = new File(cacheDataFolder, metaFileName);
                                File cacheDataFile = new File(cacheDataFolder, RepositoryCacheInfo.getCacheDataFileName(metaFileName));
                                if (metadataFile.exists() && cacheDataFile.exists()) {
                                    FileUtility.copyFile((File)(this).RepositoryCachesManager.this.cacheFolder, (File)cacheDataFile, (IProgressMonitor)monitor);
                                    FileUtility.copyFile((File)(this).RepositoryCachesManager.this.cacheFolder, (File)metadataFile, (IProgressMonitor)monitor);
                                    File newMetadataFile = new File((this).RepositoryCachesManager.this.cacheFolder, metaFileName);
                                    RepositoryCacheInfo cacheInfo = new RepositoryCacheInfo(url, newMetadataFile);
                                    cacheInfo.load();
                                    Object object = (this).RepositoryCachesManager.this.lock;
                                    synchronized (object) {
                                        (this).RepositoryCachesManager.this.caches.put(url, cacheInfo);
                                        RepositoryCachesManager.this.save();
                                    }
                                    importedCaches.add(cacheInfo);
                                }
                            }
                        }, monitor, rawRepositoriesData.size(), 1);
                    }
                    if (!importedCaches.isEmpty()) {
                        RepositoryCachesManager.this.fireEvent(new PropertyChangeEvent((Object)this, RepositoryCachesManager.ADD_CACHES_PROPERTY, null, (Object)importedCaches.toArray(new RepositoryCacheInfo[0])));
                    }
                }
            }
        };
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeCacheFolder(File cacheFolder) throws IOException {
        RepositoryCacheInfo[] newCaches;
        RepositoryCacheInfo[] oldCaches;
        Object object = this.lock;
        synchronized (object) {
            oldCaches = this.getCaches();
            if (!this.caches.isEmpty()) {
                this.caches.clear();
            }
            this.cacheFolder = cacheFolder;
            if (!this.cacheFolder.exists()) {
                this.cacheFolder.mkdirs();
            } else {
                this.load();
            }
            newCaches = this.getCaches();
        }
        if (oldCaches.length > 0) {
            this.fireEvent(new PropertyChangeEvent((Object)this, REMOVE_CACHES_PROPERTY, null, (Object)oldCaches));
        }
        if (newCaches.length > 0) {
            this.fireEvent(new PropertyChangeEvent((Object)this, ADD_CACHES_PROPERTY, null, (Object)newCaches));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (SVNRevisionGraphPreferences.fullCacheName("directory").equals(event.getProperty())) {
            String cachePath = SVNRevisionGraphPreferences.getCacheString(SVNRevisionGraphPlugin.instance().getPreferenceStore(), "directory");
            File cacheFolder = new File(cachePath);
            try {
                this.changeCacheFolder(cacheFolder);
            }
            catch (Exception e) {
                LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        SVNRevisionGraphPlugin.instance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected static String getRepositoryRoot(IRepositoryResource resource) {
        String url = resource.getRepositoryLocation().getRepositoryRootUrl();
        String[] knownPrefixes = new String[]{"http://", "https://", "svn://", "svn+ssh://", "file:///", "file://"};
        int i = 0;
        while (i < knownPrefixes.length) {
            if (url.startsWith(knownPrefixes[i])) {
                url = url.substring(knownPrefixes[i].length());
                break;
            }
            ++i;
        }
        return url;
    }

    protected static String escapeUrl(String url) {
        try {
            url = url.replaceAll("[\\/:*?\"<>|]", "_");
            url = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return url;
    }

    public void addListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireEvent(PropertyChangeEvent event) {
        IPropertyChangeListener[] listenersArray;
        IPropertyChangeListener[] iPropertyChangeListenerArray = listenersArray = this.listeners.toArray(new IPropertyChangeListener[0]);
        int n = listenersArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            listener.propertyChange(event);
            ++n2;
        }
    }
}

