/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.TopRightTraverseVisitor;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;
import org.eclipse.team.svn.revision.graph.graphic.AbstractRevisionNodeFilter;
import org.eclipse.team.svn.revision.graph.graphic.ChangesNotifier;
import org.eclipse.team.svn.revision.graph.graphic.NodesFilterManager;
import org.eclipse.team.svn.revision.graph.graphic.RevisionConnectionNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionRootNode
extends ChangesNotifier {
    protected final IRepositoryResource resource;
    protected final PathRevision pathRevision;
    protected final RepositoryCache repositoryCache;
    protected RevisionNode initialStartNode;
    protected RevisionNode currentStartNode;
    protected RevisionNode lastNotNullCurrentStartNode;
    protected boolean isSimpleMode;
    protected NodesFilterManager filterManager;
    protected List<RevisionNode> currentNodesList = new ArrayList<RevisionNode>();
    protected Map<RevisionNode, List<RevisionConnectionNode>> currentSourceConnections = new HashMap<RevisionNode, List<RevisionConnectionNode>>();
    protected Map<RevisionNode, List<RevisionConnectionNode>> currentTargetConnections = new HashMap<RevisionNode, List<RevisionConnectionNode>>();

    public RevisionRootNode(IRepositoryResource resource, PathRevision node, RepositoryCache repositoryCache) {
        this.resource = resource;
        this.pathRevision = node;
        this.repositoryCache = repositoryCache;
        this.filterManager = new NodesFilterManager();
    }

    public void init(boolean isSimpleMode) {
        this.createRevisionNodesModel();
        this.setCurrentStartNode(this.initialStartNode);
        this.internalSetMode(isSimpleMode);
        this.filter(false);
    }

    public List<RevisionNode> getChildren() {
        return this.currentNodesList;
    }

    public List<RevisionConnectionNode> getConnections(RevisionNode node, boolean isSource) {
        List<RevisionConnectionNode> res = isSource ? this.currentSourceConnections.get(node) : this.currentTargetConnections.get(node);
        return res != null ? res : Collections.emptyList();
    }

    protected void changeModel(RevisionModelOperation op) {
        TimeMeasure processMeasure = new TimeMeasure("Re-structure nodes in model");
        boolean hasPreviousData = !this.currentNodesList.isEmpty();
        final HashSet previousNodes = new HashSet();
        if (this.currentStartNode != null) {
            new TopRightTraverseVisitor<RevisionNode>(){

                @Override
                public void visit(RevisionNode node) {
                    previousNodes.add(node);
                }
            }.traverse(this.currentStartNode);
        }
        HashSet<RevisionConnectionNode> previousConnections = new HashSet<RevisionConnectionNode>();
        for (List<RevisionConnectionNode> connections : this.currentSourceConnections.values()) {
            previousConnections.addAll(connections);
        }
        op.run();
        this.currentNodesList.clear();
        this.currentSourceConnections.clear();
        this.currentTargetConnections.clear();
        new TopRightTraverseVisitor<RevisionNode>(){

            @Override
            public void visit(RevisionNode node) {
                RevisionNode[] copiedTo;
                RevisionNode item = node;
                RevisionRootNode.this.currentNodesList.add(item);
                if (item.getNext() != null) {
                    RevisionRootNode.this.addCurrentConnection(item, item.getNext());
                }
                RevisionNode[] revisionNodeArray = copiedTo = item.getCopiedTo();
                int n = copiedTo.length;
                int n2 = 0;
                while (n2 < n) {
                    RevisionNode copyToItem = revisionNodeArray[n2];
                    RevisionRootNode.this.addCurrentConnection(item, copyToItem);
                    ++n2;
                }
            }
        }.traverse(this.currentStartNode);
        if (hasPreviousData) {
            HashSet<RevisionConnectionNode> newConnections = new HashSet<RevisionConnectionNode>();
            for (List<RevisionConnectionNode> connections : this.currentSourceConnections.values()) {
                newConnections.addAll(connections);
            }
            HashSet<RevisionNode> changedNodes = new HashSet<RevisionNode>();
            for (RevisionConnectionNode previousConnection : previousConnections) {
                if (newConnections.contains(previousConnection)) continue;
                changedNodes.add(previousConnection.source);
                changedNodes.add(previousConnection.target);
            }
            for (RevisionConnectionNode newConnection : newConnections) {
                if (previousConnections.contains(newConnection)) continue;
                if (previousNodes.contains(newConnection.source)) {
                    changedNodes.add(newConnection.source);
                }
                if (!previousNodes.contains(newConnection.target)) continue;
                changedNodes.add(newConnection.target);
            }
            for (RevisionNode changedNode : changedNodes) {
                changedNode.refreshConnections();
            }
        }
        processMeasure.end();
    }

    protected void addCurrentConnection(RevisionNode source, RevisionNode target) {
        RevisionConnectionNode con = new RevisionConnectionNode(source, target);
        List<RevisionConnectionNode> sourceConnections = this.currentSourceConnections.get(source);
        if (sourceConnections == null) {
            sourceConnections = new ArrayList<RevisionConnectionNode>();
            this.currentSourceConnections.put(source, sourceConnections);
        }
        sourceConnections.add(con);
        List<RevisionConnectionNode> targetConnections = this.currentTargetConnections.get(target);
        if (targetConnections == null) {
            targetConnections = new ArrayList<RevisionConnectionNode>();
            this.currentTargetConnections.put(target, targetConnections);
        }
        targetConnections.add(con);
    }

    protected final void createRevisionNodesModel() {
        RevisionNode first;
        LinkedList<RevisionNodeItem> queue = new LinkedList<RevisionNodeItem>();
        PathRevision pathFirst = (PathRevision)this.pathRevision.getStartNodeInGraph();
        this.initialStartNode = first = this.createRevisionNode(pathFirst);
        queue.offer(new RevisionNodeItem(first, pathFirst));
        RevisionNodeItem node = null;
        while ((node = (RevisionNodeItem)queue.poll()) != null) {
            PathRevision[] pathCopiedToNodes;
            PathRevision pathNext = (PathRevision)node.pathRevision.getNext();
            if (pathNext != null) {
                RevisionNode next = this.createRevisionNode(pathNext);
                node.revisionNode.setNext(next);
                queue.offer(new RevisionNodeItem(next, pathNext));
            }
            PathRevision[] pathRevisionArray = pathCopiedToNodes = node.pathRevision.getCopiedTo();
            int n = pathCopiedToNodes.length;
            int n2 = 0;
            while (n2 < n) {
                PathRevision pathCopiedToNode = pathRevisionArray[n2];
                RevisionNode copiedTo = this.createRevisionNode(pathCopiedToNode);
                node.revisionNode.addCopiedTo(copiedTo);
                queue.offer(new RevisionNodeItem(copiedTo, pathCopiedToNode));
                ++n2;
            }
        }
    }

    protected RevisionNode createRevisionNode(PathRevision pathRevision) {
        RevisionNode node = new RevisionNode(pathRevision, this);
        return node;
    }

    public boolean isSimpleMode() {
        return this.isSimpleMode;
    }

    protected void internalSetMode(boolean isSimpleMode) {
        this.isSimpleMode = isSimpleMode;
        if (this.isSimpleMode) {
            this.filterManager.addFilter(AbstractRevisionNodeFilter.SIMPLE_MODE_FILTER);
        } else {
            this.filterManager.removeFilter(AbstractRevisionNodeFilter.SIMPLE_MODE_FILTER);
        }
    }

    public void setMode(boolean isSimpleMode) {
        this.internalSetMode(isSimpleMode);
        this.filter(true);
    }

    public String getRevisionPath(int pathIndex) {
        return this.repositoryCache.getPathStorage().getPath(pathIndex);
    }

    public IRepositoryResource getRepositoryResource() {
        return this.resource;
    }

    public String getRevisionFullPath(RevisionNode revisionNode) {
        String url = this.resource.getRepositoryLocation().getRepositoryRootUrl();
        url = String.valueOf(url) + revisionNode.getPath();
        return url;
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    public RevisionNode getCurrentStartNode() {
        return this.currentStartNode;
    }

    protected void setCurrentStartNode(RevisionNode node) {
        if (node != null) {
            this.lastNotNullCurrentStartNode = node;
        }
        this.currentStartNode = node;
    }

    protected void filter(boolean isMakeNotification) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                RevisionRootNode.this.filterManager.applyFilters(RevisionRootNode.this.initialStartNode);
                RevisionNode candidateNode = this.findStartNode(RevisionRootNode.this.currentStartNode != null ? RevisionRootNode.this.currentStartNode : RevisionRootNode.this.lastNotNullCurrentStartNode);
                RevisionRootNode.this.setCurrentStartNode(candidateNode.isFiltered() ? candidateNode.getNext() : candidateNode);
            }
        });
        if (isMakeNotification) {
            this.firePropertyChange("filterNodes", null, new Boolean(this.isSimpleMode));
        }
    }

    public void collapseNext(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetNextCollapsed(true);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void collapseRename(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetRenameCollapsed(true);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void collapsePrevious(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetPreviousCollapsed(true);
                RevisionRootNode.this.setCurrentStartNode(node);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void collapseCopiedTo(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetCopiedToCollapsed(true);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void collapseCopiedFrom(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetCopiedFromCollapsed(true);
                RevisionRootNode.this.setCurrentStartNode(node);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void expandNext(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetNextCollapsed(false);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void expandRename(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetRenameCollapsed(false);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void expandPrevious(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetPreviousCollapsed(false);
                RevisionRootNode.this.setCurrentStartNode(this.findStartNode(node));
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void expandCopiedTo(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetCopiedToCollapsed(false);
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    public void expandCopiedFrom(final RevisionNode node) {
        this.changeModel(new RevisionModelOperation(){

            public void run() {
                node.internalSetCopiedFromCollapsed(false);
                RevisionRootNode.this.setCurrentStartNode(this.findStartNode(node));
            }
        });
        this.firePropertyChange("expandCollapseNodes", null, null);
    }

    protected abstract class RevisionModelOperation {
        protected RevisionModelOperation() {
        }

        public abstract void run();

        protected RevisionNode findStartNode(RevisionNode topNode) {
            if (topNode == null) {
                throw new IllegalArgumentException("Node can't be null");
            }
            RevisionNode startNode = topNode;
            while (true) {
                RevisionNode tmp;
                if ((tmp = startNode.getPrevious()) != null) {
                    startNode = tmp;
                    continue;
                }
                tmp = startNode.getCopiedFrom();
                if (tmp == null) break;
                startNode = tmp;
            }
            return startNode;
        }
    }

    protected static class RevisionNodeItem {
        final RevisionNode revisionNode;
        final PathRevision pathRevision;

        public RevisionNodeItem(RevisionNode revisionNode, PathRevision pathRevision) {
            this.revisionNode = revisionNode;
            this.pathRevision = pathRevision;
        }
    }
}

