/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.eclipse.ui.IWorkbenchPart;

public class CompareWithPreviousAction
extends BaseRevisionGraphAction {
    public static final String CompareWithPreviousAction_ID = "CompareWithPrevious";

    public CompareWithPreviousAction(IWorkbenchPart part) {
        super(part);
        this.setText(SVNRevisionGraphMessages.CompareWithPreviousRevisionAction);
        this.setId(CompareWithPreviousAction_ID);
        this.setToolTipText(SVNRevisionGraphMessages.CompareWithPreviousRevisionAction);
    }

    protected boolean calculateEnabled() {
        RevisionEditPart[] editParts = null;
        if (this.getSelectedEditParts().length == 1 && (editParts = this.getSelectedEditParts(BaseRevisionGraphAction.EXIST_IN_PREVIOUS_FILTER)).length == 1) {
            boolean isCompareAllowed;
            IRepositoryResource resource = BaseRevisionGraphAction.convertToResource(editParts[0]);
            boolean bl = isCompareAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 || resource instanceof IRepositoryFile;
            if (isCompareAllowed) {
                return true;
            }
        }
        return false;
    }

    public void run() {
        IRepositoryResource next = BaseRevisionGraphAction.convertToResource(this.getSelectedEditPart());
        IRepositoryResource prev = SVNUtility.copyOf((IRepositoryResource)next);
        prev.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)(((SVNRevision.Number)next.getSelectedRevision()).getNumber() - 1L)));
        prev.setPegRevision(next.getPegRevision());
        CompareRepositoryResourcesOperation op = new CompareRepositoryResourcesOperation(prev, next);
        op.setForceId(((Object)((Object)this)).toString());
        this.runOperation((IActionOperation)op);
    }
}

