/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;
import org.eclipse.team.svn.revision.graph.operation.CheckRepositoryConnectionOperation;
import org.eclipse.team.svn.revision.graph.operation.LogEntriesCallback;

public abstract class BaseFetchOperation
extends AbstractActionOperation {
    protected IRepositoryResource resource;
    protected CheckRepositoryConnectionOperation checkConnectionOp;
    protected RepositoryCache repositoryCache;
    protected boolean canRun;
    protected long startRevision;
    protected long endRevision;

    public BaseFetchOperation(String operationName, IRepositoryResource resource, CheckRepositoryConnectionOperation checkConnectionOp, RepositoryCache repositoryCache) {
        super(operationName, SVNRevisionGraphMessages.class);
        this.resource = resource;
        this.checkConnectionOp = checkConnectionOp;
        this.repositoryCache = repositoryCache;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        TimeMeasure measure = new TimeMeasure("Fetch revisions " + ((Object)((Object)this)).getClass().getName());
        if (this.checkConnectionOp.hasConnection()) {
            this.prepareData(monitor);
            if (this.canRun) {
                LogEntriesCallback callback = new LogEntriesCallback((IActionOperation)this, monitor, (int)(this.endRevision - this.startRevision + 1L), this.repositoryCache);
                ISVNConnector proxy = this.resource.getRepositoryLocation().acquireSVNProxy();
                try {
                    proxy.logEntries(SVNUtility.getEntryReference((IRepositoryResource)this.resource.getRepositoryLocation().getRepositoryRoot()), (SVNRevision)SVNRevision.fromNumber((long)this.endRevision), (SVNRevision)SVNRevision.fromNumber((long)this.startRevision), ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, 0L, 262144L, (ISVNLogEntryCallback)callback, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                }
                finally {
                    this.resource.getRepositoryLocation().releaseSVNProxy(proxy);
                    if (callback.getError() != null) {
                        Throwable t = callback.getError();
                        if (!(t instanceof RuntimeException)) {
                            t = new UnreportableException(t);
                        }
                        this.reportError(t);
                    }
                    if (this.repositoryCache.isDirty()) {
                        this.repositoryCache.save(monitor);
                    }
                }
            }
        }
        measure.end();
    }

    protected abstract void prepareData(IProgressMonitor var1) throws Exception;
}

