/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CheckRepositoryConnectionOperation
extends AbstractActionOperation {
    protected IRepositoryResource resource;
    protected boolean hasConnection;
    protected long lastRepositoryRevision;

    public CheckRepositoryConnectionOperation(IRepositoryResource resource) {
        super("Operation_CheckRepositoryConnection", SVNRevisionGraphMessages.class);
        this.resource = resource;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryRoot root = this.resource.getRepositoryLocation().getRepositoryRoot();
        try {
            this.lastRepositoryRevision = root.getRevision();
            this.hasConnection = this.lastRepositoryRevision != -1L;
        }
        catch (SVNConnectorException e) {
            if (e instanceof SVNConnectorCancelException) {
                throw e;
            }
            this.hasConnection = false;
        }
        if (!this.hasConnection) {
            final boolean[] isProceedWithoutConnection = new boolean[1];
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNRevisionGraphMessages.Dialog_GraphTitle, null, SVNRevisionGraphMessages.CheckRepositoryConnectionOperation_DialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    isProceedWithoutConnection[0] = dlg.open() == 0;
                }
            });
            if (!isProceedWithoutConnection[0]) {
                throw new ActivityCancelledException();
            }
        }
    }

    public boolean hasConnection() {
        return this.hasConnection;
    }

    public long getLastRepositoryRevision() {
        return this.lastRepositoryRevision;
    }
}

