/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogEntryCallbackWithMergeInfo;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;

public class LogEntriesCallback
extends SVNLogEntryCallbackWithMergeInfo {
    protected static final int REVISIONS_COUNT_FOR_SAVE = 50000;
    protected IActionOperation op;
    protected int totalWork;
    protected IProgressMonitor monitor;
    protected int currentWork;
    protected SVNLogEntry currentEntry;
    protected RepositoryCache repositoryCache;
    protected int processedRevisionsCount;
    protected Throwable error;

    public LogEntriesCallback(IActionOperation op, IProgressMonitor monitor, int totalWork, RepositoryCache repositoryCache) throws IOException {
        this.op = op;
        this.monitor = monitor;
        this.totalWork = totalWork;
        this.repositoryCache = repositoryCache;
    }

    protected void addEntry(SVNLogEntry entry) {
        if (this.error == null) {
            this.currentEntry = entry;
            ProgressMonitorUtility.setTaskInfo((IProgressMonitor)this.monitor, (IActionOperation)this.op, (String)SVNRevisionGraphMessages.format((String)SVNRevisionGraphMessages.LogEntriesCallback_Message, (Object)entry.revision));
            ProgressMonitorUtility.progress((IProgressMonitor)this.monitor, (int)(++this.currentWork), (int)this.totalWork);
            try {
                this.repositoryCache.addEntry(entry);
                if (++this.processedRevisionsCount % 50000 == 0) {
                    this.repositoryCache.save(this.monitor);
                }
                long start = this.repositoryCache.getCacheInfo().getStartSkippedRevision();
                long end = this.repositoryCache.getCacheInfo().getEndSkippedRevision();
                if (start > --end) {
                    end = 0L;
                    start = 0L;
                }
                this.repositoryCache.getCacheInfo().setSkippedRevisions(start, end);
            }
            catch (Throwable e) {
                this.error = e;
                this.monitor.setCanceled(true);
            }
        }
    }

    public Throwable getError() {
        return this.error;
    }
}

