/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditorInput;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.team.svn.revision.graph.operation.CreateCacheDataOperation;
import org.eclipse.team.svn.revision.graph.operation.CreateRevisionGraphModelOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IEditorInput;

public class RevisionGraphUtility {
    protected static final String EDITOR_ID = "org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditor";

    public static CompositeOperation getRevisionGraphOperation(final IRepositoryResource resource) {
        CompositeOperation op = new CompositeOperation("Operation_ShowRevisionGraph", SVNRevisionGraphMessages.class);
        CreateCacheDataOperation createCacheOp = new CreateCacheDataOperation(resource, false);
        op.add((IActionOperation)createCacheOp);
        final CreateRevisionGraphModelOperation createModelOp = new CreateRevisionGraphModelOperation(resource, createCacheOp);
        op.add((IActionOperation)createModelOp, new IActionOperation[]{createCacheOp});
        AbstractActionOperation showRevisionGraphOp = new AbstractActionOperation("Operation_ShowRevisionGraph", SVNRevisionGraphMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            Object modelObject = createModelOp.getModel() != null ? new RevisionRootNode(resource, createModelOp.getModel(), createModelOp.getRepositoryCache()) : SVNRevisionGraphMessages.NoData;
                            RevisionGraphEditorInput input = new RevisionGraphEditorInput(createModelOp.getResource(), modelObject);
                            UIMonitorUtility.getActivePage().openEditor((IEditorInput)input, RevisionGraphUtility.EDITOR_ID);
                        }
                        catch (Exception e) {
                            LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)e);
                        }
                    }
                });
            }
        };
        op.add((IActionOperation)showRevisionGraphOp, new IActionOperation[]{createModelOp});
        return op;
    }
}

