/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNOperation;
import org.eclipse.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.local.AbstractResourceSelectionPanel;
import org.eclipse.team.svn.ui.panel.local.AddToSVNPanel;
import org.eclipse.team.svn.ui.panel.local.IgnoreMethodPanel;

public class AddToSVNIgnoreAction
extends AbstractNonRecursiveTeamAction {
    public static IStateFilter SF_NEW_AND_PARENT_VERSIONED = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            IContainer parent;
            if (state == "New" && (parent = resource.getParent()) != null) {
                return IStateFilter.SF_VERSIONED.accept(SVNRemoteStorage.instance().asLocalResource((IResource)parent));
            }
            return false;
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state != "Ignored" && state != "Obstructed" && state != "Linked";
        }
    };

    public void runImpl(IAction action) {
        AbstractDialogPanel panel;
        IResource[] resources = this.getSelectedResources(SF_NEW_AND_PARENT_VERSIONED);
        IResource[] operableParents = FileUtility.getOperableParents((IResource[])resources, (IStateFilter)IStateFilter.SF_UNVERSIONED);
        if (operableParents.length > 0) {
            panel = new AddToSVNPanel(operableParents);
            DefaultDialog dialog1 = new DefaultDialog(this.getShell(), panel);
            if (dialog1.open() != 0) {
                return;
            }
            operableParents = ((AbstractResourceSelectionPanel)panel).getSelectedResources();
        }
        panel = new IgnoreMethodPanel(resources);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            AddToSVNIgnoreOperation mainOp = new AddToSVNIgnoreOperation(resources, ((IgnoreMethodPanel)panel).getIgnoreType(), ((IgnoreMethodPanel)panel).getIgnorePattern());
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            if (operableParents.length > 0) {
                op.add((IActionOperation)new AddToSVNOperation(operableParents));
                op.add((IActionOperation)new ClearLocalStatusesOperation(operableParents));
            }
            op.add((IActionOperation)mainOp);
            HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
            int i = 0;
            while (i < resources.length) {
                tmp.add((IResource)resources[i].getParent());
                ++i;
            }
            IResource[] resourcesAndParents = tmp.toArray(new IResource[tmp.size()]);
            op.add((IActionOperation)new RefreshResourcesOperation(resourcesAndParents, 2, RefreshResourcesOperation.REFRESH_ALL));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(SF_NEW_AND_PARENT_VERSIONED);
    }
}

