/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.CreatePatchOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.action.AbstractRepositoryModifyWorkspaceAction;
import org.eclipse.team.svn.ui.operation.FileToClipboardOperation;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.wizard.CreatePatchRemoteWizard;
import org.eclipse.team.svn.ui.wizard.CreatePatchWizard;

public class CreatePatchAction
extends AbstractRepositoryModifyWorkspaceAction {
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        CreatePatchWizard wizard = null;
        wizard = resources.length == 1 ? new CreatePatchRemoteWizard(resources[0], true) : new CreatePatchWizard(resources[0].getName(), null, true);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            IRepositoryResource second = resources.length == 1 ? ((CreatePatchRemoteWizard)wizard).getSelectedResource() : resources[1];
            try {
                if (resources[0].getRevision() > second.getRevision()) {
                    IRepositoryResource tmp = second;
                    second = resources[0];
                    resources[0] = tmp;
                }
                this.runScheduled(CreatePatchAction.getCreatePatchOperation(resources[0], second, wizard));
            }
            catch (SVNConnectorException ex) {
                UILoggedOperation.reportError(SVNMessages.Operation_CreatePatchRemote, ex);
            }
        }
    }

    public static IActionOperation getCreatePatchOperation(IRepositoryResource first, IRepositoryResource second, CreatePatchWizard wizard) {
        CreatePatchOperation mainOp = new CreatePatchOperation(first, second, wizard.getFileName(), wizard.isRecursive(), wizard.isIgnoreDeleted(), wizard.isProcessBinary(), wizard.isIgnoreAncestry());
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add((IActionOperation)mainOp);
        switch (wizard.getWriteMode()) {
            case 2: {
                op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{wizard.getTargetFolder()}, 1, RefreshResourcesOperation.REFRESH_CHANGES), new IActionOperation[]{mainOp});
                break;
            }
            case 0: {
                op.add((IActionOperation)new FileToClipboardOperation(wizard.getFileName()), new IActionOperation[]{mainOp});
            }
        }
        return op;
    }

    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        return resources.length == 1 || resources.length == 2;
    }
}

