/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.discovery;

import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.team.svn.core.discovery.util.WebUtil;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.svnstorage.SVNCachedProxyCredentialsManager;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.discovery.IConnectorsInstallJob;
import org.eclipse.team.svn.ui.discovery.wizards.ConnectorDiscoveryWizard;
import org.eclipse.team.svn.ui.panel.callback.PromptCredentialsPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.osgi.framework.Bundle;

public class DiscoveryConnectorsHelper {
    public void run(IProgressMonitor monitor) throws Exception {
        if (CoreExtensionsManager.instance().getAccessibleClients().isEmpty() && Platform.getBundle((String)"org.eclipse.equinox.p2.repository") != null) {
            final IConnectorsInstallJob[] installJob = new IConnectorsInstallJob[1];
            try {
                installJob[0] = this.getInstallJob();
            }
            catch (Throwable e) {
                throw new UnreportableException("Errors occured while initializing provisioning framework. This make cause discovery install to fail.", e);
            }
            if (installJob[0] != null) {
                WebUtil.setAuthenticator((Authenticator)new ProxyAuthenticator());
                UIMonitorUtility.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ConnectorDiscoveryWizard wizard = new ConnectorDiscoveryWizard(installJob[0]);
                        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
                        dialog.open();
                    }
                });
            }
        }
    }

    protected IConnectorsInstallJob getInstallJob() throws Exception {
        IConnectorsInstallJob runnable = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.engine");
        if (bundle != null) {
            Class<?> clazz = null;
            clazz = new VersionRange("[1.0.0,1.1.0)").isIncluded(bundle.getVersion()) ? Class.forName("org.eclipse.team.svn.ui.discovery.PrepareInstallProfileJob_3_5") : Class.forName("org.eclipse.team.svn.ui.discovery.PrepareInstallProfileJob_3_6");
            Constructor<?> c = clazz.getConstructor(new Class[0]);
            runnable = (IConnectorsInstallJob)c.newInstance(new Object[0]);
        }
        return runnable;
    }

    protected static class ProxyAuthenticator
    extends Authenticator {
        protected ProxyAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                SVNCachedProxyCredentialsManager proxyCredentialsManager = SVNRemoteStorage.instance().getProxyCredentialsManager();
                if (proxyCredentialsManager.getUsername() == null || proxyCredentialsManager.getUsername() == "") {
                    final boolean[] result = new boolean[1];
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            PromptCredentialsPanel panel = new PromptCredentialsPanel(ProxyAuthenticator.this.getRequestingPrompt(), 3);
                            DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                            if (dialog.open() == 0) {
                                result[0] = true;
                            }
                        }
                    });
                    if (result[0]) {
                        String pswd = proxyCredentialsManager.getPassword();
                        return new PasswordAuthentication(proxyCredentialsManager.getUsername(), pswd == null ? "".toCharArray() : pswd.toCharArray());
                    }
                } else {
                    String pswd = proxyCredentialsManager.getPassword();
                    return new PasswordAuthentication(proxyCredentialsManager.getUsername(), pswd == null ? "".toCharArray() : pswd.toCharArray());
                }
            }
            return null;
        }
    }
}

