/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.SpellcheckedTextProvider;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.EditCommentTemplatePanel;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.IntegerFieldVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.ui.PlatformUI;

public class SVNTeamCommentTemplatesPreferencesPage
extends AbstractSVNTeamPreferencesPage
implements ISelectionChangedListener {
    protected StyledText previewText;
    protected ListViewer listViewer;
    protected Button newButton;
    protected Button editButton;
    protected Button removeButton;
    protected Button useLogTemplatesButton;
    protected Button useTemplatesButton;
    protected int savedCommentsCount;
    protected Text savedCommentsCountField;
    protected boolean logTemplatesEnabled;
    protected boolean userTemplatesEnabled;

    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setCommentTemplatesInt(store, "savedCommentsCount", this.savedCommentsCount);
        SVNTeamPreferences.setCommentTemplatesBoolean(store, "comment.logTemplates.enabled", this.logTemplatesEnabled);
        SVNTeamPreferences.setCommentTemplatesBoolean(store, "comment.templates.enabled", this.userTemplatesEnabled);
        int numTemplates = this.listViewer.getList().getItemCount();
        String[] templates = new String[numTemplates];
        int i = 0;
        while (i < numTemplates) {
            templates[i] = (String)this.listViewer.getElementAt(i);
            ++i;
        }
        SVNTeamPreferences.setCommentTemplatesString(store, "comment.templates", FileUtility.encodeArrayToString((String[])templates));
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.savedCommentsCount = 10;
    }

    protected void loadValues(IPreferenceStore store) {
        this.savedCommentsCount = SVNTeamPreferences.getCommentTemplatesInt(store, "savedCommentsCount");
        this.logTemplatesEnabled = SVNTeamPreferences.getCommentTemplatesBoolean(store, "comment.logTemplates.enabled");
        this.userTemplatesEnabled = SVNTeamPreferences.getCommentTemplatesBoolean(store, "comment.templates.enabled");
    }

    protected void initializeControls() {
        this.savedCommentsCountField.setText(String.valueOf(this.savedCommentsCount));
        this.useLogTemplatesButton.setSelection(this.logTemplatesEnabled);
        this.useTemplatesButton.setSelection(this.userTemplatesEnabled);
        this.listViewer.getControl().setEnabled(this.userTemplatesEnabled);
        this.newButton.setEnabled(this.userTemplatesEnabled);
        this.previewText.setEnabled(this.userTemplatesEnabled);
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.editButton.setEnabled(this.userTemplatesEnabled && selection.size() == 1);
        this.removeButton.setEnabled(this.userTemplatesEnabled && selection.size() > 0);
        this.previewText.setText(selection.size() == 1 ? (String)selection.getFirstElement() : "");
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite checkBoxComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        checkBoxComposite.setLayout((Layout)layout);
        checkBoxComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(checkBoxComposite, 0);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        String labelText = SVNUIMessages.CommentTemplatesPreferencePage_historySavedCommentsCount;
        label.setText(labelText);
        this.savedCommentsCountField = new Text(checkBoxComposite, 2052);
        data = new GridData(768);
        this.savedCommentsCountField.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(labelText));
        verifier.add(new IntegerFieldVerifier(labelText, true));
        this.attachTo((Control)this.savedCommentsCountField, verifier);
        this.savedCommentsCountField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    SVNTeamCommentTemplatesPreferencesPage.this.savedCommentsCount = Integer.parseInt(SVNTeamCommentTemplatesPreferencesPage.this.savedCommentsCountField.getText());
                }
                catch (Exception exception) {}
            }
        });
        this.useLogTemplatesButton = new Button(checkBoxComposite, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.useLogTemplatesButton.setLayoutData((Object)data);
        this.useLogTemplatesButton.setText(SVNUIMessages.CommentTemplatesPreferencePage_LogTemplates);
        this.useLogTemplatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamCommentTemplatesPreferencesPage.this.logTemplatesEnabled = ((Button)e.widget).getSelection();
            }
        });
        this.useTemplatesButton = new Button(checkBoxComposite, 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.useTemplatesButton.setLayoutData((Object)data);
        this.useTemplatesButton.setText(SVNUIMessages.CommentTemplatesPreferencePage_UserTemplates);
        this.useTemplatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamCommentTemplatesPreferencesPage.this.selectionChanged(null);
            }
        });
        Label separator = new Label(checkBoxComposite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        separator.setLayoutData((Object)data);
        Label templatesLabel = new Label(composite, 0);
        templatesLabel.setText(SVNUIMessages.CommentTemplatesPreferencePage_EditHint);
        this.createTemplatesList(composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.commentTemplatesPreferencesContext");
        return composite;
    }

    protected Composite createTemplatesList(Composite parent) {
        Composite listAndButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        listAndButtons.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 430;
        listAndButtons.setLayoutData((Object)data);
        this.listViewer = new ListViewer(listAndButtons);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String template = (String)element;
                return FileUtility.flattenText((String)template);
            }
        });
        this.listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.listViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String template1 = FileUtility.flattenText((String)((String)e1));
                String template2 = FileUtility.flattenText((String)((String)e2));
                return template1.compareToIgnoreCase(template2);
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SVNTeamCommentTemplatesPreferencesPage.this.editTemplate();
            }
        });
        List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        String[] templates = FileUtility.decodeStringToArray((String)SVNTeamPreferences.getCommentTemplatesString(store, "comment.templates"));
        int i = 0;
        while (i < templates.length) {
            this.listViewer.add((Object)templates[i]);
            ++i;
        }
        this.createButtons(listAndButtons);
        Label previewLabel = new Label(listAndButtons, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        previewLabel.setLayoutData((Object)data);
        previewLabel.setText(SVNUIMessages.CommentTemplatesPreferencePage_ViewHint);
        data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        this.previewText = SpellcheckedTextProvider.getTextWidget(listAndButtons, data, 578);
        this.previewText.setEditable(false);
        return listAndButtons;
    }

    protected void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        this.newButton = new Button(buttons, 8);
        this.newButton.setText(SVNUIMessages.Button_New);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(this.newButton);
        this.newButton.setLayoutData((Object)data);
        this.newButton.setEnabled(true);
        this.newButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamCommentTemplatesPreferencesPage.this.newTemplate();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(SVNUIMessages.Button_Edit);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(this.editButton);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SVNTeamCommentTemplatesPreferencesPage.this.editTemplate();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(SVNUIMessages.Button_Remove);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth(this.removeButton);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SVNTeamCommentTemplatesPreferencesPage.this.remove();
            }
        });
    }

    protected void newTemplate() {
        EditCommentTemplatePanel panel = new EditCommentTemplatePanel(null);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            this.listViewer.add((Object)panel.getTemplate());
        }
    }

    protected void editTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        if (selection.size() == 1) {
            String oldTemplate = (String)selection.getFirstElement();
            EditCommentTemplatePanel panel = new EditCommentTemplatePanel(oldTemplate);
            DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
            if (dialog.open() == 0) {
                this.listViewer.remove((Object)oldTemplate);
                this.listViewer.add((Object)panel.getTemplate());
            }
        }
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.listViewer.remove(selection.toArray());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.userTemplatesEnabled = this.useTemplatesButton.getSelection();
        this.listViewer.getControl().setEnabled(this.userTemplatesEnabled);
        this.newButton.setEnabled(this.userTemplatesEnabled);
        this.previewText.setEnabled(this.userTemplatesEnabled);
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.editButton.setEnabled(this.userTemplatesEnabled && selection.size() == 1);
        this.removeButton.setEnabled(this.userTemplatesEnabled && selection.size() > 0);
        this.previewText.setText(selection.size() == 1 ? (String)selection.getFirstElement() : "");
    }
}

