/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.decorator.DecoratorVariables;
import org.eclipse.team.svn.ui.decorator.IVariable;
import org.eclipse.team.svn.ui.decorator.IVariableContentProvider;
import org.eclipse.team.svn.ui.decorator.TextVariableSetProvider;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.ListSelectionPanel;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNTeamDecorationPreferencesPage
extends AbstractSVNTeamPreferencesPage
implements IPropertyChangeListener {
    protected Button useFontsButton;
    protected boolean useFontsDecor;
    protected Button indicateConflictedButton;
    protected Button indicateModifiedButton;
    protected Button indicateRemoteButton;
    protected Button indicateAddedButton;
    protected Button indicateNewButton;
    protected Button indicateLockedButton;
    protected Button indicateNeedsLockButton;
    protected Button indicateSwitchedButton;
    protected boolean indicateConflicted;
    protected boolean indicateModified;
    protected boolean indicateRemote;
    protected boolean indicateAdded;
    protected boolean indicateNew;
    protected boolean indicateLocked;
    protected boolean indicateNeedsLock;
    protected boolean indicateSwitched;
    protected Text fileFormatField;
    protected Text folderFormatField;
    protected Text projectFormatField;
    protected String fileFormat;
    protected String folderFormat;
    protected String projectFormat;
    protected Preview preview;
    protected Text outgoingCharsField;
    protected Text addedCharsField;
    protected String outgoingChars;
    protected String addedChars;
    protected Text trunkPrefixField;
    protected Text branchPrefixField;
    protected Text tagPrefixField;
    protected String trunkPrefix;
    protected String branchPrefix;
    protected String tagPrefix;
    protected static final Collection<PreviewFile> ROOT;

    static {
        PreviewFile branchProject = new PreviewFile("ProjectBranch", 4, false, false, false, false, false, true, false, false, false, true, false, false);
        PreviewFile tagProject = new PreviewFile("ProjectTag", 4, false, false, false, false, false, true, false, false, false, false, true, false);
        PreviewFile project = new PreviewFile("Project", 4, false, false, true, false, false, true, false, false, true, false, false, false);
        PreviewFile modifiedFolder = new PreviewFile("folder", 2, false, false, true, false, false, true, false, false, true, false, false, false);
        ArrayList<PreviewFile> children = new ArrayList<PreviewFile>();
        children.add(new PreviewFile("switched", 2, false, false, false, false, false, true, false, false, true, false, false, true));
        children.add(new PreviewFile("normal.txt", 1, false, false, false, false, false, true, false, false, true, false, false, false));
        children.add(new PreviewFile("modified.cpp", 1, false, false, true, false, false, true, false, false, true, false, false, false));
        children.add(new PreviewFile("conflicting.cpp", 1, false, false, true, true, false, true, false, false, true, false, false, false));
        children.add(new PreviewFile("ignored.txt", 1, false, false, false, false, true, false, false, false, true, false, false, false));
        modifiedFolder.children = children;
        children = new ArrayList();
        children.add(modifiedFolder);
        children.add(new PreviewFile("new", 1, false, true, false, false, false, false, false, false, true, false, false, false));
        children.add(new PreviewFile("added.java", 1, true, false, true, false, false, false, false, false, true, false, false, false));
        children.add(new PreviewFile("locked", 1, false, false, false, false, false, true, true, false, true, false, false, false));
        children.add(new PreviewFile("needsLock", 1, false, false, false, false, false, true, false, true, true, false, false, false));
        project.children = children;
        ROOT = new ArrayList<PreviewFile>();
        ROOT.add(project);
        ROOT.add(branchProject);
        ROOT.add(tagProject);
    }

    public SVNTeamDecorationPreferencesPage() {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setDecorationString(store, "format.file", this.fileFormat);
        SVNTeamPreferences.setDecorationString(store, "format.folder", this.folderFormat);
        SVNTeamPreferences.setDecorationString(store, "format.project", this.projectFormat);
        SVNTeamPreferences.setDecorationString(store, "flag.outgoing", this.outgoingChars);
        SVNTeamPreferences.setDecorationString(store, "flag.added", this.addedChars);
        SVNTeamPreferences.setDecorationString(store, "trunk.branch", this.trunkPrefix);
        SVNTeamPreferences.setDecorationString(store, "prefix.branch", this.branchPrefix);
        SVNTeamPreferences.setDecorationString(store, "prefix.tag", this.tagPrefix);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.conflicted", this.indicateConflicted);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.modified", this.indicateModified);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.remote", this.indicateRemote);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.added", this.indicateAdded);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.new", this.indicateNew);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.locked", this.indicateLocked);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.needslock", this.indicateNeedsLock);
        SVNTeamPreferences.setDecorationBoolean(store, "icon.switched", this.indicateSwitched);
        SVNTeamPreferences.setDecorationBoolean(store, "use.fontdecor", this.useFontsDecor);
    }

    @Override
    protected void loadDefaultValues(IPreferenceStore store) {
        this.fileFormat = "{outgoing_flag} {name} {revision}";
        this.folderFormat = "{outgoing_flag} {name} {revision}";
        this.projectFormat = "{outgoing_flag} {name} {revision} [{location_label}{root_prefix}: {first_branchOrTag_child}]";
        this.outgoingChars = ">";
        this.addedChars = "*";
        this.trunkPrefix = ", Trunk";
        this.branchPrefix = ", Branch";
        this.tagPrefix = ", Tag";
        this.indicateConflicted = true;
        this.indicateModified = false;
        this.indicateRemote = true;
        this.indicateAdded = true;
        this.indicateNew = true;
        this.indicateLocked = true;
        this.indicateNeedsLock = false;
        this.indicateSwitched = true;
        this.useFontsDecor = false;
    }

    @Override
    protected void loadValues(IPreferenceStore store) {
        this.fileFormat = SVNTeamPreferences.getDecorationString(store, "format.file");
        this.folderFormat = SVNTeamPreferences.getDecorationString(store, "format.folder");
        this.projectFormat = SVNTeamPreferences.getDecorationString(store, "format.project");
        this.outgoingChars = SVNTeamPreferences.getDecorationString(store, "flag.outgoing");
        this.addedChars = SVNTeamPreferences.getDecorationString(store, "flag.added");
        this.trunkPrefix = SVNTeamPreferences.getDecorationString(store, "trunk.branch");
        this.branchPrefix = SVNTeamPreferences.getDecorationString(store, "prefix.branch");
        this.tagPrefix = SVNTeamPreferences.getDecorationString(store, "prefix.tag");
        this.indicateConflicted = SVNTeamPreferences.getDecorationBoolean(store, "icon.conflicted");
        this.indicateModified = SVNTeamPreferences.getDecorationBoolean(store, "icon.modified");
        this.indicateRemote = SVNTeamPreferences.getDecorationBoolean(store, "icon.remote");
        this.indicateAdded = SVNTeamPreferences.getDecorationBoolean(store, "icon.added");
        this.indicateNew = SVNTeamPreferences.getDecorationBoolean(store, "icon.new");
        this.indicateLocked = SVNTeamPreferences.getDecorationBoolean(store, "icon.locked");
        this.indicateNeedsLock = SVNTeamPreferences.getDecorationBoolean(store, "icon.needslock");
        this.indicateSwitched = SVNTeamPreferences.getDecorationBoolean(store, "icon.switched");
        this.useFontsDecor = SVNTeamPreferences.getDecorationBoolean(store, "use.fontdecor");
    }

    @Override
    protected void initializeControls() {
        this.fileFormatField.setText(this.fileFormat);
        this.folderFormatField.setText(this.folderFormat);
        this.projectFormatField.setText(this.projectFormat);
        this.outgoingCharsField.setText(this.outgoingChars);
        this.addedCharsField.setText(this.addedChars);
        this.trunkPrefixField.setText(this.trunkPrefix);
        this.branchPrefixField.setText(this.branchPrefix);
        this.tagPrefixField.setText(this.tagPrefix);
        this.indicateConflictedButton.setSelection(this.indicateConflicted);
        this.indicateModifiedButton.setSelection(this.indicateModified);
        this.indicateRemoteButton.setSelection(this.indicateRemote);
        this.indicateAddedButton.setSelection(this.indicateAdded);
        this.indicateNewButton.setSelection(this.indicateNew);
        this.indicateLockedButton.setSelection(this.indicateLocked);
        this.indicateNeedsLockButton.setSelection(this.indicateNeedsLock);
        this.indicateSwitchedButton.setSelection(this.indicateSwitched);
        this.useFontsButton.setSelection(this.useFontsDecor);
        this.refreshPreview();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("preference.dateFormat.")) {
            this.refreshPreview();
        }
    }

    @Override
    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.PreferencePage_generalTabName);
        tabItem.setControl((Control)this.createGeneralSettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.PreferencePage_textTabName);
        tabItem.setControl((Control)this.createTextSettingsPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.PreferencePage_iconsTabName);
        tabItem.setControl((Control)this.createIconsSettingsPage((Composite)tabFolder));
        this.preview = new Preview(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.decorsPreferencesContext");
        return tabFolder;
    }

    protected Composite createTextSettingsPage(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 450;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.PreferencePage_textPrompt);
        Composite groups = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        groups.setLayout((Layout)layout);
        data = new GridData(768);
        groups.setLayoutData((Object)data);
        Group formatGroup = new Group(groups, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 1;
        formatGroup.setLayout((Layout)layout);
        formatGroup.setLayoutData((Object)new GridData(768));
        formatGroup.setText("Format");
        ArrayList<IVariable> fileOptions = new ArrayList<IVariable>();
        fileOptions.add(TextVariableSetProvider.VAR_OUTGOING_FLAG);
        fileOptions.add(TextVariableSetProvider.VAR_ADDED_FLAG);
        fileOptions.add(TextVariableSetProvider.VAR_NAME);
        fileOptions.add(TextVariableSetProvider.VAR_REVISION);
        fileOptions.add(TextVariableSetProvider.VAR_DATE);
        fileOptions.add(TextVariableSetProvider.VAR_AUTHOR);
        fileOptions.add(TextVariableSetProvider.VAR_RESOURCE_URL);
        this.fileFormatField = this.createFormatControl((Composite)formatGroup, "PreferencePage_textFileFormat", fileOptions, Collections.<Object>emptyList());
        this.fileFormatField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.fileFormat = SVNTeamDecorationPreferencesPage.this.fileFormatField.getText();
            }
        });
        ArrayList<IVariable> folderOptions = new ArrayList<IVariable>();
        folderOptions.addAll(fileOptions);
        this.folderFormatField = this.createFormatControl((Composite)formatGroup, "PreferencePage_textFolderFormat", folderOptions, Collections.<Object>emptyList());
        this.folderFormatField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.folderFormat = SVNTeamDecorationPreferencesPage.this.folderFormatField.getText();
            }
        });
        ArrayList<IVariable> projectOptions = new ArrayList<IVariable>();
        projectOptions.add(TextVariableSetProvider.VAR_OUTGOING_FLAG);
        projectOptions.add(TextVariableSetProvider.VAR_NAME);
        projectOptions.add(TextVariableSetProvider.VAR_REVISION);
        projectOptions.add(TextVariableSetProvider.VAR_LOCATION_LABEL);
        projectOptions.add(TextVariableSetProvider.VAR_LOCATION_URL);
        projectOptions.add(TextVariableSetProvider.VAR_ROOT_PREFIX);
        projectOptions.add(TextVariableSetProvider.VAR_ASCENDANT);
        projectOptions.add(TextVariableSetProvider.VAR_DESCENDANT);
        projectOptions.add(TextVariableSetProvider.VAR_FULLNAME);
        projectOptions.add(TextVariableSetProvider.VAR_RESOURCE_URL);
        projectOptions.add(TextVariableSetProvider.VAR_SHORT_RESOURCE_URL);
        projectOptions.add(TextVariableSetProvider.VAR_REMOTE_NAME);
        projectOptions.add(TextVariableSetProvider.VAR_DATE);
        projectOptions.add(TextVariableSetProvider.VAR_AUTHOR);
        this.projectFormatField = this.createFormatControl((Composite)formatGroup, "PreferencePage_textProjectFormat", projectOptions, Collections.<Object>emptyList());
        this.projectFormatField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.projectFormat = SVNTeamDecorationPreferencesPage.this.projectFormatField.getText();
            }
        });
        ArrayList<Object> grayedOptions = new ArrayList<Object>();
        grayedOptions.add(projectOptions.get(5));
        Group prefixGroup = new Group(groups, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 1;
        prefixGroup.setLayout((Layout)layout);
        prefixGroup.setLayoutData((Object)new GridData(768));
        prefixGroup.setText("Root Prefix");
        this.trunkPrefixField = this.createFormatControl((Composite)prefixGroup, "PreferencePage_textTrunkPrefix", projectOptions, grayedOptions);
        this.trunkPrefixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.trunkPrefix = SVNTeamDecorationPreferencesPage.this.trunkPrefixField.getText();
            }
        });
        this.branchPrefixField = this.createFormatControl((Composite)prefixGroup, "PreferencePage_textBranchPrefix", projectOptions, grayedOptions);
        this.branchPrefixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.branchPrefix = SVNTeamDecorationPreferencesPage.this.branchPrefixField.getText();
            }
        });
        this.tagPrefixField = this.createFormatControl((Composite)prefixGroup, "PreferencePage_textTagPrefix", projectOptions, grayedOptions);
        this.tagPrefixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.tagPrefix = SVNTeamDecorationPreferencesPage.this.tagPrefixField.getText();
            }
        });
        Composite outFlagComposite = new Composite(groups, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outFlagComposite.setLayout((Layout)layout);
        outFlagComposite.setLayoutData((Object)new GridData(768));
        label = new Label(outFlagComposite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.PreferencePage_textOutgoingFlag);
        this.outgoingCharsField = new Text(outFlagComposite, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.outgoingCharsField.setLayoutData((Object)data);
        this.outgoingCharsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.outgoingChars = SVNTeamDecorationPreferencesPage.this.outgoingCharsField.getText();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        Composite addFlagComposite = new Composite(groups, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        addFlagComposite.setLayout((Layout)layout);
        addFlagComposite.setLayoutData((Object)new GridData(768));
        label = new Label(addFlagComposite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.PreferencePage_textAddedFlag);
        this.addedCharsField = new Text(addFlagComposite, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.addedCharsField.setLayoutData((Object)data);
        this.addedCharsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.addedChars = SVNTeamDecorationPreferencesPage.this.addedCharsField.getText();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        return composite;
    }

    protected Text createFormatControl(Composite parent, String labelId, final List<IVariable> variables, final List<Object> grayedVariables) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        if (labelId != null) {
            label.setText(SVNUIMessages.getString(labelId));
        } else {
            label.setText("");
        }
        final Text format = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.widthHint = 100;
        data.grabExcessHorizontalSpace = true;
        format.setLayoutData((Object)data);
        Button addVariables = new Button(parent, 8);
        addVariables.setText(SVNUIMessages.PreferencePage_textAddVariables);
        data = new GridData();
        data.widthHint = 25;
        addVariables.setLayoutData((Object)data);
        addVariables.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.variableConfigurationDialog(format, variables, grayedVariables);
            }
        });
        format.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        return format;
    }

    protected void variableConfigurationDialog(Text field, List<IVariable> variableList, List<Object> grayedVariableList) {
        final IVariable[] variables = variableList.toArray(new IVariable[variableList.size()]);
        Object[] grayedVariables = grayedVariableList.toArray(new IVariable[grayedVariableList.size()]);
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return variables;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                IVariable var = (IVariable)element;
                return String.valueOf(var.getName()) + " - " + var.getDescription();
            }
        };
        String dialogPrompt = SVNUIMessages.PreferencePage_textAddVariablesPrompt;
        String dialogMessage = SVNUIMessages.PreferencePage_textAddVariablesMessage;
        DecoratorVariables decorator = new DecoratorVariables(TextVariableSetProvider.instance);
        Object[] realVars = decorator.parseFormatLine(field.getText());
        ListSelectionPanel panel = new ListSelectionPanel(this, contentProvider, (IBaseLabelProvider)labelProvider, dialogPrompt, dialogMessage);
        panel.setInitialSelections(realVars);
        panel.setInitialGrayed(grayedVariables);
        if (new DefaultDialog(this.getShell(), panel).open() == 0) {
            ArrayList<Object> result = new ArrayList<Object>();
            List<Object> newSelection = Arrays.asList(panel.getResultSelections());
            int i = 0;
            while (i < realVars.length) {
                if (TextVariableSetProvider.instance.getVariable(realVars[i].getName()) == null) {
                    result.add(realVars[i]);
                } else if (newSelection.contains(realVars[i])) {
                    result.add(realVars[i]);
                }
                ++i;
            }
            i = 0;
            while (i < newSelection.size()) {
                if (!result.contains(newSelection.get(i))) {
                    result.add(newSelection.get(i));
                }
                ++i;
            }
            realVars = result.toArray(new IVariable[result.size()]);
            field.setText(DecoratorVariables.prepareFormatLine((IVariable[])realVars));
        }
    }

    protected Composite createIconsSettingsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.PreferencePage_iconsPrompt);
        this.indicateModifiedButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateModifiedButton.setLayoutData((Object)data);
        this.indicateModifiedButton.setText(SVNUIMessages.PreferencePage_iconsIndicateModified);
        this.indicateModifiedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateModified = SVNTeamDecorationPreferencesPage.this.indicateModifiedButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateConflictedButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateConflictedButton.setLayoutData((Object)data);
        this.indicateConflictedButton.setText(SVNUIMessages.PreferencePage_iconsIndicateConflicted);
        this.indicateConflictedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateConflicted = SVNTeamDecorationPreferencesPage.this.indicateConflictedButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateRemoteButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateRemoteButton.setLayoutData((Object)data);
        this.indicateRemoteButton.setText(SVNUIMessages.PreferencePage_iconsIndicateRemote);
        this.indicateRemoteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateRemote = SVNTeamDecorationPreferencesPage.this.indicateRemoteButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateLockedButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateLockedButton.setLayoutData((Object)data);
        this.indicateLockedButton.setText(SVNUIMessages.PreferencePage_iconsIndicateLocked);
        this.indicateLockedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateLocked = SVNTeamDecorationPreferencesPage.this.indicateLockedButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateAddedButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateAddedButton.setLayoutData((Object)data);
        this.indicateAddedButton.setText(SVNUIMessages.PreferencePage_iconsIndicateAdded);
        this.indicateAddedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateAdded = SVNTeamDecorationPreferencesPage.this.indicateAddedButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateNeedsLockButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateNeedsLockButton.setLayoutData((Object)data);
        this.indicateNeedsLockButton.setText(SVNUIMessages.PreferencePage_iconsIndicateNeedsLock);
        this.indicateNeedsLockButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateNeedsLock = SVNTeamDecorationPreferencesPage.this.indicateNeedsLockButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateNewButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateNewButton.setLayoutData((Object)data);
        this.indicateNewButton.setText(SVNUIMessages.PreferencePage_iconsIndicateNew);
        this.indicateNewButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateNew = SVNTeamDecorationPreferencesPage.this.indicateNewButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        this.indicateSwitchedButton = new Button(composite, 32);
        data = new GridData(768);
        this.indicateSwitchedButton.setLayoutData((Object)data);
        this.indicateSwitchedButton.setText(SVNUIMessages.PreferencePage_iconsIndicateSwitched);
        this.indicateSwitchedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.indicateSwitched = SVNTeamDecorationPreferencesPage.this.indicateSwitchedButton.getSelection();
                SVNTeamDecorationPreferencesPage.this.refreshPreview();
            }
        });
        return composite;
    }

    protected Composite createGeneralSettingsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Composite noteComposite = new Composite(composite, 4);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        noteComposite.setLayout((Layout)layout);
        noteComposite.setLayoutData((Object)new GridData(768));
        Label noteLabel = new Label(noteComposite, 64);
        GridData data = new GridData(772);
        data.heightHint = this.convertHeightInCharsToPixels(4);
        data.widthHint = 200;
        noteLabel.setLayoutData((Object)data);
        noteLabel.setText(SVNUIMessages.PreferencePage_noteLabel);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        new PreferenceLinkArea(composite, 0, SVNUIMessages.PreferencePage_generalUseLabels_1, SVNUIMessages.PreferencePage_generalUseLabels_2, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        this.useFontsButton = new Button(composite, 32);
        this.useFontsButton.setLayoutData((Object)new GridData());
        this.useFontsButton.setText(SVNUIMessages.PreferencePage_generalUseFonts_2);
        new PreferenceLinkArea(composite, 0, SVNUIMessages.PreferencePage_generalUseFonts_1, SVNUIMessages.PreferencePage_generalUseFonts_3, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        this.useFontsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNTeamDecorationPreferencesPage.this.useFontsDecor = SVNTeamDecorationPreferencesPage.this.useFontsButton.getSelection();
            }
        });
        return composite;
    }

    protected ImageDescriptor getOverlay(PreviewFile element) {
        if (element.ignored) {
            return null;
        }
        if (element.locked && this.indicateLocked) {
            return SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/lock.gif");
        }
        if (element.isSwitched && this.indicateSwitched) {
            return SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/switched.gif");
        }
        if (element.needsLock && this.indicateNeedsLock) {
            return SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/needs_lock.gif");
        }
        if (element.newResource && this.indicateNew) {
            return SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/new_resource.gif");
        }
        if (element.added && this.indicateAdded) {
            return TeamImages.getImageDescriptor((String)"ovr/waiting_ovr.gif");
        }
        if (element.conflicted && this.indicateConflicted) {
            return SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/conflicted_unresolved.gif");
        }
        if (element.dirty && this.indicateModified) {
            return TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
        }
        if (element.hasRemote && this.indicateRemote) {
            return TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif");
        }
        return null;
    }

    protected void refreshPreview() {
        if (this.preview != null) {
            this.preview.refresh();
        }
    }

    protected class DemoDecoration {
        protected String fullName;

        public DemoDecoration(String baseName) {
            this.fullName = baseName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void addPrefix(String prefix) {
            this.fullName = String.valueOf(prefix) + this.fullName;
        }

        public void addSuffix(String suffix) {
            this.fullName = String.valueOf(this.fullName) + suffix;
        }

        public void addOverlay(ImageDescriptor overlay) {
        }

        public void addOverlay(ImageDescriptor overlay, int quadrant) {
        }

        public void setFont(Font font) {
        }

        public void setForegroundColor(Color color) {
        }

        public void setBackgroundColor(Color color) {
        }
    }

    protected class DemoVariableContentProvider
    implements IVariableContentProvider {
        protected PreviewFile preview;
        protected String demoRevision;

        public DemoVariableContentProvider(PreviewFile preview, String demoRevision) {
            this.preview = preview;
            this.demoRevision = demoRevision;
        }

        public String getValue(IVariable var) {
            if (var.equals(TextVariableSetProvider.VAR_ADDED_FLAG)) {
                if (this.preview.added) {
                    return SVNTeamDecorationPreferencesPage.this.addedChars;
                }
                return "";
            }
            if (var.equals(TextVariableSetProvider.VAR_OUTGOING_FLAG)) {
                if (this.preview.dirty) {
                    return SVNTeamDecorationPreferencesPage.this.outgoingChars;
                }
                return "";
            }
            if (var.equals(TextVariableSetProvider.VAR_ROOT_PREFIX)) {
                if (this.preview.isTag) {
                    return SVNTeamDecorationPreferencesPage.this.tagPrefix;
                }
                if (this.preview.isBranch) {
                    return SVNTeamDecorationPreferencesPage.this.branchPrefix;
                }
                if (this.preview.isTrunk) {
                    return SVNTeamDecorationPreferencesPage.this.trunkPrefix;
                }
                return "";
            }
            if (var.equals(TextVariableSetProvider.VAR_ASCENDANT)) {
                return SVNUIMessages.PreferencePage_demoAscendant;
            }
            if (var.equals(TextVariableSetProvider.VAR_DESCENDANT)) {
                return SVNUIMessages.PreferencePage_demoDescendant;
            }
            if (var.equals(TextVariableSetProvider.VAR_FULLNAME)) {
                return SVNUIMessages.PreferencePage_demoFullname;
            }
            if (var.equals(TextVariableSetProvider.VAR_AUTHOR)) {
                return SVNUIMessages.PreferencePage_demoAuthor;
            }
            if (var.equals(TextVariableSetProvider.VAR_NAME)) {
                return this.preview.name;
            }
            if (var.equals(TextVariableSetProvider.VAR_LOCATION_URL)) {
                return SVNUIMessages.PreferencePage_demoLocationURL;
            }
            if (var.equals(TextVariableSetProvider.VAR_LOCATION_LABEL)) {
                return SVNUIMessages.PreferencePage_demoLocationLabel;
            }
            if (var.equals(TextVariableSetProvider.VAR_RESOURCE_URL)) {
                return SVNUIMessages.PreferencePage_demoResourceURL;
            }
            if (var.equals(TextVariableSetProvider.VAR_SHORT_RESOURCE_URL)) {
                return SVNUIMessages.PreferencePage_demoShortURL;
            }
            if (var.equals(TextVariableSetProvider.VAR_REMOTE_NAME)) {
                return SVNUIMessages.PreferencePage_demoRemoteName;
            }
            if (var.equals(TextVariableSetProvider.VAR_DATE)) {
                return DateFormatter.formatDate(new Date());
            }
            if (var.equals(TextVariableSetProvider.VAR_REVISION)) {
                return this.demoRevision;
            }
            return var.toString();
        }
    }

    protected class Preview
    extends LabelProvider
    implements Observer,
    ITreeContentProvider {
        protected Map<ImageDescriptor, Image> images;
        private final TreeViewer fViewer;
        protected DecoratorVariables decoratorVariables = new DecoratorVariables(TextVariableSetProvider.instance);

        public Preview(Composite parent) {
            this.images = new HashMap<ImageDescriptor, Image>();
            Composite composite = new Composite(parent, 4);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.grabExcessVerticalSpace = true;
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(SVNUIMessages.PreferencePage_preview);
            this.fViewer = new TreeViewer(composite);
            data = new GridData(1808);
            data.heightHint = Math.max(SVNTeamDecorationPreferencesPage.this.convertHeightInCharsToPixels(1), 16) * 13;
            this.fViewer.getControl().setLayoutData((Object)data);
            this.fViewer.setContentProvider((IContentProvider)this);
            this.fViewer.setLabelProvider((IBaseLabelProvider)this);
            this.fViewer.setInput(ROOT);
            this.fViewer.expandAll();
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)ROOT.iterator().next()));
            this.fViewer.getTree().showSelection();
            this.fViewer.setSelection(null);
        }

        public void refresh() {
            this.fViewer.refresh(true);
        }

        public void update(Observable o, Object arg) {
            this.refresh();
        }

        public Object[] getChildren(Object parentElement) {
            return ((PreviewFile)parentElement).children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((PreviewFile)element).children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void dispose() {
            for (Image image : this.images.values()) {
                image.dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            DemoVariableContentProvider provider = null;
            IVariable[] realVars = null;
            PreviewFile previewFile = (PreviewFile)element;
            switch (previewFile.type) {
                case 4: {
                    provider = new DemoVariableContentProvider(previewFile, SVNUIMessages.PreferencePage_demoProjectRevision);
                    realVars = this.decoratorVariables.parseFormatLine(SVNTeamDecorationPreferencesPage.this.projectFormatField.getText());
                    break;
                }
                case 2: {
                    provider = new DemoVariableContentProvider(previewFile, SVNUIMessages.PreferencePage_demoFolderRevision);
                    realVars = this.decoratorVariables.parseFormatLine(SVNTeamDecorationPreferencesPage.this.folderFormatField.getText());
                    break;
                }
                default: {
                    provider = new DemoVariableContentProvider(previewFile, SVNUIMessages.PreferencePage_demoFileRevision);
                    realVars = this.decoratorVariables.parseFormatLine(SVNTeamDecorationPreferencesPage.this.fileFormatField.getText());
                }
            }
            DemoDecoration decoration = new DemoDecoration(previewFile.name);
            this.decorateText(decoration, realVars, provider);
            return decoration.getFullName();
        }

        private String getValue(IVariable var, IVariableContentProvider provider) {
            return this.amend(var, provider);
        }

        private String amend(IVariable var, IVariableContentProvider provider) {
            IVariable[] variables = this.decoratorVariables.parseFormatLine(provider.getValue(var));
            String value = "";
            int i = 0;
            while (i < variables.length) {
                String variableValue = provider.getValue(variables[i]);
                value = !variables[i].equals(var) ? String.valueOf(value) + variableValue : (variableValue.equals(variables[i].getName()) ? String.valueOf(value) + variableValue : String.valueOf(value) + "?{" + variables[i].getName() + "}?");
                ++i;
            }
            return value;
        }

        public void decorateText(DemoDecoration decoration, IVariable[] format, IVariableContentProvider provider) {
            int centerPoint = Arrays.asList(format).indexOf(TextVariableSetProvider.instance.getCenterVariable());
            String prefix = "";
            String suffix = "";
            int i = 0;
            while (i < format.length) {
                if (!format[i].equals(TextVariableSetProvider.instance.getCenterVariable())) {
                    if (centerPoint != -1 && i < centerPoint) {
                        prefix = String.valueOf(prefix) + this.getValue(format[i], provider);
                    } else {
                        suffix = String.valueOf(suffix) + this.getValue(format[i], provider);
                    }
                }
                ++i;
            }
            decoration.addPrefix(prefix);
            decoration.addSuffix(suffix);
        }

        public Image getImage(Object element) {
            ImageDescriptor overlay;
            ImageDescriptor descriptor = null;
            switch (((PreviewFile)element).type) {
                case 4: {
                    descriptor = SVNTeamUIPlugin.instance().getImageDescriptor("icons/objects/project.gif");
                    break;
                }
                case 2: {
                    descriptor = SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/folder.gif");
                    break;
                }
                default: {
                    descriptor = SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/file.gif");
                }
            }
            Image image = this.images.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.images.put(descriptor, image);
            }
            if ((overlay = SVNTeamDecorationPreferencesPage.this.getOverlay((PreviewFile)element)) == null) {
                return image;
            }
            try {
                OverlayedImageDescriptor imgDescr = new OverlayedImageDescriptor(image, overlay, new Point(image.getBounds().width, image.getBounds().height), OverlayedImageDescriptor.BOTTOM | OverlayedImageDescriptor.RIGHT);
                Image overlayedImg = this.images.get((Object)imgDescr);
                if (overlayedImg == null) {
                    overlayedImg = imgDescr.createImage();
                    this.images.put((ImageDescriptor)imgDescr, overlayedImg);
                }
                return overlayedImg;
            }
            catch (Exception e) {
                LoggedOperation.reportError((String)SVNUIMessages.Error_DecoratorImage, (Throwable)e);
                return null;
            }
        }
    }

    private static class PreviewFile {
        public final String name;
        public final int type;
        public final boolean added;
        public final boolean dirty;
        public final boolean conflicted;
        public final boolean hasRemote;
        public final boolean ignored;
        public final boolean newResource;
        public final boolean locked;
        public final boolean needsLock;
        public final boolean isTrunk;
        public final boolean isBranch;
        public final boolean isTag;
        public final boolean isSwitched;
        public Collection<PreviewFile> children;

        public PreviewFile(String name, int type, boolean added, boolean newResource, boolean dirty, boolean conflicted, boolean ignored, boolean hasRemote, boolean locked, boolean needsLock, boolean isTrunk, boolean isBranch, boolean isTag, boolean isSwitched) {
            this.name = name;
            this.type = type;
            this.added = added;
            this.ignored = ignored;
            this.dirty = dirty;
            this.conflicted = conflicted;
            this.hasRemote = hasRemote;
            this.newResource = newResource;
            this.locked = locked;
            this.needsLock = needsLock;
            this.children = Collections.emptyList();
            this.isTrunk = isTrunk;
            this.isBranch = isBranch;
            this.isTag = isTag;
            this.isSwitched = isSwitched;
        }
    }
}

