/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RemoteStatusOperation
extends AbstractWorkingCopyOperation
implements IRemoteStatusOperation,
ISVNNotificationCallback {
    protected SVNChangeStatus[] statuses;
    protected Map<String, SVNRevision.Number> pegRevisions = new HashMap<String, SVNRevision.Number>();

    public RemoteStatusOperation(IResource[] resources) {
        super("Operation_UpdateStatus", SVNMessages.class, resources);
    }

    public RemoteStatusOperation(IResourceProvider provider) {
        super("Operation_UpdateStatus", SVNMessages.class, provider);
    }

    public IResource[] getScope() {
        return this.operableData();
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = FileUtility.shrinkChildNodes(this.operableData());
        final HashSet<Path> projectPaths = new HashSet<Path>();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            projectPaths.add(new Path(FileUtility.getWorkingCopyPath((IResource)resources[i].getProject())));
            ++i;
        }
        final HashMap result = new HashMap();
        final ISVNEntryStatusCallback cb = new ISVNEntryStatusCallback(){

            public void next(SVNChangeStatus status) {
                IPath projectPath;
                result.put(new Path(status.path), status);
                String parent = new File(status.path).getParent();
                if (parent != null && (projectPath = this.getProjectPath(parent)) != null) {
                    if (status.reposKind != 2) {
                        this.postStatus(parent, status);
                    }
                    this.postStatus(projectPath.toString(), status);
                }
            }

            private void postStatus(String path, SVNChangeStatus baseStatus) {
                Path tPath = new Path(path);
                SVNChangeStatus st = (SVNChangeStatus)result.get(tPath);
                if (st == null || st.reposLastCmtRevision < baseStatus.reposLastCmtRevision) {
                    SVNChangeStatus status = this.makeStatus(path, baseStatus);
                    result.put(tPath, status);
                }
            }

            private SVNChangeStatus makeStatus(String path, SVNChangeStatus status) {
                int deltaSegments = new Path(status.path).segmentCount() - new Path(path).segmentCount();
                return new SVNChangeStatus(path, status.url != null ? SVNUtility.createPathForSVNUrl(status.url).removeLastSegments(deltaSegments).toString() : null, 2, -1L, -1L, 0L, null, 1, 0, 1, 2, false, false, null, null, null, null, -1L, false, null, null, null, 0L, null, status.reposLastCmtRevision, status.reposLastCmtDate, 2, status.reposLastCmtAuthor, false, false, null);
            }

            private IPath getProjectPath(String path) {
                Path tPath = new Path(path);
                for (IPath projectPath : projectPaths) {
                    if (!projectPath.isPrefixOf((IPath)tPath)) continue;
                    return projectPath;
                }
                return null;
            }
        };
        int i2 = 0;
        while (i2 < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resources[i2]);
            final ISVNConnector proxy = location.acquireSVNProxy();
            SVNUtility.addSVNNotifyListener(proxy, this);
            final IResource current = resources[i2];
            ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.status(FileUtility.getWorkingCopyPath(current), -2, 64L, null, cb, new SVNProgressMonitor(RemoteStatusOperation.this, monitor, null, false));
                }
            }, monitor, resources.length);
            SVNUtility.removeSVNNotifyListener(proxy, this);
            location.releaseSVNProxy(proxy);
            ++i2;
        }
        this.statuses = result.values().toArray(new SVNChangeStatus[result.size()]);
    }

    public SVNEntryStatus[] getStatuses() {
        return this.statuses;
    }

    public void setPegRevision(IResourceChange change) {
        IPath resourcePath = FileUtility.getResourcePath(change.getResource());
        int prefixLength = 0;
        SVNRevision revision = SVNRevision.INVALID_REVISION;
        for (Map.Entry<String, SVNRevision.Number> entry : this.pegRevisions.entrySet()) {
            Path rootPath = new Path(entry.getKey());
            int segments = rootPath.segmentCount();
            if (!rootPath.isPrefixOf(resourcePath) || segments <= prefixLength) continue;
            prefixLength = segments;
            revision = entry.getValue();
        }
        if (revision != SVNRevision.INVALID_REVISION) {
            change.setPegRevision(revision);
        } else if (change.getResource().getType() == 4) {
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(change.getResource());
            change.setPegRevision(remote.getPegRevision());
        }
    }

    public void notify(SVNNotification info) {
        if (info.revision != -1L) {
            this.pegRevisions.put(info.path, SVNRevision.fromNumber(info.revision));
        }
    }
}

