/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class LocateResourceURLInHistoryOperation
extends AbstractRepositoryOperation
implements IRepositoryResourceProvider {
    protected IRepositoryResource[] converted;

    public LocateResourceURLInHistoryOperation(IRepositoryResource[] resources) {
        super("Operation_LocateURLInHistory", SVNMessages.class, resources);
    }

    public LocateResourceURLInHistoryOperation(IRepositoryResourceProvider provider) {
        super("Operation_LocateURLInHistory", SVNMessages.class, provider);
    }

    public IRepositoryResource[] getRepositoryResources() {
        return this.converted;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        this.converted = new IRepositoryResource[resources.length];
        System.arraycopy(resources, 0, this.converted, 0, resources.length);
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final int idx = i;
            ProgressMonitorUtility.setTaskInfo(monitor, this, resources[i].getUrl());
            if (this.converted[i].getSelectedRevision().getKind() == 1) {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        IRepositoryResource result = LocateResourceURLInHistoryOperation.this.processEntry(LocateResourceURLInHistoryOperation.this.converted[idx], monitor);
                        LocateResourceURLInHistoryOperation.this.converted[idx] = LocateResourceURLInHistoryOperation.this.converted[idx] == result ? SVNUtility.copyOf(result) : result;
                        LocateResourceURLInHistoryOperation.this.converted[idx].setPegRevision(LocateResourceURLInHistoryOperation.this.converted[idx].getSelectedRevision());
                    }
                }, monitor, resources.length);
            }
            ++i;
        }
    }

    protected IRepositoryResource processEntry(IRepositoryResource current, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = current.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        SVNLogEntry[] msgs = null;
        int index = 0;
        try {
            IRepositoryResource pegNode = SVNUtility.copyOf(current);
            pegNode.setSelectedRevision(pegNode.getPegRevision());
            if (pegNode.exists()) {
                msgs = SVNUtility.logEntries(proxy, SVNUtility.getEntryReference(pegNode), SVNRevision.fromNumber(0L), pegNode.getPegRevision(), 393216L, ISVNConnector.EMPTY_LOG_ENTRY_PROPS, 1L, new SVNProgressMonitor(this, monitor, null));
            } else if (pegNode.getParent() != null && (msgs = SVNUtility.logEntries(proxy, SVNUtility.getEntryReference(pegNode.getParent()), SVNRevision.fromNumber(0L), pegNode.getPegRevision(), 393216L, ISVNConnector.EMPTY_LOG_ENTRY_PROPS, 1L, new SVNProgressMonitor(this, monitor, null))) != null) {
                int j = 0;
                while (j < msgs.length) {
                    SVNLogPath[] paths = msgs[j].changedPaths;
                    if (paths != null) {
                        int k = 0;
                        while (k < paths.length) {
                            if (paths[k] != null && current.getUrl().endsWith(paths[k].path)) {
                                index = j;
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        if (msgs != null && msgs.length > index && msgs[index] != null) {
            SVNLogPath[] paths = msgs[index].changedPaths;
            if (paths == null) {
                return current;
            }
            Path pattern = new Path(current.getUrl().substring(location.getRepositoryRootUrl().length()));
            int idx = -1;
            int prefLen = 0;
            int i = 0;
            while (i < paths.length) {
                Path path = new Path(paths[i].path);
                int tLen = path.segmentCount();
                if (path.isPrefixOf((IPath)pattern) && paths[i].copiedFromPath != null && tLen > prefLen) {
                    idx = i;
                }
                ++i;
            }
            if (idx == -1) {
                return current;
            }
            String copiedFrom = String.valueOf(location.getRepositoryRootUrl()) + paths[idx].copiedFromPath + pattern.toString().substring(paths[idx].path.length());
            long rev = paths[idx].copiedFromRevision;
            SVNRevision searchRevision = current.getSelectedRevision();
            if (searchRevision.getKind() != 1) {
                throw new RuntimeException("Unexpected revision kind. Kind: " + searchRevision.getKind());
            }
            long searchRev = ((SVNRevision.Number)searchRevision).getNumber();
            if (rev < searchRev) {
                if (msgs[index].revision <= searchRev) {
                    return current;
                }
                searchRevision = SVNRevision.fromNumber(rev);
            }
            IRepositoryResource retVal = current instanceof IRepositoryFile ? location.asRepositoryFile(copiedFrom, false) : location.asRepositoryContainer(copiedFrom, false);
            retVal.setPegRevision(SVNRevision.fromNumber(rev));
            retVal.setSelectedRevision(searchRevision);
            return rev <= searchRev ? retVal : this.processEntry(retVal, monitor);
        }
        return current;
    }
}

