/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.preferences.SVNRevisionGraphPreferences;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class ShowRevisionGraphPanel
extends AbstractDialogPanel {
    protected boolean isShowAllRevisions;
    protected boolean canIncludeMergeInfo;
    protected IRepositoryResource resource;
    protected IRepositoryResource initFromResource;
    protected IRepositoryResource initToResource;
    protected boolean reversed;
    protected RevisionComposite fromComposite;
    protected RevisionComposite toComposite;

    public ShowRevisionGraphPanel(IRepositoryResource resource) {
        this.dialogTitle = SVNRevisionGraphMessages.ShowRevisionGraphPanel_Title;
        this.dialogDescription = SVNRevisionGraphMessages.ShowRevisionGraphPanel_Description;
        this.defaultMessage = SVNRevisionGraphMessages.ShowRevisionGraphPanel_Message;
        this.resource = resource;
        if (this.resource != null) {
            this.initFromResource = SVNUtility.copyOf((IRepositoryResource)this.resource);
            this.initToResource = SVNUtility.copyOf((IRepositoryResource)this.resource);
        }
    }

    protected void createControlsImpl(Composite parent) {
        if (this.resource != null) {
            Composite cmp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cmp.setLayout((Layout)layout);
            GridData data = new GridData(768);
            cmp.setLayoutData((Object)data);
            String defaultRevision = SVNRevisionGraphMessages.ShowRevisionGraphPanel_RevisionDefault;
            this.fromComposite = new RevisionComposite(cmp, (IValidationManager)this, true, new String[]{SVNRevisionGraphMessages.ShowRevisionGraphPanel_FromRevision, defaultRevision}, null, false);
            this.fromComposite.setBaseResource(this.resource);
            this.fromComposite.setSelectedResource(this.initFromResource);
            this.fromComposite.setRevisionValue(SVNRevision.HEAD);
            data = new GridData(768);
            this.fromComposite.setLayoutData((Object)data);
            this.toComposite = new RevisionComposite(cmp, (IValidationManager)this, true, new String[]{SVNRevisionGraphMessages.ShowRevisionGraphPanel_ToRevision, defaultRevision}, null, false);
            this.toComposite.setBaseResource(this.resource);
            this.toComposite.setSelectedResource(this.initToResource);
            this.toComposite.setRevisionValue(SVNRevision.HEAD);
            data = new GridData(768);
            this.toComposite.setLayoutData((Object)data);
        }
        final Button showAllRevisionsButton = new Button(parent, 32);
        GridData data = new GridData(768);
        showAllRevisionsButton.setLayoutData((Object)data);
        showAllRevisionsButton.setText(SVNRevisionGraphMessages.ShowRevisionGraphPanel_ShowAllRevisions);
        showAllRevisionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowRevisionGraphPanel.this.isShowAllRevisions = showAllRevisionsButton.getSelection();
            }
        });
        final Button includeMergeInfoButton = new Button(parent, 32);
        data = new GridData(768);
        includeMergeInfoButton.setLayoutData((Object)data);
        includeMergeInfoButton.setText(SVNRevisionGraphMessages.ShowRevisionGraphPanel_ShowMergeInfo);
        includeMergeInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowRevisionGraphPanel.this.canIncludeMergeInfo = includeMergeInfoButton.getSelection();
            }
        });
        this.isShowAllRevisions = SVNRevisionGraphPreferences.getGraphBoolean(SVNRevisionGraphPlugin.instance().getPreferenceStore(), "show.all.revisions");
        boolean isMergeSupported = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() > 4;
        this.canIncludeMergeInfo = isMergeSupported ? SVNRevisionGraphPreferences.getGraphBoolean(SVNRevisionGraphPlugin.instance().getPreferenceStore(), "show.merge.info") : false;
        showAllRevisionsButton.setSelection(this.isShowAllRevisions);
        includeMergeInfoButton.setSelection(this.canIncludeMergeInfo);
        if (!isMergeSupported) {
            includeMergeInfoButton.setEnabled(false);
        }
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.showRevisionGraphDialogContext";
    }

    public Point getPrefferedSizeImpl() {
        return new Point(715, -1);
    }

    protected void saveChangesImpl() {
        SVNRevisionGraphPreferences.setGraphBoolean(SVNRevisionGraphPlugin.instance().getPreferenceStore(), "show.merge.info", this.canIncludeMergeInfo);
        SVNRevisionGraphPreferences.setGraphBoolean(SVNRevisionGraphPlugin.instance().getPreferenceStore(), "show.all.revisions", this.isShowAllRevisions);
        if (this.getFromRevision() == null || this.getToRevision() == null) {
            return;
        }
        this.initFromResource.setSelectedRevision(this.getFromRevision());
        this.initToResource.setSelectedRevision(this.getToRevision());
        UIMonitorUtility.doTaskNowDefault((IActionOperation)new AbstractActionOperation("Operation_CheckRevisions", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ISVNConnector proxy = ShowRevisionGraphPanel.this.initFromResource.getRepositoryLocation().acquireSVNProxy();
                try {
                    ShowRevisionGraphPanel.this.reversed = SVNUtility.compareRevisions((SVNRevision)ShowRevisionGraphPanel.this.initFromResource.getSelectedRevision(), (SVNRevision)ShowRevisionGraphPanel.this.initToResource.getSelectedRevision(), (SVNEntryRevisionReference)SVNUtility.getEntryRevisionReference((IRepositoryResource)ShowRevisionGraphPanel.this.initFromResource), (SVNEntryRevisionReference)SVNUtility.getEntryRevisionReference((IRepositoryResource)ShowRevisionGraphPanel.this.initToResource), (ISVNConnector)proxy) == 1;
                }
                finally {
                    ShowRevisionGraphPanel.this.initFromResource.getRepositoryLocation().releaseSVNProxy(proxy);
                }
            }
        }, (boolean)false);
    }

    protected void cancelChangesImpl() {
    }

    public boolean canIncludeMergeInfo() {
        return this.canIncludeMergeInfo;
    }

    public boolean isShowAllRevisions() {
        return this.isShowAllRevisions;
    }

    public SVNRevision getFromRevision() {
        if (this.resource != null) {
            return (this.reversed ? this.toComposite : this.fromComposite).getSelectedRevision();
        }
        return null;
    }

    public SVNRevision getToRevision() {
        if (this.resource != null) {
            return (this.reversed ? this.fromComposite : this.toComposite).getSelectedRevision();
        }
        return null;
    }
}

