/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class BytesUtility {
    public static byte[] convertStringToBytes(String val) {
        try {
            return val.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    public static String getString(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static void writeBytesWithLength(DataOutput out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        if (bytes.length > 0) {
            out.write(bytes);
        }
    }

    public static byte[] readBytesWithLength(DataInput in) throws IOException {
        int length = in.readInt();
        byte[] b = new byte[length];
        if (length > 0) {
            in.readFully(b);
        }
        return b;
    }

    public static void compressAndWrite(byte[] bytes, DataOutput out, Deflater encoder) throws IOException {
        byte[] compressedBytes = BytesUtility.compressBytes(encoder, bytes);
        BytesUtility.writeBytesWithLength(out, compressedBytes);
        out.writeInt(bytes.length);
    }

    public static byte[] decompressAndRead(DataInput in, Inflater decoder) throws IOException {
        byte[] compressedBytes = BytesUtility.readBytesWithLength(in);
        int rawLength = in.readInt();
        try {
            return BytesUtility.decompressBytes(decoder, compressedBytes, rawLength);
        }
        catch (DataFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static byte[] compressBytes(Deflater encoder, byte[] bytes) {
        encoder.setInput(bytes);
        encoder.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        byte[] buffer = new byte[bytes.length];
        while (!encoder.finished()) {
            int bytesCompressed = encoder.deflate(buffer);
            bos.write(buffer, 0, bytesCompressed);
        }
        encoder.reset();
        return bos.toByteArray();
    }

    public static byte[] decompressBytes(Inflater decoder, byte[] compressedBytes, int uncompressedLength) throws DataFormatException {
        byte[] result = new byte[uncompressedLength];
        decoder.setInput(compressedBytes);
        decoder.inflate(result);
        decoder.reset();
        return result;
    }
}

