/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.team.svn.revision.graph.cache.GenericStorage;
import org.eclipse.team.svn.revision.graph.cache.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPairsStorage
extends GenericStorage<Pair> {
    public IndexPairsStorage() {
        this.addSimple(new Pair(0, 0));
    }

    public IndexPairsStorage(byte[] bytes) {
        this.fromBytes(bytes);
    }

    protected final void fromBytes(byte[] bytes) {
        try {
            DataInputStream bytesIn = new DataInputStream(new ByteArrayInputStream(bytes));
            int count = bytesIn.readInt();
            int i = 0;
            while (i < count) {
                int parentIndex = bytesIn.readInt();
                int stringIndex = bytesIn.readInt();
                Pair pair = new Pair(parentIndex, stringIndex);
                this.dataList.add(pair);
                this.hash.put(pair, this.dataList.size() - 1);
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream bytes = new DataOutputStream(byteArray);
            bytes.writeInt(this.dataList.size());
            for (Pair pair : this.dataList) {
                bytes.writeInt(pair.first);
                bytes.writeInt(pair.second);
            }
            return byteArray.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

