/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.team.svn.revision.graph.cache.BytesUtility;
import org.eclipse.team.svn.revision.graph.cache.IndexPairsStorage;
import org.eclipse.team.svn.revision.graph.cache.Pair;
import org.eclipse.team.svn.revision.graph.cache.StringStorage;
import org.eclipse.team.svn.revision.graph.cache.TimeMeasure;

public class MessageStorage {
    protected static final int MIN_PAIRS_COUNT = 5;
    protected static final int EMPTY_TOKEN = 0;
    protected static final char[] separators = new char[]{' ', '\t', '\n', '\\', '/', '(', ')', '<', '>', '{', '}', '\"', '\'', '.', ':', '=', '-', '+', '*', '^'};
    protected StringStorage strings = new StringStorage();
    protected IndexPairsStorage pairs = new IndexPairsStorage();
    protected int[][] messages;

    public MessageStorage(int messagesCount) {
        if (messagesCount < 0) {
            throw new IllegalArgumentException("Messages count: " + messagesCount);
        }
        this.init(messagesCount);
    }

    protected final void init(int count) {
        this.messages = new int[count][];
        int i = 0;
        while (i < count) {
            this.messages[i] = new int[0];
            ++i;
        }
    }

    public MessageStorage(byte[] bytes) {
        this.fromBytes(bytes);
    }

    public void expandMessagesCount(long messagesCount) {
        if (messagesCount < (long)this.messages.length) {
            throw new IllegalArgumentException("Expand count: " + messagesCount + ", current length: " + this.messages.length);
        }
        if (this.messages.length != 0) {
            int[][] tmp = this.messages;
            this.messages = new int[(int)messagesCount][];
            System.arraycopy(tmp, 0, this.messages, 0, tmp.length);
            int i = tmp.length;
            while (i < this.messages.length) {
                this.messages[i] = new int[0];
                ++i;
            }
        } else {
            this.init((int)messagesCount);
        }
    }

    public int add(String message, long revision) {
        if (revision >= (long)this.messages.length) {
            throw new IndexOutOfBoundsException("Revision: " + revision + ", size: " + this.messages.length);
        }
        String[] words = message != null && message.length() > 0 ? MessageStorage.splitOnWords(message) : new String[]{};
        int messageIndex = (int)revision;
        this.messages[messageIndex] = new int[words.length];
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            int index = this.strings.add(word);
            this.messages[messageIndex][i] = this.getStringToken(index);
            ++i;
        }
        return messageIndex;
    }

    public String getMessage(int messageIndex) {
        if (messageIndex < 0 || messageIndex >= this.messages.length) {
            throw new IllegalArgumentException("Index: " + messageIndex + ", size: " + this.messages.length);
        }
        StringBuffer result = new StringBuffer();
        int[] tokens = this.messages[messageIndex];
        int i = 0;
        while (i < tokens.length) {
            result.append(this.getIndexMessage(tokens[i]));
            ++i;
        }
        return result.length() != 0 ? result.toString() : null;
    }

    protected String getIndexMessage(int tokenIndex) {
        StringBuffer result = new StringBuffer();
        if (this.isPairToken(tokenIndex)) {
            int index = this.getPairIndex(tokenIndex);
            Pair pair = (Pair)this.pairs.getValue(index);
            result.append(this.getIndexMessage(pair.first));
            result.append(this.getIndexMessage(pair.second));
        } else {
            int index = this.getStringIndex(tokenIndex);
            result.append((String)this.strings.getValue(index));
        }
        return result.toString();
    }

    protected static String[] splitOnWords(String message) {
        ArrayList<String> words = new ArrayList<String>();
        char[] chars = message.toCharArray();
        int nextPos = -1;
        boolean isSeparator = MessageStorage.isSeparator(chars[0]);
        int pos = 0;
        int length = chars.length;
        while (pos < length) {
            nextPos = pos + 1;
            while (nextPos < length) {
                if (MessageStorage.isSeparator(chars[nextPos]) != isSeparator) break;
                ++nextPos;
            }
            boolean bl = isSeparator = !isSeparator;
            if (nextPos + 1 < length && MessageStorage.isSeparator(chars[nextPos + 1]) != isSeparator) {
                ++nextPos;
                isSeparator = !isSeparator;
            }
            String word = message.substring(pos, nextPos);
            words.add(word);
            pos = nextPos;
        }
        return words.toArray(new String[0]);
    }

    protected static boolean isSeparator(char ch) {
        char[] cArray = separators;
        int n = separators.length;
        int n2 = 0;
        while (n2 < n) {
            char separator = cArray[n2];
            if (separator == ch) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void compress() {
        PairsCompressor compressor = new PairsCompressor();
        compressor.run();
    }

    protected boolean isPairToken(int token) {
        return token < 0;
    }

    protected int getPairIndex(int token) {
        return -token;
    }

    protected int getPairToken(int index) {
        return -index;
    }

    protected int getStringIndex(int token) {
        return token;
    }

    protected int getStringToken(int index) {
        return index;
    }

    protected final void fromBytes(byte[] bytes) {
        try {
            DataInputStream bytesIn = new DataInputStream(new ByteArrayInputStream(bytes));
            byte[] stringBytes = BytesUtility.readBytesWithLength(bytesIn);
            this.strings = new StringStorage(stringBytes);
            byte[] pairBytes = BytesUtility.readBytesWithLength(bytesIn);
            this.pairs = new IndexPairsStorage(pairBytes);
            int messagesLength = bytesIn.readInt();
            this.init(messagesLength);
            int i = 0;
            while (i < messagesLength) {
                int tokensCount = bytesIn.readInt();
                this.messages[i] = new int[tokensCount];
                int j = 0;
                while (j < tokensCount) {
                    this.messages[i][j] = bytesIn.readInt();
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream bytesOut = new DataOutputStream(byteArray);
            byte[] stringBytes = this.strings.toBytes();
            BytesUtility.writeBytesWithLength(bytesOut, stringBytes);
            byte[] pairsBytes = this.pairs.toBytes();
            BytesUtility.writeBytesWithLength(bytesOut, pairsBytes);
            bytesOut.writeInt(this.messages.length);
            int i = 0;
            while (i < this.messages.length) {
                int[] messageTokens = this.messages[i];
                bytesOut.writeInt(messageTokens.length);
                int j = 0;
                while (j < messageTokens.length) {
                    bytesOut.writeInt(messageTokens[j]);
                    ++j;
                }
                ++i;
            }
            return byteArray.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public static void main(String[] args) {
        MessageStorage storage = new MessageStorage(2);
        int i1 = storage.add("hello world a hello world b hello world f", 0L);
        int i2 = storage.add("my hello world d hello world g", 1L);
        storage.compress();
        System.out.println(storage.getMessage(i1));
        System.out.println(storage.getMessage(i2));
    }

    protected static class MutableInteger {
        int value;

        public MutableInteger(int value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PairsCompressor {
        protected boolean[] messagesForProcessingStatus;

        public PairsCompressor() {
            this.messagesForProcessingStatus = new boolean[MessageStorage.this.messages.length];
            Arrays.fill(this.messagesForProcessingStatus, true);
        }

        public int run() {
            int totalCompressed = 0;
            while (true) {
                int compressedPairs = this.compress();
                if (TimeMeasure.isDebug) {
                    System.out.println("compressed pairs: " + compressedPairs);
                }
                if (compressedPairs == 0) break;
                totalCompressed += compressedPairs;
            }
            return totalCompressed;
        }

        protected int compress() {
            Map<Pair, MutableInteger> occurrence = this.calculatePairsOccurrence();
            int compressedPairs = 0;
            if (this.createNewPairs(occurrence)) {
                compressedPairs = this.replaceTokensOnPairs();
            }
            return compressedPairs;
        }

        protected int replaceTokensOnPairs() {
            int compressedPairs = 0;
            int i = 0;
            while (i < this.messagesForProcessingStatus.length) {
                if (this.messagesForProcessingStatus[i]) {
                    int[] messageTokens = MessageStorage.this.messages[i];
                    int messageCompressedPairs = 0;
                    if (messageTokens.length >= 2) {
                        int previousToken = messageTokens[0];
                        int j = 1;
                        while (j < messageTokens.length) {
                            int token = messageTokens[j];
                            Pair pair = new Pair(previousToken, token);
                            int pairIndex = MessageStorage.this.pairs.find(pair);
                            if (pairIndex != -1) {
                                ++messageCompressedPairs;
                                messageTokens[j - 1] = MessageStorage.this.getPairToken(pairIndex);
                                messageTokens[j] = 0;
                                if (j + 2 >= messageTokens.length) break;
                                previousToken = messageTokens[++j];
                            } else {
                                previousToken = token;
                            }
                            ++j;
                        }
                    }
                    if (messageCompressedPairs != 0) {
                        compressedPairs += messageCompressedPairs;
                        int[] newMessageTokens = new int[messageTokens.length - messageCompressedPairs];
                        int k = 0;
                        int num = 0;
                        while (k < messageTokens.length) {
                            if (messageTokens[k] != 0) {
                                newMessageTokens[num++] = messageTokens[k];
                            }
                            ++k;
                        }
                        MessageStorage.this.messages[i] = newMessageTokens;
                    } else {
                        this.messagesForProcessingStatus[i] = false;
                    }
                }
                ++i;
            }
            return compressedPairs;
        }

        protected Map<Pair, MutableInteger> calculatePairsOccurrence() {
            HashMap<Pair, MutableInteger> occurrence = new HashMap<Pair, MutableInteger>();
            int i = 0;
            while (i < this.messagesForProcessingStatus.length) {
                int[] messageTokens;
                if (this.messagesForProcessingStatus[i] && (messageTokens = MessageStorage.this.messages[i]).length >= 2) {
                    int previousToken = messageTokens[0];
                    int j = 1;
                    while (j < messageTokens.length) {
                        int token = messageTokens[j];
                        Pair pair = new Pair(previousToken, token);
                        MutableInteger count = (MutableInteger)occurrence.get(pair);
                        if (count != null) {
                            ++count.value;
                        } else {
                            occurrence.put(pair, new MutableInteger(1));
                        }
                        previousToken = token;
                        ++j;
                    }
                }
                ++i;
            }
            return occurrence;
        }

        protected boolean createNewPairs(Map<Pair, MutableInteger> occurrence) {
            boolean hasNewPairs = false;
            for (Map.Entry<Pair, MutableInteger> entry : occurrence.entrySet()) {
                if (entry.getValue().value < 5) continue;
                hasNewPairs = true;
                MessageStorage.this.pairs.add(entry.getKey());
            }
            return hasNewPairs;
        }
    }
}

