/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionFigure;

public class MergeConnectionRouter
extends AbstractRouter {
    protected static final int HORIZONTAL_OFFSET = 20;
    protected static final int HORIZONTAL_STEP = 5;

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        PointList bendPoints = this.calculateInitialPoints(conn);
        this.checkIntersectsWithNodes(conn, bendPoints);
        this.applyResult(conn, bendPoints);
    }

    protected PointList calculateInitialPoints(Connection conn) {
        Point start = this.getStartPoint(conn);
        Point end = this.getEndPoint(conn);
        Point point2 = new Point();
        int offset = 20;
        if (end.x > start.x) {
            offset = -offset;
        }
        point2.x = end.x + offset;
        point2.y = start.y;
        Point point3 = new Point();
        point3.x = point2.x;
        point3.y = end.y;
        PointList bendPoints = new PointList();
        bendPoints.addPoint(start);
        bendPoints.addPoint(point2);
        bendPoints.addPoint(point3);
        bendPoints.addPoint(end);
        return bendPoints;
    }

    protected void checkIntersectsWithNodes(Connection conn, PointList bendPoints) {
        IFigure nodesParent = conn.getSourceAnchor().getOwner().getParent();
        if (nodesParent == null) {
            return;
        }
        boolean isChanged = false;
        Point startPoint = bendPoints.getFirstPoint();
        Point endPoint = bendPoints.getLastPoint();
        if (startPoint.x != endPoint.x) {
            Point p;
            int i;
            int pointIndex = 0;
            if (startPoint.x < endPoint.x) {
                i = startPoint.x + 1;
                while (i < endPoint.x) {
                    p = new Point(i, startPoint.y);
                    nodesParent.translateToRelative((Translatable)p);
                    IFigure figure = nodesParent.findFigureAt(p);
                    if (figure instanceof RevisionFigure) {
                        Rectangle figureBounds = figure.getBounds().getCopy();
                        nodesParent.translateToAbsolute((Translatable)figureBounds);
                        Point point1 = new Point();
                        point1.x = figureBounds.x - 20;
                        point1.y = startPoint.y;
                        Point point2 = new Point();
                        point2.x = point1.x;
                        boolean isGoTop = startPoint.y < figureBounds.bottom() / 2;
                        point2.y = isGoTop ? figureBounds.y - 1 : figureBounds.bottom() + 1;
                        bendPoints.insertPoint(point1, ++pointIndex);
                        bendPoints.insertPoint(point2, ++pointIndex);
                        startPoint = point2;
                        i = figureBounds.right() + 1;
                        isChanged = true;
                        continue;
                    }
                    i += 5;
                }
            } else {
                i = startPoint.x - 1;
                while (i > endPoint.x) {
                    p = new Point(i, startPoint.y);
                    nodesParent.translateToRelative((Translatable)p);
                    IFigure figure = nodesParent.findFigureAt(p);
                    if (figure instanceof RevisionFigure) {
                        Rectangle figureBounds = figure.getBounds().getCopy();
                        nodesParent.translateToAbsolute((Translatable)figureBounds);
                        Point point1 = new Point();
                        point1.x = figureBounds.right() + 20;
                        point1.y = startPoint.y;
                        Point point2 = new Point();
                        point2.x = point1.x;
                        boolean isGoTop = startPoint.y < figureBounds.bottom() / 2;
                        point2.y = isGoTop ? figureBounds.y - 1 : figureBounds.bottom() + 1;
                        bendPoints.insertPoint(point1, ++pointIndex);
                        bendPoints.insertPoint(point2, ++pointIndex);
                        startPoint = point2;
                        i = figureBounds.x - 1;
                        isChanged = true;
                        continue;
                    }
                    i -= 5;
                }
            }
            if (isChanged) {
                int index = bendPoints.size() - 3;
                Point point = bendPoints.getPoint(index);
                bendPoints.removePoint(index);
                point.y = bendPoints.getPoint((int)(index - 1)).y;
                bendPoints.insertPoint(point, index);
            }
        }
    }

    protected void applyResult(Connection conn, PointList initialPoints) {
        PointList points = conn.getPoints();
        points.removeAllPoints();
        int i = 0;
        while (i < initialPoints.size()) {
            Point point = initialPoints.getPoint(i);
            conn.translateToRelative((Translatable)point);
            points.addPoint(point);
            ++i;
        }
        conn.setPoints(points);
    }
}

