/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;

public class RevisionSourceAnchor
extends AbstractConnectionAnchor {
    protected RevisionNode source;
    protected RevisionNode target;
    protected boolean isMergeConnection;

    public RevisionSourceAnchor(IFigure figure, RevisionNode source, RevisionNode target, boolean isMergeConnection) {
        super(figure);
        this.source = source;
        this.target = target;
        this.isMergeConnection = isMergeConnection;
    }

    public Point getLocation(Point reference) {
        Point point;
        Rectangle rect = this.getOwner().getBounds();
        if (!this.isMergeConnection) {
            boolean isTop = this.target.getAction() == PathRevision.RevisionNodeAction.RENAME || this.target.getPrevious() != null;
            point = isTop ? rect.getTop() : rect.getRight();
        } else {
            point = this.source.x <= this.target.x ? rect.getRight() : rect.getLeft();
            point.y += 3;
        }
        this.getOwner().translateToAbsolute((Translatable)point);
        return point;
    }
}

