/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.TwoWayPropertyCompareInput;
import org.eclipse.ui.IWorkbenchPart;

public class ComparePropertiesAction
extends BaseRevisionGraphAction {
    public static final String ComparePropertiesAction_ID = "CompareProperties";

    public ComparePropertiesAction(IWorkbenchPart part) {
        super(part);
        this.setText(SVNUIMessages.SynchronizeActionGroup_CompareProperties);
        this.setId(ComparePropertiesAction_ID);
        this.setToolTipText(SVNUIMessages.SynchronizeActionGroup_CompareProperties);
    }

    protected boolean calculateEnabled() {
        return this.isEnable(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER, 2);
    }

    public void run() {
        RevisionEditPart[] editParts = this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER);
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(editParts);
        IRepositoryResource first = resources[0];
        IRepositoryResource second = resources[1];
        if (((SVNRevision.Number)first.getSelectedRevision()).getNumber() < ((SVNRevision.Number)second.getSelectedRevision()).getNumber()) {
            IRepositoryResource tmp = second;
            second = first;
            first = tmp;
        }
        TwoWayPropertyCompareInput input = new TwoWayPropertyCompareInput(new CompareConfiguration(), SVNUtility.getEntryRevisionReference((IRepositoryResource)first), SVNUtility.getEntryRevisionReference((IRepositoryResource)second), this.getRepositoryLocation(editParts[0]));
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }
}

