/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.eclipse.ui.IWorkbenchPart;

public class CompareWithEachOtherAction
extends BaseRevisionGraphAction {
    public static final String CompareWithEachOtherAction_ID = "CompareWithEachOther";

    public CompareWithEachOtherAction(IWorkbenchPart part) {
        super(part);
        this.setText(SVNUIMessages.HistoryView_CompareEachOther);
        this.setId(CompareWithEachOtherAction_ID);
        this.setToolTipText(SVNUIMessages.HistoryView_CompareEachOther);
    }

    protected boolean calculateEnabled() {
        RevisionEditPart[] editParts = null;
        if (this.getSelectedEditParts().length == 2 && (editParts = this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER)).length == 2) {
            boolean isCompareAllowed;
            IRepositoryResource resource = BaseRevisionGraphAction.convertToResource(editParts[0]);
            boolean bl = isCompareAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 || resource instanceof IRepositoryFile;
            if (isCompareAllowed) {
                return true;
            }
        }
        return false;
    }

    public void run() {
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(this.getSelectedEditParts());
        IRepositoryResource prev = resources[0];
        IRepositoryResource next = null;
        if (resources.length == 2) {
            next = resources[1];
        }
        if (next != null && ((SVNRevision.Number)next.getSelectedRevision()).getNumber() < ((SVNRevision.Number)prev.getSelectedRevision()).getNumber()) {
            IRepositoryResource tmp = prev;
            prev = next;
            next = tmp;
        }
        CompareRepositoryResourcesOperation op = new CompareRepositoryResourcesOperation(prev, next);
        op.setForceId(((Object)((Object)this)).toString());
        this.runOperation((IActionOperation)op);
    }
}

