/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.figure;

import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.graphic.ChangedPath;
import org.eclipse.team.svn.revision.graph.graphic.NodeMergeData;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.figure.PathFigure;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionTooltipFigure;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class RevisionFigure
extends Figure {
    public static final Color TRUNK_COLOR;
    public static final Color BRANCH_COLOR;
    public static final Color TAG_COLOR;
    public static final Color CREATE_OR_COPY_COLOR;
    public static final Color RENAME_COLOR;
    public static final Color DELETE_COLOR;
    public static final Color MODIFY_COLOR;
    public static final Color OTHER_COLOR;
    public static final Color SELECTED_COLOR;
    public static final Image TRUNK_IMAGE;
    public static final Image BRANCH_IMAGE;
    public static final Image TAG_IMAGE;
    public static final Image ADD_IMAGE;
    public static final Image DELETE_IMAGE;
    public static final Image MODIFY_IMAGE;
    public static final Image RENAME_IMAGE;
    public static final Image OTHER_IMAGE;
    public static final Image INCOMING_MERGE_IMAGE;
    public static final Image INCOMING_MERGE_IMAGE_PRESSED;
    public static final Image OUTGOING_MERGE_IMAGE;
    public static final Image OUTGOING_MERGE_IMAGE_PRESSED;
    public static final Image MERGE_IMAGE;
    protected RevisionNode revisionNode;
    protected String path;
    protected Color originalNodeColor;
    protected Color nodeColor;
    protected Color borderColor;
    protected Label revisionFigure;
    protected Label statusFigure;
    protected PathFigure pathFigure;
    protected Label commentFigure;
    protected Label outgoingMergeLabel;
    protected boolean isOutgoingMergePressed;
    protected Label incomingMergeLabel;
    protected boolean isIncomingMergePressed;
    protected boolean isSelected;

    static {
        TRUNK_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/trunk.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)TRUNK_IMAGE);
        BRANCH_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/branch.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)BRANCH_IMAGE);
        TAG_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/tag.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)TAG_IMAGE);
        ADD_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/add.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)ADD_IMAGE);
        DELETE_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/delete.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)DELETE_IMAGE);
        MODIFY_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/modify.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)MODIFY_IMAGE);
        RENAME_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/rename.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)RENAME_IMAGE);
        OTHER_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/other.png").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)OTHER_IMAGE);
        INCOMING_MERGE_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/incoming.png").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)INCOMING_MERGE_IMAGE);
        INCOMING_MERGE_IMAGE_PRESSED = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/incoming_down.png").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)INCOMING_MERGE_IMAGE_PRESSED);
        OUTGOING_MERGE_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/outgoing.png").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)OUTGOING_MERGE_IMAGE);
        OUTGOING_MERGE_IMAGE_PRESSED = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/outgoing_down.png").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)OUTGOING_MERGE_IMAGE_PRESSED);
        MERGE_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/merge.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)MERGE_IMAGE);
        TRUNK_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 188, 255, 188);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)TRUNK_COLOR);
        BRANCH_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 229, 255, 229);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)BRANCH_COLOR);
        TAG_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 239, 252, 162);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)TAG_COLOR);
        CREATE_OR_COPY_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 229, 255, 229);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)CREATE_OR_COPY_COLOR);
        RENAME_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 229, 229, 255);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)RENAME_COLOR);
        DELETE_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 255, 229, 229);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)DELETE_COLOR);
        MODIFY_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 229, 229, 229);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)MODIFY_COLOR);
        OTHER_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 240, 240, 240);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)OTHER_COLOR);
        SELECTED_COLOR = new Color((Device)UIMonitorUtility.getDisplay(), 47, 104, 200);
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)SELECTED_COLOR);
    }

    public RevisionFigure(RevisionNode revisionNode, String path) {
        this.revisionNode = revisionNode;
        this.path = path;
        this.createControls();
        this.initControls();
        this.setOpaque(true);
        this.setBorder((Border)new MarginBorder(0, 0, 2, 2));
    }

    protected void createControls() {
        String comment;
        GridLayout layout = new GridLayout();
        this.setLayoutManager((LayoutManager)layout);
        Figure revisionParent = new Figure();
        this.add((IFigure)revisionParent);
        FlowLayout revisionLayout = new FlowLayout(true);
        revisionParent.setLayoutManager((LayoutManager)revisionLayout);
        GridData data = new GridData();
        layout.setConstraint((IFigure)revisionParent, (Object)data);
        this.revisionFigure = new Label();
        revisionParent.add((IFigure)this.revisionFigure);
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        this.revisionFigure.setFont(boldFont);
        this.statusFigure = new Label();
        revisionParent.add((IFigure)this.statusFigure);
        if (this.revisionNode.hasIncomingMerges() || this.revisionNode.hasOutgoingMerges()) {
            Figure mergeParent = new Figure();
            this.add((IFigure)mergeParent);
            FlowLayout mergeParentLayout = new FlowLayout(true);
            mergeParent.setLayoutManager((LayoutManager)mergeParentLayout);
            data = new GridData();
            layout.setConstraint((IFigure)mergeParent, (Object)data);
            Label mergeTextLabel = new Label(SVNRevisionGraphMessages.RevisionFigure_Merges);
            mergeParent.add((IFigure)mergeTextLabel);
            mergeTextLabel.setIcon(MERGE_IMAGE);
            mergeTextLabel.setFont(boldFont);
            if (this.revisionNode.hasIncomingMerges()) {
                this.incomingMergeLabel = new Label();
                mergeParent.add((IFigure)this.incomingMergeLabel);
                this.incomingMergeLabel.setIcon(INCOMING_MERGE_IMAGE);
                this.incomingMergeLabel.setCursor(Cursors.HAND);
                this.incomingMergeLabel.addMouseListener((MouseListener)new MouseListener.Stub(){

                    public void mousePressed(MouseEvent me) {
                        if (RevisionFigure.this.isIncomingMergePressed) {
                            RevisionFigure.this.revisionNode.removeAllIncomingMergeConnections();
                            RevisionFigure.this.incomingMergeLabel.setIcon(INCOMING_MERGE_IMAGE);
                            RevisionFigure.this.isIncomingMergePressed = false;
                        } else {
                            RevisionFigure.this.revisionNode.addAllIncomingMergeConnections();
                            RevisionFigure.this.incomingMergeLabel.setIcon(INCOMING_MERGE_IMAGE_PRESSED);
                            RevisionFigure.this.isIncomingMergePressed = true;
                        }
                    }
                });
            }
            if (this.revisionNode.hasOutgoingMerges()) {
                this.outgoingMergeLabel = new Label();
                mergeParent.add((IFigure)this.outgoingMergeLabel);
                this.outgoingMergeLabel.setIcon(OUTGOING_MERGE_IMAGE);
                this.outgoingMergeLabel.setCursor(Cursors.HAND);
                this.outgoingMergeLabel.addMouseListener((MouseListener)new MouseListener.Stub(){

                    public void mousePressed(MouseEvent me) {
                        if (RevisionFigure.this.isOutgoingMergePressed) {
                            RevisionFigure.this.revisionNode.removeAllOutgoingMergeConnections();
                            RevisionFigure.this.outgoingMergeLabel.setIcon(OUTGOING_MERGE_IMAGE);
                            RevisionFigure.this.isOutgoingMergePressed = false;
                        } else {
                            RevisionFigure.this.revisionNode.addAllOutgoingMergeConnections();
                            RevisionFigure.this.outgoingMergeLabel.setIcon(OUTGOING_MERGE_IMAGE_PRESSED);
                            RevisionFigure.this.isOutgoingMergePressed = true;
                        }
                    }
                });
            }
        }
        if (this.revisionNode.getAction() == PathRevision.RevisionNodeAction.ADD || this.revisionNode.getAction() == PathRevision.RevisionNodeAction.COPY || this.revisionNode.getAction() == PathRevision.RevisionNodeAction.RENAME) {
            this.pathFigure = new PathFigure();
            data = new GridData();
            data.widthHint = 190;
            layout.setConstraint((IFigure)this.pathFigure, (Object)data);
            this.add((IFigure)this.pathFigure);
        }
        if ((comment = this.revisionNode.getMessage()) != null && comment.length() > 0) {
            this.commentFigure = new Label();
            this.add((IFigure)this.commentFigure);
            data = new GridData();
            data.widthHint = 190;
            data.horizontalAlignment = 1;
            layout.setConstraint((IFigure)this.commentFigure, (Object)data);
            this.commentFigure.setLabelAlignment(1);
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        Dimension corner = new Dimension(8, 8);
        Rectangle initialBounds = this.getBounds();
        Rectangle shadowBounds = initialBounds.getCopy();
        shadowBounds.resize(-2, -2).translate(2, 2);
        g.setBackgroundColor(ColorConstants.gray);
        g.fillRoundRectangle(shadowBounds, corner.width, corner.height);
        g.setLineWidthFloat(1.0f);
        Rectangle mainBounds = initialBounds.getCopy();
        mainBounds.resize(-2, -2);
        g.setBackgroundColor(this.nodeColor);
        g.setForegroundColor(this.borderColor);
        g.fillRoundRectangle(mainBounds, corner.width, corner.height);
        this.drawOutline(g, corner, mainBounds, 1);
        for (IFigure child : this.getChildren()) {
            Color color;
            if (child == this.commentFigure) {
                color = ColorConstants.gray;
                if (this.isSelected) {
                    color = FigureUtilities.lighter((Color)color);
                }
                child.setForegroundColor(color);
                continue;
            }
            if (child == this.pathFigure) {
                this.pathFigure.setSelected(this.isSelected);
                continue;
            }
            color = ColorConstants.black;
            if (this.isSelected) {
                color = RevisionFigure.inverseColor(color);
            }
            child.setForegroundColor(color);
        }
    }

    protected void drawOutline(Graphics graphics, Dimension corner, Rectangle bounds, int lineWidth) {
        float lineInset = Math.max(1.0f, (float)lineWidth) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle r = Rectangle.SINGLETON.setBounds(bounds);
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        graphics.drawRoundRectangle(r, Math.max(0, corner.width - (int)lineInset), Math.max(0, corner.height - (int)lineInset));
    }

    protected void initControls() {
        int n;
        this.revisionFigure.setText(String.valueOf(this.revisionNode.getRevision()));
        this.statusFigure.setText(RevisionFigure.getRevisionNodeStatusText(this.revisionNode));
        if (this.pathFigure != null) {
            String parentPath = null;
            RevisionNode copiedFrom = this.revisionNode.getCopiedFrom();
            if (copiedFrom != null) {
                parentPath = copiedFrom.getPath();
            }
            this.pathFigure.setShowFullPath(!this.revisionNode.isTruncatePath());
            this.pathFigure.setPaths(this.path, parentPath);
        }
        if (this.commentFigure != null) {
            String comment = this.revisionNode.getMessage();
            comment = comment.replaceAll("\r\n|\r|\n", " ");
            this.commentFigure.setText(comment);
        }
        Image nodeIcon = RevisionFigure.getRevisionNodeIcon(this.revisionNode);
        this.revisionFigure.setIcon(nodeIcon);
        this.nodeColor = this.originalNodeColor = RevisionFigure.getRevisionNodeColor(this.revisionNode);
        this.borderColor = RevisionFigure.getRevisionNodeBorderColor(this.revisionNode);
        if (this.revisionNode.hasIncomingMerges()) {
            StringBuilder str = new StringBuilder();
            NodeMergeData[] md = this.revisionNode.getIncomingMerges();
            str.append(md.length).append(" (");
            int revsCount = 0;
            NodeMergeData[] nodeMergeDataArray = md;
            int n2 = md.length;
            n = 0;
            while (n < n2) {
                NodeMergeData data = nodeMergeDataArray[n];
                revsCount += data.getRevisionsCount();
                ++n;
            }
            str.append(revsCount).append(" ").append(SVNRevisionGraphMessages.RevisionFigure_Revisions).append(")");
            this.incomingMergeLabel.setText(str.toString());
        }
        if (this.revisionNode.hasOutgoingMerges()) {
            NodeMergeData[] md = this.revisionNode.getOutgoingMerges();
            int revsCount = 0;
            NodeMergeData[] nodeMergeDataArray = md;
            n = md.length;
            int n3 = 0;
            while (n3 < n) {
                NodeMergeData data = nodeMergeDataArray[n3];
                revsCount += data.getRevisionsCount();
                ++n3;
            }
            String str = String.valueOf(revsCount);
            this.outgoingMergeLabel.setText(str);
        }
    }

    public void init() {
        this.setPreferredSize(200, this.getPreferredSize().height);
    }

    public void changeMerges() {
        if (this.isIncomingMergePressed && !this.revisionNode.hasIncomingMergeConnections()) {
            this.incomingMergeLabel.setIcon(INCOMING_MERGE_IMAGE);
            this.isIncomingMergePressed = false;
        }
        if (this.isOutgoingMergePressed && !this.revisionNode.hasOutgoingMergeConnections()) {
            this.outgoingMergeLabel.setIcon(OUTGOING_MERGE_IMAGE);
            this.isOutgoingMergePressed = false;
        }
    }

    public void changeTruncatePath() {
        if (this.pathFigure != null) {
            this.pathFigure.setShowFullPath(!this.revisionNode.isTruncatePath());
        }
    }

    public void setSelected(boolean isSelected) {
        if (this.isSelected != isSelected) {
            this.isSelected = isSelected;
            this.nodeColor = this.isSelected ? SELECTED_COLOR : this.originalNodeColor;
            this.repaint();
        }
    }

    public RevisionNode getRevisionNode() {
        return this.revisionNode;
    }

    public void invalidate() {
        this.prefSize = null;
        super.invalidate();
    }

    public static Color inverseColor(Color color) {
        return new Color(null, 255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static Color getRevisionNodeBorderColor(RevisionNode revisionNode) {
        PathRevision.ReviosionNodeType type = revisionNode.getType();
        PathRevision.RevisionNodeAction action = revisionNode.getAction();
        Color color = PathRevision.ReviosionNodeType.TRUNK.equals((Object)type) ? ColorConstants.green : (PathRevision.ReviosionNodeType.BRANCH.equals((Object)type) ? ColorConstants.green : (PathRevision.ReviosionNodeType.TAG.equals((Object)type) ? ColorConstants.black : (PathRevision.RevisionNodeAction.ADD.equals((Object)action) || PathRevision.RevisionNodeAction.COPY.equals((Object)action) ? ColorConstants.green : (PathRevision.RevisionNodeAction.RENAME.equals((Object)action) ? ColorConstants.blue : (PathRevision.RevisionNodeAction.DELETE.equals((Object)action) ? ColorConstants.red : (PathRevision.RevisionNodeAction.MODIFY.equals((Object)action) ? ColorConstants.black : ColorConstants.black))))));
        return color;
    }

    public static String getRevisionNodeStatusText(RevisionNode revisionNode) {
        PathRevision.ReviosionNodeType type = revisionNode.getType();
        PathRevision.RevisionNodeAction action = revisionNode.getAction();
        String text = "[";
        text = PathRevision.ReviosionNodeType.TRUNK.equals((Object)type) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Trunk : (PathRevision.ReviosionNodeType.BRANCH.equals((Object)type) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Branch : (PathRevision.ReviosionNodeType.TAG.equals((Object)type) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Tag : (PathRevision.RevisionNodeAction.ADD.equals((Object)action) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Create : (PathRevision.RevisionNodeAction.COPY.equals((Object)action) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Copy : (PathRevision.RevisionNodeAction.RENAME.equals((Object)action) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Rename : (PathRevision.RevisionNodeAction.DELETE.equals((Object)action) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Delete : (PathRevision.RevisionNodeAction.MODIFY.equals((Object)action) ? String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_Edit : String.valueOf(text) + SVNRevisionGraphMessages.RevisionFigure_NoChanges)))))));
        text = String.valueOf(text) + "]";
        return text;
    }

    public static Color getRevisionNodeColor(RevisionNode revisionNode) {
        PathRevision.ReviosionNodeType type = revisionNode.getType();
        PathRevision.RevisionNodeAction action = revisionNode.getAction();
        Color color = PathRevision.ReviosionNodeType.TRUNK.equals((Object)type) ? TRUNK_COLOR : (PathRevision.ReviosionNodeType.BRANCH.equals((Object)type) ? BRANCH_COLOR : (PathRevision.ReviosionNodeType.TAG.equals((Object)type) ? TAG_COLOR : (PathRevision.RevisionNodeAction.ADD.equals((Object)action) || PathRevision.RevisionNodeAction.COPY.equals((Object)action) ? CREATE_OR_COPY_COLOR : (PathRevision.RevisionNodeAction.RENAME.equals((Object)action) ? RENAME_COLOR : (PathRevision.RevisionNodeAction.DELETE.equals((Object)action) ? DELETE_COLOR : (PathRevision.RevisionNodeAction.MODIFY.equals((Object)action) ? MODIFY_COLOR : OTHER_COLOR))))));
        return color;
    }

    public static Image getRevisionNodeIcon(RevisionNode revisionNode) {
        PathRevision.ReviosionNodeType type = revisionNode.getType();
        PathRevision.RevisionNodeAction action = revisionNode.getAction();
        Image nodeIcon = null;
        nodeIcon = PathRevision.ReviosionNodeType.TRUNK.equals((Object)type) ? TRUNK_IMAGE : (PathRevision.ReviosionNodeType.BRANCH.equals((Object)type) ? BRANCH_IMAGE : (PathRevision.ReviosionNodeType.TAG.equals((Object)type) ? TAG_IMAGE : (PathRevision.RevisionNodeAction.ADD.equals((Object)action) || PathRevision.RevisionNodeAction.COPY.equals((Object)action) ? ADD_IMAGE : (PathRevision.RevisionNodeAction.RENAME.equals((Object)action) ? RENAME_IMAGE : (PathRevision.RevisionNodeAction.DELETE.equals((Object)action) ? DELETE_IMAGE : (PathRevision.RevisionNodeAction.MODIFY.equals((Object)action) ? MODIFY_IMAGE : OTHER_IMAGE))))));
        return nodeIcon;
    }

    public static String getActionAsString(PathRevision.RevisionNodeAction action) {
        switch (action) {
            case ADD: {
                return SVNRevisionGraphMessages.RevisionFigure_ActionAdd;
            }
            case DELETE: {
                return SVNRevisionGraphMessages.RevisionFigure_ActionDelete;
            }
            case MODIFY: {
                return SVNRevisionGraphMessages.RevisionFigure_ActionModify;
            }
            case COPY: {
                return SVNRevisionGraphMessages.RevisionFigure_ActionCopy;
            }
            case RENAME: {
                return SVNRevisionGraphMessages.RevisionFigure_ActionRename;
            }
            case NONE: {
                return SVNRevisionGraphMessages.RevisionFigure_ActionNone;
            }
        }
        return null;
    }

    public static String getChangedPathsAsString(RevisionNode node) {
        StringBuilder str = new StringBuilder();
        ChangedPath[] changedPaths = node.getChangedPaths();
        int i = 0;
        while (i < changedPaths.length) {
            ChangedPath changedPath = changedPaths[i];
            str.append(changedPath.action).append(" ").append(changedPath.path);
            if (changedPath.copiedFromPath != null) {
                str.append(" copied from: " + changedPath.copiedFromPath + "@" + changedPath.copiedFromRevision);
            }
            if (i != changedPaths.length - 1) {
                str.append("\n");
            }
            ++i;
        }
        return str.toString();
    }

    public static String getIncomingMergesAsString(RevisionNode node) {
        if (node.hasIncomingMerges()) {
            StringBuilder str = new StringBuilder();
            NodeMergeData[] mergedData = node.getIncomingMerges();
            int i = 0;
            while (i < mergedData.length) {
                str.append(mergedData[i].path).append(": ");
                boolean isFirstRow = true;
                List<RevisionTooltipFigure.Range> ranges = RevisionTooltipFigure.Range.getRanges(mergedData[i].getRevisions());
                int j = 0;
                int n = ranges.size();
                while (j < n) {
                    str.append(ranges.get(j));
                    if (j != n - 1) {
                        str.append(",");
                        if (isFirstRow && (j + 1) % 5 == 0) {
                            str.append("\n");
                            isFirstRow = false;
                        } else if (!isFirstRow && (j + 1) % 15 == 0) {
                            str.append("\n");
                        }
                    }
                    ++j;
                }
                if (i != mergedData.length - 1) {
                    str.append("\n");
                }
                ++i;
            }
            return str.toString();
        }
        return null;
    }

    public static String getOutgoingMergesAsString(RevisionNode node) {
        if (node.hasOutgoingMerges()) {
            StringBuilder str = new StringBuilder();
            NodeMergeData[] mergedData = node.getOutgoingMerges();
            int i = 0;
            while (i < mergedData.length) {
                str.append(mergedData[i].path).append(": ");
                long[] revisions = mergedData[i].getRevisions();
                Arrays.sort(revisions);
                int j = 0;
                int n = revisions.length;
                while (j < n) {
                    str.append(revisions[j]);
                    if (j != n - 1) {
                        str.append(",");
                    }
                    ++j;
                }
                if (i != mergedData.length - 1) {
                    str.append("\n");
                }
                ++i;
            }
            return str.toString();
        }
        return null;
    }
}

