<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/

include_once('sugar_version.php');
require_once('log4php/LoggerManager.php');
include_once('include/database/MssqlHelper.php');

class FreeTDSHelper extends MssqlHelper 
{

	function FreeTDSHelper()
	{
        parent::MssqlHelper();	
	}	

	
	/**
	* This is a private (php does not support it as of 4.x) method.
	* It outputs a correct string for the sql statement according to value
	* Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
	* All Rights Reserved..
	* Contributor(s): ______________________________________..
	*/	
	function massageValue($val, $fieldDef){
        if (!$val) return "''";
        $type = $this->getFieldType($fieldDef);
        
		switch ($type){
		  case 'int':
		  case 'double':
		  case 'float':
		  case 'uint':
		  case 'ulong':
		  case 'long':
		  case 'short':
          case 'tinyint':
		    return $val;
		    break;
		}
        
		$qval = $this->quote($val);

		switch ($type){
		  case 'varchar':
		  case 'nvarchar':
          case 'char':
          case 'nchar':
          case 'longtext':
		  case 'text':
		  case 'ntext':		  
		  case 'enum':
          case 'blob':
          case 'longblob':
          case 'clob':
          case 'id':
		  	return $qval;
		  	break;
		  case 'date':
		    return "$qval";
		    break;
		  case 'datetime':
		    return $qval;
		    break;
		  case 'time':
		    return "$qval";
		    break;
		}		
		return $val;
	}	
    
    /** returns the valid type for a column given the type in fieldDef
    */
    function getColumnType($type, $name, $table){

		$map = array( 'int'      => 'int'
                    , 'double'   => 'float'
                    , 'float'    => 'float'
                    , 'uint'     => 'int'
                    , 'ulong'    => 'int'
                    , 'long'     => 'bigint'
                    , 'short'    => 'smallint' 
                    , 'varchar'  => 'nvarchar'
                    , 'nvarchar' => 'nvarchar'
                    , 'longtext' => 'text'
                    , 'text'     => 'text'
                    , 'ntext'    => 'ntext'  
                    , 'date'     => 'datetime'
                    , 'enum'     => 'varchar'
                    , 'datetime' => 'datetime'
                    , 'time'     => 'datetime'
                    , 'bool'     => 'bit'
                    , 'tinyint'  => 'tinyint'
                    , 'char' => 'char'
                    , 'nchar'  => 'nchar'
                    , 'blob'  => 'ntext'
                    , 'longblob' => 'ntext'
                    , 'decimal' => 'decimal'  
                    , 'decimal2' => 'decimal'
                    , 'currency' => 'decimal'  
                    , 'id' => 'varchar(36)'
                );

        if(isset($table) && $table != '') {
           if(($type == 'varchar' || $type == 'char' || $type == 'text') &&
               !preg_match('/($id^)|(.*?_id$)|(.*?_id_del$)/is', $name) && 
               !preg_match('/(^workflow_.*?)|(^data)|(expressions)|(systems)|(^timeperiods$)|(^tracker$)|(^upgrade_history$)|(^worksheet$)|(^relationships$)/is', $table)) {
           	   return $map['n'.$type];
           }	
        }        
        return $map[$type];
        
    }
    

	function oneColumnSQLRep($fieldDef,  $ignoreRequired = false, $table=''){        











       	
		$name = $fieldDef['name'];
		$type = $this->getFieldType($fieldDef);
		$colType = $this->getColumnType($type, $name, $table);

        if (( $colType == 'varchar' or $colType == 'char' or $colType == 'varchar2') ) {
            	if( !empty($fieldDef['len']))
            		$colType .= "(".$fieldDef['len'].")";
            	else $colType .= "(255)";
        }

        if($colType == 'nvarchar' or $colType == 'nchar') {
            	if( !empty($fieldDef['len']))
            		$colType .= "(".$fieldDef['len'].")";
            	else $colType .= "(255)";
        }
   
        if($colType == 'decimal' || $colType == 'float'){
        	if(!empty($fieldDef	['len'])){
        		if(substr_count($fieldDef['len'], ',') == 1){
            		$colType .= "(".$fieldDef['len'].")";
        		}
        	}
        }

		if (isset($fieldDef['default']) ){
            $default = " DEFAULT '".$fieldDef['default']."'";
		}else if(!isset($default) && $type == 'bool'){
        	$default = " DEFAULT 0 ";
        }else if(!isset($default)){
        	$default = '';
        }

        $auto_increment = '';
        if(!empty($fieldDef['auto_increment']) && $fieldDef['auto_increment']){

        	$auto_increment = $this->setAutoIncrement($table , $fieldDef['name']);
        }
        
        $required = 'NULL';  // MySQL defaults to NULL, SQL Server defaults to NOT NULL -- must specify
        if (!$ignoreRequired and (isset($fieldDef['required']) && $fieldDef['required'])){
			 $required =  "NOT NULL";
        }
        if($name == 'id' && !isset($fieldDef['required'])){
        	$required =  "NOT NULL";
        }

        $rep = "$name $colType $default $required $auto_increment";   
        return $rep; 
    }

}

?>
