<?php	
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
class MBLanguage{
		var $iTemplates = array();
		var $templates = array();
		function MBLanguage( $name, $path, $label, $key_name){
			$this->path = $path;
			$this->name = $name;
			$this->key_name = $key_name;
			$this->label = $label;
		}
		
		function load(){
			$this->generateModStrings();
			$this->generateAppStrings();
		}
		
		function loadStrings($file){
			$module = strtoupper($this->name);
            $object_name = strtoupper($this->key_name);
            $_object_name = strtolower($this->name);
			if(!file_exists($file))return;
			
			$d = dir($file);
			while($e = $d->read()){
				if(substr($e, 0, 1) != '.' && is_file($file . '/' . $e)){
					include($file.'/'. $e);
					if(empty($this->strings[$e])){
						
						$this->strings[$e] = $mod_strings;
					}else{
						$this->strings[$e] = array_merge($this->strings[$e], $mod_strings);
					}
					
					
				}
			}
		}
		
	function loadAppListStrings($file){
			
			if(!file_exists($file))return;
			//we may not need this when loading in the app strings, but there is no harm
			//in setting it.
			$object_name = strtolower($this->key_name);
			
			$d = dir($file);
			while($e = $d->read()){
				if(substr($e, 0, 1) != '.' && is_file($file . '/' . $e)){
					include($file.'/'. $e);
					if(empty($this->appListStrings[$e])){
						
						$this->appListStrings[$e] = $app_list_strings;
					}else{
						$this->appListStrings[$e] = array_merge($this->appListStrings[$e], $app_list_strings);
					}
					
					
				}
			}
		}
		
		function generateModStrings(){
			$this->strings = array();
			$this->loadTemplates();
			
			foreach($this->iTemplates as $template=>$val){
				$file = MB_IMPLEMENTS . '/' . $template . '/language';
				$this->loadStrings($file);
			}
			foreach($this->templates as $template=>$val){
				$file = MB_TEMPLATES . '/' . $template . '/language';
				$this->loadStrings($file);
			}
			$this->loadStrings($this->path . '/language');
		}
		
		function getModStrings($language='en_us'){
			$language .= '.lang.php';
			if(!empty($this->strings[$language]))return $this->strings[$language];
			if(!empty($this->strings['en_us.lang.php']))return $this->strings['en_us.lang.php'];
			$empty = array();
			return $empty;
		}
		function getAppListStrings($language='en_us'){
			$language .= '.lang.php';
			if(!empty($this->appListStrings[$language]))return $this->appListStrings[$language];
			if(!empty($this->appListStrings['en_us.lang.php']))return $this->appListStrings['en_us.lang.php'];
			$empty = array();
			return $empty;
		}
		
		function generateAppStrings($buildFromTemplate = true){
			$this->appListStrings = array('en_us.lang.php'=>array());
			$this->loadAppListStrings($this->path . '/../../language/application');
			
			if($buildFromTemplate){
				//go through the templates application strings and load anything that is needed
				foreach($this->iTemplates as $template=>$val){
					$file = MB_IMPLEMENTS . '/' . $template . '/language/application';
					$this->loadAppListStrings($file);
				}
				foreach($this->templates as $template=>$val){
					$file = MB_TEMPLATES . '/' . $template . '/language/application';
					$this->loadAppListStrings($file);
				}
			}
		}
		function save($key_name, $duplicate=false){
			global $mod_strings;
			$header = file_get_contents('modules/ModuleBuilder/MB/header.php');
			$required = array(
			'LBL_LIST_FORM_TITLE'=>$this->label . " " . $mod_strings['LBL_LIST'],
			'LBL_MODULE_NAME'=>$this->label,
			'LBL_MODULE_TITLE'=>$this->label,
			//FOR GENERIC MENU
			'LNK_NEW_RECORD'=>$mod_strings['LBL_CREATE'] ." ". $this->label,
			'LNK_LIST'=>$this->label,
			'LBL_SEARCH_FORM_TITLE'=>$mod_strings['LBL_SEARCH'] ." ". $this->label,	
			'LBL_HISTORY_SUBPANEL_TITLE'=>$mod_strings['LBL_HISTORY'],
			'LBL_ACTIVITIES_SUBPANEL_TITLE'=>$mod_strings['LBL_ACTIVITIES'],
			'LBL_'.strtoupper($this->key_name).'_SUBPANEL_TITLE'=>$this->label,	
			'LBL_NEW_FORM_TITLE' => $mod_strings['LBL_NEW'] ." ". $this->label,
			);
			$save_path = $this->path . '/language';
			mkdir_recursive($save_path);
			foreach($this->strings as $lang=>$values){
				foreach($required as $k=>$v){
					$values[$k] = $v;
				}
				write_array_to_file('mod_strings', $values, $save_path .'/'.$lang,'w', $header);
			}
			$app_save_path = $this->path . '/../../language/application';
			mkdir_recursive($app_save_path);
			$key_changed = ($this->key_name != $key_name);
			
			foreach($this->appListStrings as $lang=>$values){
				if(!$duplicate){
					unset($values['moduleList'][$this->key_name]);
				}
				$values['moduleList'][$key_name]= $this->label;
				$appFile = $header. "\n";
				foreach($values as $key=>$array){
					if($key == 'moduleList'){
						foreach($array as $k=>$v){
							
							$appFile .= '$app_list_strings["moduleList"]["'. $k .'"] = ' . var_export_helper($v) . ";\n";
						}
					}else{
						if($duplicate){
							//keep the original when duplicating
							$appFile .= '$app_list_strings["'. $key .'"] = ' . var_export_helper($array) . ";\n";
						}
						$okey = $key;
						if($key_changed)$key = str_replace($this->key_name, $key_name, $key);
						if($key_changed)$key = str_replace(strtolower($this->key_name), strtolower($key_name), $key);
						// if we aren't duplicating or the key has changed let's add it
						if(!$duplicate || $okey != $key){
							$appFile .= '$app_list_strings["'. $key .'"] = ' . var_export_helper($array) . ";\n";
						}
					}
				}
			
				$fp = fopen($app_save_path . '/'. $lang, 'w');
				fwrite($fp, $appFile);
				fclose($fp);
			}
		}
		
		
		
		function build($path){
			if(file_exists($this->path.'/language/'))
			copy_recursive($this->path.'/language/', $path . '/language/');
		}
		
		function loadTemplates() {
			if(empty($this->templates)){
				if (file_exists("$this->path/config.php")) {
					include "$this->path/config.php";
					$this->templates = $config['templates'];
					$this->iTemplates = array();
				}
			}
		}
		
		/**
		 * Reset the templates and load the language files again.  This is called from 
		 * MBModule->save() once the config file has been written.
		 */
		function reload(){
			$this->templates = null;
			$this->load();
		}
		
	
}
