<?php
if (! defined('sugarEntry') || ! sugarEntry)
	die('Not A Valid Entry Point');
/**
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 */



require_once ('modules/ModuleBuilder/parsers/ModuleBuilderParser.php');

class ParserLabel extends ModuleBuilderParser
{

	/**
	 * Takes in the request params from a save request and processes
	 * them for the save.
	 *
	 * @param REQUEST params  $params
	 */
	function handleSave ($params, $module, $language)
	{

//		if ((($params ['module'] == 'ModuleBuilder') || (isset($params ['MB']) && $params ['MB'] == '1' && $params ['subpanel'] == "")) && (empty($params ['view_package']) || $params ['view_package'] != 'studio'))

	    if (!empty($params['MB']) && isset($params['view_package']) && $params['view_package']!='studio') //we are in Module builder && empty($params['subpanel']) && ( isset($params['view_package']) && ( empty($params ['view_package']) || $params ['view_package'] != 'studio')) )
		{
		    if($params['view_package'])
				$dirname = "custom/modulebuilder/packages/{$params['view_package']}/modules/$module/language";
			else
			    $dirname = "custom/modulebuilder/packages/{$params['package']}/modules/$module/language";
		}
		else //we are in studio
		{
			$dirname = "custom/modules/$module/language";
			if (!is_dir($dirname))
			{
			    require_once('modules/Administration/Common.php');
			    create_module_lang_dir($module);
			}
		}
		$filename = "$dirname/$language.lang.php";
		$dir_exists = is_dir($dirname);
//		require_once ('modules/Administration/Common.php');
//		if (! $dir_exists)
//		{
//			require_once ('include/utils.php');
//			$dir_exists = mkdir_recursive($dirname, true);

//		}

		if ($dir_exists)
		{
			if (file_exists($filename))
			{
				include ($filename);
			}
		} else
		{
			return false;
		}
		$changed = false;
	        
        //$charset = (isset($app_strings['LBL_CHARSET'])) ? $app_strings['LBL_CHARSET'] : $GLOBALS['sugar_config']['default_charset'] ;

        foreach ($params as $key => $value)
        {
            if (preg_match('/^label_/', $key) && strcmp($value, 'no_change') != 0)
            {
                $key = substr($key, 6);
                if (! isset($mod_strings [$key]) || strcmp($value, $mod_strings [$key]) != 0)
                {
                    // here we assume that the charset does not change between language packs; that is, default_charset is applicable for all language packs...
                    $mod_strings [$key] = html_entity_decode_utf8($value, ENT_QUOTES ); // must match encoding used in view.labels.php
                    $changed = true;
                }
            }
        }
		if ($changed)
		{
			$cache_key = "module_language." . $language . $module;
			sugar_cache_clear($cache_key);
			if (! write_array_to_file("mod_strings", $mod_strings, $filename))
			{
				$GLOBALS ['log']->fatal("Could not write $filename");
			}else{
				LanguageManager::clearLanguageCache($module, $language);
			}
		}
		return true;
	}
}

?>
