<?php

/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/


//////////////////////////////////////////////////////////////////////////////////////////
//// This is a stand alone file that can be run from the command prompt for upgrading a
//// Sugar Instance. Three parameters are required to be defined in order to execute this file.
//// php.exe -f silentUpgrade.php [Path to Upgrade Package zip] [Path to Log file] [Path to Instance]
//// See below the Usage for more details.
/////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
////	UTILITIES THAT MUST BE LOCAL :(
function prepSystemForUpgradeSilent() {
	global $subdirs;
	global $cwd;
	global $sugar_config;

	// make sure dirs exist
	foreach($subdirs as $subdir) {
    	mkdir_recursive(clean_path("{$cwd}/{$sugar_config['upload_dir']}upgrades/{$subdir}"));
	}
}
// Create a relationship that is missing
function createLeadsUserRel(){
	$guid = create_guid();
	$query = "SELECT id FROM relationships WHERE relationship_name = 'leads_assigned_user'";
	$result= $GLOBALS['db']->query($query, true);
	$a = $GLOBALS['db']->fetchByAssoc($result);
	//create the relationship all the time
	//if(isset($a['id']) && $a['id'] != null){
	  //relationship exists
	//}
	//else{
	$qRel = "INSERT INTO relationships (id,relationship_name, lhs_module, lhs_table, lhs_key, rhs_module, rhs_table, rhs_key, join_table, join_key_lhs, join_key_rhs, relationship_type, relationship_role_column, relationship_role_column_value, reverse, deleted)
						VALUES ('{$guid}', 'leads_assigned_user','Users','users','id','Leads','leads','assigned_user_id',NULL,NULL,NULL,'one-to-many',NULL,NULL,'0','0')";
	$GLOBALS['db']->query($qRel);
	//}
}

//Bug 19230. This is a specia use case becase there was a schema change in 451i and
// the upgrade from 451i to 500 was complaining about a duplicate index.

function dropIndexLeadsFor451iTo500Upgrade(){
	global $sugar_version;
	global $db;
	if(strcmp($sugar_version,'5.0.0') < 0 ){
		if($sugar_version == '4.5.1i' || $sugar_version > '4.5.1i'){
			global $db;
			if($db->dbType == 'oci8'){
				$query = "DROP INDEX idx_lead_acct_name_first";
			}
			if($db->dbType == 'mysql'){
				$query = "ALTER TABLE leads DROP INDEX idx_lead_acct_name_first";
			}
			if($db->dbType == 'mssql'){
				$query = "DROP INDEX idx_lead_acct_name_first on leads";
			}
			$result = $db->query($query);
	 	}
	}
}

function rebuildRelations(){
	$_REQUEST['silent'] = true;
	include('modules/Administration/RebuildRelationship.php');
	 $_REQUEST['upgradeWizard'] = true;
	 include('modules/ACL/install_actions.php');
}

function postInstall($unzip_dir,$postScriptPath){
	$file = "{$unzip_dir}/".constant($postScriptPath);
	if(is_file($file)) {
		include($file);
		post_install();
	}
}

////	END UTILITIES THAT MUST BE LOCAL :(
///////////////////////////////////////////////////////////////////////////////


// only run from command line
if(isset($_SERVER['HTTP_USER_AGENT'])) {
	die('This utility may only be run from the command line or command prompt.');
}
//Clean_string cleans out any file  passed in as a parameter
$_SERVER['PHP_SELF'] = 'silentUpgrade.php';
///////////////////////////////////////////////////////////////////////////////
////	USAGE
$usage =<<<eoq
Usage: php.exe -f silentUpgrade.php [upgradeZipFile] [logFile] [pathToSugarInstance] [admin_user]

On Command Prompt Change directory to where silentUpgrade.php resides. Then type path to
php.exe followed by -f silentUpgrade.php and the arguments.

Example:
    [path-to-PHP/]php.exe -f silentUpgrade.php [path-to-upgrade-package/]SugarEnt-Upgrade-4.5.1-to-5.0.0b.zip    [path-to-log-file/]silentupgrade.log  [path-to-sugar-instance/]Sugar451e [admin_user]

Arguments:
    SugarEnt-Upgrade-4.5.1-to-5.0.0b.zip : Upgrade package name
    silentupgrade.log                    : Silent Upgarde log file.
    Sugar451e                            : Sugar Instance being upgraded.
	admin_user                           : admin user performing the upgrade

eoq;
////	END USAGE
///////////////////////////////////////////////////////////////////////////////

if(count($argv) < 4) {
	echo $usage;
	die();
}

///////////////////////////////////////////////////////////////////////////////
////	HANDLE RUNNING FROM PATH OUTSIDE OF INSTANCE
$cwd = getcwd(); // default to current, assumed to be in a valid SugarCRM root dir.

if(isset($argv[3])) {
	if(is_dir($argv[3])) {
		$cwd = $argv[3];
		chdir($cwd);
	} else {
		echo "*******************************************************************************\n";
		echo "*** ERROR: 3rd parameter must be a valid directory.  Tried to cd to [ {$argv[3]} ].\n";
		echo $usage;
		echo "FAILURE\n";
		die();
	}
}

// make sure we're in a Sugar root dir
if(!is_file("{$cwd}/include/entryPoint.php")) {
	echo "*******************************************************************************\n";
	echo "*******************************************************************************\n";
	echo "*** ERROR: Tried to execute in a non-SugarCRM root directory.  Pass the correct 3rd parameter.\n";
	echo $usage;
	echo "FAILURE\n";
	die();
}


///////////////////////////////////////////////////////////////////////////////
////	STANDARD REQUIRED SUGAR INCLUDES AND PRESETS
if(!defined('sugarEntry')) define('sugarEntry', true);

$_SESSION = array();
$_SESSION['schema_change'] = 'sugar'; // we force-run all SQL
$_SESSION['silent_upgrade'] = true;
$_SESSION['step'] = 'silent'; // flag to NOT try redirect to 4.5.x upgrade wizard

$_REQUEST = array();
$_REQUEST['addTaskReminder'] = 'remind';
$_REQUEST['silent'] = true;


require_once('include/entryPoint.php');
require_once('include/dir_inc.php');
require_once('include/utils/zip_utils.php');
require_once('modules/Administration/UpgradeHistory.php');
require_once('include/utils.php');
require_once('modules/Users/User.php');
//require_once('modules/UpgradeWizard/uw_utils.php'); // must upgrade UW first
require_once("{$cwd}/sugar_version.php"); // provides $sugar_version & $sugar_flavor

//Setting the error level to 1 (Fatal). This level of error_reporting will make sure that error
//is reported if there is a problem in script execution. A non-strict mode. This is being done in order to avoid all
//the unnecessary notices that might come from Application code.

ini_set('error_reporting',1);

//////////////////////////////////////////////////////////////////////////////
//Adding admin user tot eh silent upgrade
$current_user = new User();
if(isset($argv[4])) {
   $user_name = $argv[4];
   $q = "select id from users where user_name = '" . $user_name . "' and is_admin=1";
   $result = $GLOBALS['db']->query($q, false);
   $logged_user = $GLOBALS['db']->fetchByAssoc($result);
   if(isset($logged_user['id']) && $logged_user['id'] != null){
	//do nothing
    $current_user->retrieve($logged_user['id']);
   }
   else{
   	echo "Not an admin user in users table. Please provide an admin user\n";
	die();
   }
}
else {
	echo "*******************************************************************************\n";
	echo "*** ERROR: 4th parameter must be a valid admin user.\n";
	echo $usage;
	echo "FAILURE\n";
	die();
}


///////////////////////////////////////////////////////////////////////////////
////	CONFIRM NECESSARY ARGS
if(count($argv) < 4) {
	echo "*******************************************************************************\n";
	echo "*** ERROR: Missing required parameters.  Received ".($argc - 1)." argument(s), require 2.\n";
	echo $usage;
	echo "FAILURE\n";
	die();
}

if(!is_file($argv[1])) { // valid zip?
	echo "*******************************************************************************\n";
	echo "*** ERROR: First argument must be a full path to the patch file. Got [ {$argv[1]} ].\n";
	echo $usage;
	echo "FAILURE\n";
	die();
}
////	CONFIRM NECESSARY ARGS
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
////	PREP LOCALLY USED PASSED-IN VARS & CONSTANTS
$GLOBALS['log']	= LoggerManager::getLogger('SugarCRM');
$patchName		= basename($argv[1]);
$zip_from_dir	= substr($patchName, 0, strlen($patchName) - 4); // patch folder name (minus ".zip")
$path			= $argv[2]; // custom log file, if blank will use ./upgradeWizard.log
$db				= &DBManager :: getInstance();
$UWstrings		= return_module_language('en_us', 'UpgradeWizard');
$adminStrings	= return_module_language('en_us', 'Administration');
$mod_strings	= array_merge($adminStrings, $UWstrings);
$subdirs		= array('full', 'langpack', 'module', 'patch', 'theme', 'temp');
global $unzip_dir;
$_REQUEST['zip_from_dir'] = $zip_from_dir;

define('SUGARCRM_PRE_INSTALL_FILE', 'scripts/pre_install.php');
define('SUGARCRM_POST_INSTALL_FILE', 'scripts/post_install.php');
define('SUGARCRM_PRE_UNINSTALL_FILE', 'scripts/pre_uninstall.php');
define('SUGARCRM_POST_UNINSTALL_FILE', 'scripts/post_uninstall.php');
////	END PREP LOCALLY USED PASSED-IN VARS
///////////////////////////////////////////////////////////////////////////////

/////retrieve admin user
global $sugar_config;
$configOptions = $sugar_config['dbconfig'];

/*
$current_user = new User();
$current_user->retrieve(1);
if(isset($current_user) && $current_user->user_name == null){
	echo "No admin user in users table. Create an admin user with id = 1\n";
	die();
}
*/

echo "\n";
echo "********************************************************************\n";
echo "***************This Upgrade process may take sometime***************\n";
echo "********************************************************************\n";
echo "\n";

///////////////////////////////////////////////////////////////////////////////
////	UPGRADE PREP
if(!is_dir(clean_path("{$cwd}/{$sugar_config['upload_dir']}/upgrades"))) {
	prepSystemForUpgradeSilent();
}

$unzip_dir = clean_path("{$cwd}/{$sugar_config['upload_dir']}upgrades/temp");
$install_file = clean_path("{$cwd}/{$sugar_config['upload_dir']}upgrades/patch/".basename($argv[1]));

$_SESSION['unzip_dir'] = $unzip_dir;
$_SESSION['install_file'] = $install_file;
$_SESSION['zip_from_dir'] = $zip_from_dir;

mkdir_recursive($unzip_dir);
if(!is_dir($unzip_dir)) {
	die("\nFAILURE\n");
}
unzip($argv[1], $unzip_dir);
// mimic standard UW by copy patch zip to appropriate dir
copy($argv[1], $install_file);
////	END UPGRADE PREP
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
////	UPGRADE UPGRADEWIZARD

$zipBasePath = clean_path("{$cwd}/{$sugar_config['upload_dir']}upgrades/temp/{$zip_from_dir}");
$uwFiles = findAllFiles(clean_path("{$zipBasePath}/modules/UpgradeWizard"), array());
$destFiles = array();

foreach($uwFiles as $uwFile) {
	$destFile = clean_path(str_replace($zipBasePath, $cwd, $uwFile));
	copy($uwFile, $destFile);
}
//Bug 19554. copy include/utils/user_utils.php to make sure that vcsmsi() is not redeclared.
if(file_exists("{$zipBasePath}/include/utils/user_utils.php")){
	$destFile = clean_path(str_replace($zipBasePath, $cwd, "{$zipBasePath}/include/utils/user_utils.php"));
	copy("{$zipBasePath}/include/utils/user_utils.php", $destFile);
}
require_once('modules/UpgradeWizard/uw_utils.php'); // must upgrade UW first
logThis("*** SILENT UPGRADE INITIATED.", $path);
logThis("*** UpgradeWizard Upgraded  ", $path);

if(function_exists('set_upgrade_vars')){
	set_upgrade_vars();
}

if($configOptions['db_type'] == 'mysql'){
	//Change the db wait_timeout for this session
	$que ="select @@wait_timeout";
	$result = $db->query($que);
	$tb = $db->fetchByAssoc($result);
	logThis('Wait Timeout before change ***** '.$tb['@@wait_timeout'] , $path);
	$query ="set wait_timeout=28800";
	$db->query($query);
	$result = $db->query($que);
	$ta = $db->fetchByAssoc($result);
	logThis('Wait Timeout after change ***** '.$ta['@@wait_timeout'] , $path);
}

////	END UPGRADE UPGRADEWIZARD
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
////	MAKE SURE PATCH IS COMPATIBLE
if(is_file("{$cwd}/{$sugar_config['upload_dir']}upgrades/temp/manifest.php")) {
	// provides $manifest array
	include("{$cwd}/{$sugar_config['upload_dir']}upgrades/temp/manifest.php");
	if(!isset($manifest)) {
		die("\nThe patch did not contain a proper manifest.php file.  Cannot continue.\n\n");
	} else {
		copy("{$cwd}/{$sugar_config['upload_dir']}upgrades/temp/manifest.php", "{$cwd}/{$sugar_config['upload_dir']}upgrades/patch/{$zip_from_dir}-manifest.php");

		$error = validate_manifest($manifest);
		if(!empty($error)) {
			$error = strip_tags(br2nl($error));
			die("\n{$error}\n\nFAILURE\n");
		}
	}
} else {
	die("\nThe patch did not contain a proper manifest.php file.  Cannot continue.\n\n");
}

//License prompt. Only for CE/OS now. Check for sugar flavor
global $sugar_config;
global $sugar_version;
global $sugar_flavor;


if($sugar_flavor == 'OS' || $sugar_flavor == 'CE'){
	if(!defined('STDOUT')) define('STDOUT', fopen('php://stdout', 'w'));
	if(!defined('STDIN')) define('STDIN', fopen('php://stdin', 'r'));

	$origVersion = substr(preg_replace("/[^0-9]/", "", $sugar_version),0,3);
	$targetVersion = substr(preg_replace("/[^0-9]/", "",$manifest['version']),0,3);
	if($origVersion < '500' && $targetVersion >= '500'){
		//check if license_accepted.txt exists.
		//Prompt for the license
		if($sugar_flavor == 'OS' || $sugar_flavor == 'CE'){
			$license_OS_CE = "The Sugar Community Edition 5.0 uses GNU General Public License Version 3. This upgrade will convert your existing license to the new license displayed below.";
			echo $license_OS_CE;
		}
		else{
			$license_file = $unzip_dir.'/'.$zip_from_dir.'/LICENSE.txt';
			if(file_exists($license_file)){
				$require_license = true;
				$stop = false;
				$fh = fopen($license_file, 'r');
			    $license_contents = fread($fh, filesize($license_file));
			    fclose($fh);
		   	}
		   	echo $license_contents;
		}
		  $name = '';
		while(true){
			fwrite(STDOUT, "DO YOU ACCEPT (Enter yes/y or no/n?: ");
			$name = trim(fgets(STDIN));
			if(strtolower($name) =='yes' || strtolower($name)=='y' || strtolower($name) =='no' || strtolower($name)=='n'){
				echo "\n";
				//echo '*******Thanks for answer***********';
				echo "\n";
				break;
			}
			else{
				echo "\n";
				echo '****Please enter a valid answer: Yes/No, y/n************';
				echo "\n";
		  	}
		}
		if(strtolower($name) =='no' || strtolower($name)=='n'){
			echo "\n";
			echo '*******Can not proceed****Logging out*******';
			echo "\n";
			die();
		}
		else{
			echo '*******License accepted **** Proceed with Upgrade***********';
		}
	}
}
////	END MAKE SURE PATCH IS COMPATIBLE
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
////	RUN SILENT UPGRADE
ob_start();
set_time_limit(0);
if(file_exists('ModuleInstall/PackageManager/PackageManagerDisplay.php')) {
	require_once('ModuleInstall/PackageManager/PackageManagerDisplay.php');
}

	$parserFiles = array();

if(file_exists(clean_path("{$zipBasePath}/include/SugarFields"))) {
	$parserFiles = findAllFiles(clean_path("{$zipBasePath}/include/SugarFields"), $parserFiles);
}

 //$cwd = clean_path(getcwd());
foreach($parserFiles as $file) {
	$srcFile = clean_path($file);
	//$targetFile = clean_path(getcwd() . '/' . $srcFile);
    if (strpos($srcFile,".svn") !== false) {
	  //do nothing
    }
    else{
    $targetFile = str_replace(clean_path($zipBasePath), $cwd, $srcFile);

	if(!is_dir(dirname($targetFile))) {
		mkdir_recursive(dirname($targetFile)); // make sure the directory exists
	}

	if(!file_exists($targetFile))
	 {
		logThis('Copying file to destination: ' . $targetFile);
		if(!copy($srcFile, $targetFile)) {
			logThis('*** ERROR: could not copy file: ' . $targetFile);
		} else {
			$copiedFiles[] = $targetFile;
		}
	} else {
		logThis('Skipping file: ' . $targetFile);
		//$skippedFiles[] = $targetFile;
	}
   }
 }

	 //Also copy clean50 from Administration module
 	if(file_exists(clean_path("{$zipBasePath}/modules/Administration/cleanup50.php"))) {
		$srcFile = clean_path(clean_path("{$zipBasePath}/modules/Administration/cleanup50.php"));
		$targetFile = str_replace(clean_path($zipBasePath), $cwd, $srcFile);
		if(!is_dir(dirname($targetFile))){
			mkdir_recursive(dirname($targetFile));
		}; // make sure the directory exists
		if(!copy($srcFile, $targetFile)) {
			logThis('*** ERROR: could not copy file: ' . $targetFile);
		} else {
			$copiedFiles[] = $targetFile;
		}
    }
/*
$errors = preflightCheck();
if((count($errors) == 1)) { // only diffs
	logThis('file preflight check passed successfully.');
}
else{
	die("\nThe user doesn't have sufficient permissions to write to database'.\n\n");
}
*/
//If version less than 500 then look for modules to be upgraded
if(function_exists('set_upgrade_vars')){
	set_upgrade_vars();
}
//Initialize the session variables. If upgrade_progress.php is already created
//look for session vars there and restore them
if(function_exists('initialize_session_vars')){
	initialize_session_vars();
}

if(!didThisStepRunBefore('preflight')){
	set_upgrade_progress('preflight','in_progress');
	if(substr($sugar_version,0,1) < 5) {
		require_once('modules/UpgradeWizard/upgradeMetaHelper.php');
		$helper = new UpgradeMetaHelper('upgraded451to500Files',$zipBasePath);
	}
	set_upgrade_progress('preflight','done');
}
////////////////COMMIT PROCESS BEGINS///////////////////////////////////////////////////////////////
////	MAKE BACKUPS OF TARGET FILES

if(!didThisStepRunBefore('commit')){
	set_upgrade_progress('commit','in_progress','commit','in_progress');
	if(!didThisStepRunBefore('commit','commitMakeBackupFiles')){
		set_upgrade_progress('commit','in_progress','commitMakeBackupFiles','in_progress');
		$errors = commitMakeBackupFiles($rest_dir, $install_file, $unzip_dir, $zip_from_dir, array());
		set_upgrade_progress('commit','in_progress','commitMakeBackupFiles','done');
	}

	///////////////////////////////////////////////////////////////////////////////
	////	HANDLE PREINSTALL SCRIPTS
	if(empty($errors)) {
		$file = "{$unzip_dir}/".constant('SUGARCRM_PRE_INSTALL_FILE');

		if(is_file($file)) {
			include($file);
			if(!didThisStepRunBefore('commit','pre_install')){
				set_upgrade_progress('commit','in_progress','pre_install','in_progress');
				pre_install();
				set_upgrade_progress('commit','in_progress','pre_install','done');
			}
		}
	}

	//require_once('modules/Administration/cleanup50.php');
	// All the Studio customized modules should be preserved in pre_500 folder
	$customized_mods = '';
	if(substr($sugar_version,0,1) < 5){
	     if(isset($_SESSION['Customized_Modules']) && $_SESSION['Customized_Modules'] != null){
	    	$customized_mods = $_SESSION['Customized_Modules'];
	    	$dir = clean_path(getcwd().'/customized451modules');
			if(!file_exists($dir)) {
				mkdir($dir, 0755);
			}
			$customizedModulesdir = $dir.'/modules';
			if(!file_exists($customizedModulesdir)) {
				mkdir($customizedModulesdir, 0755);
			}
	    	foreach($customized_mods as $module_name=>$files) {
				if(is_dir($customizedModulesdir)){
				 //put the customized files from 451
				 mkdir($customizedModulesdir.'/'.$module_name,0755);
				 copyRecursiveBetweenDirectories(clean_path(getcwd()).'/modules/'.$module_name,$customizedModulesdir.'/'.$module_name);
				}
			}
	     }
	}

	//Force clean files not required for MVC. This is to make sure if a file which shouldn't
	//be in MVC is removed even though customized. All the customized files are save anyway.
	//Also check if the current version is same as target version
	if(substr($sugar_version,0,1) < 5){
        if(!didThisStepRunBefore('commit','cleaningNonMVCFiles')){
        	set_upgrade_progress('commit','in_progress','cleaningNonMVCFiles','in_progress');
        	logThis('Start cleaning Non MVC files...');
	        	cleaningNonMVCFiles();
	        logThis('End cleaning Non MVC files...');
	        set_upgrade_progress('commit','in_progress','cleaningNonMVCFiles','done');
         }
	    //Removing file which match the md5
        if(!didThisStepRunBefore('commit','removingMD5MatchingFiles')){
	        set_upgrade_progress('commit','in_progress','removingMD5MatchingFiles','in_progress');
	        logThis('Start cleaning matching md5 files...');
		        $deleteNot=array('en_us.lang.php','company.jpg','Forms.php');
		        //removeMd5MatchingFiles($deleteNot);
		        if(!isset($_SESSION['removingMD5MatchingFiles']) && empty($_SESSION['removingMD5MatchingFiles'])){
			        removeMd5MatchingFiles($deleteNot);
		         }
		        else{
			        foreach($_SESSION['removingMD5MatchingFiles'] as $f){
						if(file_exists($f) && !in_array(basename($f),$deleteNot)){
							unlink($f);
						}
					}
		        }
		    set_upgrade_progress('commit','in_progress','removingMD5MatchingFiles','done');
	        logThis('End cleaning matching md5 files...');
        }
	}
	//Clean smarty from cache
	if(is_dir('cache/smarty')){
		$allModFiles = array();
		$allModFiles = findAllFiles('cache/smarty',$allModFiles);
	   foreach($allModFiles as $file){
	       	//$file_md5_ref = str_replace(clean_path(getcwd()),'',$file);
	       	if(file_exists($file)){
				unlink($file);
	       	}
	   }
	}


	///////////////////////////////////////////////////////////////////////////////
	////	COPY NEW FILES INTO TARGET INSTANCE

     if(!didThisStepRunBefore('commit','commitCopyNewFiles')){
			set_upgrade_progress('commit','in_progress','commitCopyNewFiles','in_progress');
			$split = commitCopyNewFiles($unzip_dir, $zip_from_dir);
	 		$copiedFiles = $split['copiedFiles'];
	 		$skippedFiles = $split['skippedFiles'];
			set_upgrade_progress('commit','in_progress','commitCopyNewFiles','done');
	 }

	///////////////////////////////////////////
	///// Look for customized modules as well as upgrade modules

	 if($customized_mods != null){
		foreach($customized_mods as $module_name=>$files) {
			mkdir(clean_path(getcwd().'/modules/'.$module_name.'/.pre_500'), 0755);
			mkdir(clean_path(getcwd().'/modules/'.$module_name.'/.500'), 0755);
			if(is_dir(clean_path(getcwd().'/modules/'.$module_name.'/.pre_500'))){
			 //put llthe files from module into pre_500
			 copyRecursiveBetweenDirectories(clean_path(getcwd()).'/customized451modules/modules/'.$module_name,clean_path(getcwd()).'/modules/'.$module_name.'/.pre_500');
		     //run these only in pre_500 modules
		     $cur_dir =clean_path(getcwd()).'/modules/'.$module_name.'/.pre_500';
		     if(!file_exists($cur_dir.'/metadata/subpaneldefs.php')){
		     	rename($cur_dir.'/layout_defs.php', $cur_dir.'/metadata/subpaneldefs.php');
		     }
		     if(!file_exists($cur_dir.'/metadata/subpanels')){
		     	rename($cur_dir.'/subpanels', $cur_dir.'/metadata/subpanels');
		     }
		     //Copy 500 dashlet files to the pre_500 module dashlet directory
		     if(file_exists($cur_dir.'/Dashlets')){
		     	//first clean the directory
		     	rmdir_recursive($cur_dir.'/Dashlets');
		     	//then copy from 500 to pre_500
		     	if(file_exists(clean_path(getcwd()).'/modules/'.$module_name.'/Dashlets')){
		     		copyRecursiveBetweenDirectories(clean_path(getcwd()).'/modules/'.$module_name.'/Dashlets',$cur_dir.'/Dashlets');
		     	}
		     }
			}
		 }
	  }

	$upgraded_mods = '';
	if(substr($sugar_version,0,1) < 5){
	    if(isset($_SESSION['Upgraded_Modules']) && $_SESSION['Upgraded_Modules']){
			$upgraded_mods = $_SESSION['Upgraded_Modules'];
	    }
	}
	/////////////////////////////////////////////

	//Also drop an index in leads which was added in 451i. A conditional drop
	  logThis('Start dropping idx_lead_acct_name_first...', $path);
	  	@dropIndexLeadsFor451iTo500Upgrade();
	  logThis('End dropping idx_lead_acct_name_first...', $path);
	//

	///////////////////////////////////////////////////////////////////////////////
	////	HANDLE POSTINSTALL SCRIPTS
	if(empty($errors)) {
		logThis('Starting post_install()...', $path);
		if(!didThisStepRunBefore('commit','post_install')){
			$file = "$unzip_dir/" . constant('SUGARCRM_POST_INSTALL_FILE');
			if(is_file($file)) {
				//set_upgrade_progress('commit','in_progress','post_install','in_progress');
				$progArray['post_install']='in_progress';
				post_install_progress($progArray,'set');
					include($file);
					post_install();
				// cn: only run conversion if admin selects "Sugar runs SQL"
				if(!empty($_SESSION['allTables']) && $_SESSION['schema_change'] == 'sugar')
					executeConvertTablesSql($db->dbType, $_SESSION['allTables']);
				//set process to done
				$progArray['post_install']='done';
				//set_upgrade_progress('commit','in_progress','post_install','done');
				post_install_progress($progArray,'set');
			}
		}
		//////////treat yui2 fils.. custom module files... upgrade files
	    if(substr($sugar_version,0,1) < 5){
		    //delete yui2
			if(file_exists(clean_path(getcwd()).'/include/javascript/yui2')){
				copyRecursiveBetweenDirectories(clean_path(getcwd()).'/include/javascript/yui2',clean_path(getcwd()).'/include/javascript/yui');
				rmdir_recursive(clean_path(getcwd()).'/include/javascript/yui2');
			}
			//also copying the customized modules to the custom modules for upgrade
			if(file_exists(clean_path(getcwd()).'/upgraded451to500Files')){
				//copyRecursiveBetweenDirectories(clean_path(getcwd()).'/upgraded451to500Files/modules',clean_path(getcwd()).'/modules');
			    if(!file_exists(clean_path(getcwd()).'/custom')){
			    	mkdir(clean_path(getcwd()).'/custom', 0755);
			    }
			    if(!file_exists(clean_path(getcwd()).'/custom/modules')){
			    	mkdir(clean_path(getcwd()).'/custom/modules', 0755);
			    }
				copyRecursiveBetweenDirectories(clean_path(getcwd()).'/upgraded451to500Files/modules',clean_path(getcwd()).'/custom/modules');
				rmdir_recursive(clean_path(getcwd()).'/upgraded451to500Files');
			 }
			if(file_exists(clean_path(getcwd()).'/customized451modules')){
				rmdir_recursive(clean_path(getcwd()).'/customized451modules');
			 }
	    }
		if(substr($sugar_version,0,1) < 5){
			require_once("$unzip_dir/scripts/drop_451_schema_after_upgrade_500.php");
			logThis('Start dropping the old schema', $path);
				ob_start();
				@drop_preUpgardeSchema();
				ob_end_clean();
			logThis('End dropping the old schema', $path);
		}

	    //clean vardefs
		logThis('Performing UWrebuild()...', $path);
		ob_start();
			@UWrebuild();
		ob_end_clean();
		logThis('UWrebuild() done.', $path);

		require("sugar_version.php");
		if(!rebuildConfigFile($sugar_config, $sugar_version)) {
			logThis('*** ERROR: could not write config.php! - upgrade will fail!', $path);
			$errors[] = 'Could not write config.php!';
		}
		logThis('post_install() done.', $path);
	}

	///////////////////////////////////////////////////////////////////////////////
	////	REGISTER UPGRADE
	if(empty($errors)) {
		logThis('Registering upgrade with UpgradeHistory', $path);
		if(!didThisStepRunBefore('commit','upgradeHistory')){
			set_upgrade_progress('commit','in_progress','upgradeHistory','in_progress');
			$file_action = "copied";
			// if error was encountered, script should have died before now
			$new_upgrade = new UpgradeHistory();
			$new_upgrade->filename = $install_file;
			$new_upgrade->md5sum = md5_file($install_file);
			$new_upgrade->name = $zip_from_dir;
			$new_upgrade->description = $manifest['description'];
			$new_upgrade->type = 'patch';
			$new_upgrade->version = $sugar_version;
			$new_upgrade->status = "installed";
			$new_upgrade->manifest = (!empty($_SESSION['install_manifest']) ? $_SESSION['install_manifest'] : '');

			if($new_upgrade->description == null){
				$new_upgrade->description = "Silent Upgrade was used to upgrade the instance";
			}
			else{
				$new_upgrade->description = $new_upgrade->description." Silent Upgrade was used to upgrade the instance.";
			}
		   $new_upgrade->save();
		}
	  }

	//Clean modules from cache
		if(is_dir('cache/smarty')){
			$allModFiles = array();
			$allModFiles = findAllFiles('cache/smarty',$allModFiles);
		   foreach($allModFiles as $file){
		       	//$file_md5_ref = str_replace(clean_path(getcwd()),'',$file);
		       	if(file_exists($file)){
					unlink($file);
		       	}
		   }
		}
   //delete cache/modules before rebuilding the relations
   	//Clean modules from cache
		if(is_dir('cache/modules')){
			$allModFiles = array();
			$allModFiles = findAllFiles('cache/modules',$allModFiles);
		   foreach($allModFiles as $file){
		       	//$file_md5_ref = str_replace(clean_path(getcwd()),'',$file);
		       	if(file_exists($file)){
					unlink($file);
		       	}
		   }
		}
	ob_start();
	if(!isset($_REQUEST['silent'])){
		$_REQUEST['silent'] = true;
	}
	else if(isset($_REQUEST['silent']) && $_REQUEST['silent'] != true){
		$_REQUEST['silent'] = true;
	}
	logThis('Start rebuild relationships.', $path);
	 	@rebuildRelations();
	logThis('End rebuild relationships.', $path);
	 //logThis('Checking for leads_assigned_user relationship and if not found then create.', $path);
		@createLeadsUserRel();
	 //logThis('Checked for leads_assigned_user relationship.', $path);
	ob_end_clean();
}

///////////////////////////////////////////////////////////////////////////////
////	TAKE OUT TRASH
if(empty($errors)) {
	logThis('Taking out the trash, unlinking temp files.', $path);
	unlinkTempFiles(true);
}

///////////////////////////////////////////////////////////////////////////////
////	HANDLE REMINDERS
if(empty($errors)) {
	commitHandleReminders($skippedFiles, $path);
}

if(file_exists(clean_path(getcwd()).'/original451files')){
	rmdir_recursive(clean_path(getcwd()).'/original451files');
}


///////////////////////////////////////////////////////////////////////////////
////	RECORD ERRORS
$phpErrors = ob_get_contents();
ob_end_clean();
logThis("**** Potential PHP generated error messages: {$phpErrors}", $path);

if(count($errors) > 0) {
	foreach($errors as $error) {
		logThis("****** SilentUpgrade ERROR: {$error}", $path);
	}
	echo "FAILED\n";
} else {
	logThis("***** SilentUpgrade completed successfully.", $path);
	echo "********************************************************************\n";
	echo "*************************** SUCCESS*********************************\n";
	echo "********************************************************************\n";

	echo "******** If your pre-upgrade Leads data is not showing  ************\n";
	echo "******** Or you see errors in detailview subpanels  ****************\n";
	echo "************* In order to resolve them  ****************************\n";
	echo "******** Log into application as Administrator  ********************\n";
	echo "******** Go to Admin panel  ****************************************\n";
	echo "******** Run Repair -> Rebuild Relationships  **********************\n";
	echo "********************************************************************\n";
}

?>
