<?php
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
/*
 * Created on May 30, 2007
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 require_once('include/tabs.php');
require_once('include/ListView/ListViewSmarty.php'); 
require_once('include/utils.php');
require_once('include/TemplateHandler/TemplateHandler.php');
require_once('include/EditView/EditView2.php');
require_once('modules/SavedSearch/SavedSearch.php');
 
 class SearchForm extends EditView{
 	var $seed = null;
 	var $module = '';
 	var $action = 'index';
 	var $searchdefs = array();
 	var $listViewDefs = array();
 	var $lv;
 	var $th;
    var $tpl;
    var $view = 'SearchForm';
    var $displayView = 'basic_search';
    var $formData;
    var $fieldDefs;
    var $customFieldDefs;
    var $tabs;
    var $parsedView = 'basic';
    //may remove
    var $searchFields;
    var $displaySavedSearch = true;
    
 	function SearchForm($seed, $module, $action = 'index'){
 		$this->th = new TemplateHandler();
 		$this->th->loadSmarty();
		$this->seed = $seed;
		$this->module = $module;
		$this->action = $action;
		
		$this->tabs = array(array('title'  => $GLOBALS['app_strings']['LNK_BASIC_SEARCH'],
                                  'link'   => $module . '|basic_search',
                                  'key'    => $module . '|basic_search'),
                            array('title'  => $GLOBALS['app_strings']['LNK_ADVANCED_SEARCH'],
                                  'link'   => $module . '|advanced_search',
                                  'key'    => $module . '|advanced_search'),
                               );
        $this->searchColumns = array () ;
 	}
 	
 	function setup($searchdefs, $searchFields = array(), $tpl, $displayView = 'basic_search', $listViewDefs = array()){
 		$this->searchdefs =  $searchdefs[$this->module];
 		$this->tpl = $tpl;
 		//used by advanced search
 		$this->listViewDefs = $listViewDefs;
 		$this->displayView = $displayView;
 		$this->view = $this->view.'_'.$displayView;
 		$tokens = split('_', $this->displayView);
 		$this->parsedView = $tokens[0];
 		if($this->displayView != 'saved_views'){
 			$this->_build_field_defs();
 		}
 		
 		/*if(file_exists('modules/' . $this->module . '/metadata/SearchFields.php'))
 			require_once('modules/' . $this->module . '/metadata/SearchFields.php');
       	if(file_exists('custom/modules/' . $this->module . '/metadata/SearchFields.php'))
       		require_once('custom/modules/' . $this->module . '/metadata/SearchFields.php');
        */
        
        $this->searchFields = $searchFields[$this->module];
 	}
 	
 	function display($header = true){
    global $theme, $timedate;
        $imagePath= "themes/$theme/images/";
 		$header_txt = '';
 		$footer_txt = '';
 		$return_txt = '';
		$this->th->ss->assign('module', $this->module);
		$this->th->ss->assign('action', $this->action);



		$this->th->ss->assign('displayView', $this->displayView);
		$this->th->ss->assign('templateMeta', $this->searchdefs['templateMeta']);
		$this->th->ss->assign('APP', $GLOBALS['app_strings']);
		$this->th->ss->assign('TABS', $this->_displayTabs($this->module . '|' . $this->displayView));
		$this->th->ss->assign('fields', $this->fieldDefs);
		$this->th->ss->assign('customFields', $this->customFieldDefs);
		$this->th->ss->assign('formData', $this->formData);
        $time_format = $timedate->get_user_time_format();
        $this->th->ss->assign('TIME_FORMAT', $time_format);
        $this->th->ss->assign('USER_DATEFORMAT', $timedate->get_user_date_format());

        $date_format = $timedate->get_cal_date_format();
        $time_separator = ":";
        if(preg_match('/\d+([^\d])\d+([^\d]*)/s', $time_format, $match)) {
           $time_separator = $match[1];
        }
        // Create Smarty variables for the Calendar picker widget
        $t23 = strpos($time_format, '23') !== false ? '%H' : '%I';
        if(!isset($match[2]) || $match[2] == '') {
          $this->th->ss->assign('CALENDAR_FORMAT', $date_format . ' ' . $t23 . $time_separator . "%M");
        } else {
          $pm = $match[2] == "pm" ? "%P" : "%p";
          $this->th->ss->assign('CALENDAR_FORMAT', $date_format . ' ' . $t23 . $time_separator . "%M" . $pm);
        }       
        $this->th->ss->assign('TIME_SEPARATOR', $time_separator);
        $this->th->ss->assign('IMG_PATH', $imagePath); 
            //if this is advanced tab, use form with saved search sub form built in
            if(strpos($this->view,'advanced')!==false){
                $this->tpl = 'include/SearchForm/tpls/SearchFormGenericAdvanced.tpl';
                if ($this->action =='ListView') {
                	$this->th->ss->assign('DISPLAY_SEARCH_HELP', true);
                }
                $this->th->ss->assign('DISPLAYADV', '');
                $this->th->ss->assign('DISPLAYBAS', 'display:none');
                $this->th->ss->assign('DISPLAY_SAVED_SEARCH', $this->displaySavedSearch);
                $this->th->ss->assign('SAVED_SEARCH', $this->displaySavedSearch());                
                //this determines whether the saved search subform should be rendered open or not
                if(isset($_REQUEST['showSSDIV']) && $_REQUEST['showSSDIV']=='yes'){
                    $this->th->ss->assign('SHOWSSDIV', 'yes');
                    $this->th->ss->assign('DISPLAYSS', '');
                }else{
                    $this->th->ss->assign('SHOWSSDIV', 'no');
                    $this->th->ss->assign('DISPLAYSS', 'display:none');                
                }
            }
            else{
            	$this->th->ss->assign('DISPLAYADV', 'display:none');
                $this->th->ss->assign('DISPLAYBAS', '');
            }
            $return_txt = $this->th->displayTemplate($this->seed->module_dir, $this->view, $this->tpl);

        if($header){
			$this->th->ss->assign($this->displayView.'_txt', $return_txt);
			$header_txt = $this->th->displayTemplate($this->seed->module_dir, 'SearchFormHeader', 'include/SearchForm/tpls/header.tpl');
            //pass in info to render the select dropdown below the form
            $this->th->ss->assign('IMG_PATH', $imagePath);
            $this->th->ss->assign('SAVED_SEARCHES_OPTIONS', $this->displaySavedSearchSelect());
            if ($this->module == 'Documents'){
            	$this->th->ss->assign('DOCUMENTS_MODULE', true);
            }
           	$footer_txt = $this->th->displayTemplate($this->seed->module_dir, 'SearchFormFooter', 'include/SearchForm/tpls/footer.tpl');
			$return_txt = $header_txt.$footer_txt;
		}
		return $return_txt;
 	}
    
  function displaySavedSearch(){
        $savedSearch = new SavedSearch($this->listViewDefs[$this->module], $this->lv->data['pageData']['ordering']['orderBy'], $this->lv->data['pageData']['ordering']['sortOrder']);
        return $savedSearch->getForm($this->module, false);
    }
 
  
  function displaySavedSearchSelect(){
        $savedSearch = new SavedSearch($this->listViewDefs[$this->module], $this->lv->data['pageData']['ordering']['orderBy'], $this->lv->data['pageData']['ordering']['sortOrder']);
        return $savedSearch->getSelect($this->module);
    }
 


 	/**
     * displays the tabs (top of the search form)
     * 
     * @param string $currentKey key in $this->tabs to show as the current tab
     * 
     * @return string html
     */
    function _displayTabs($currentKey) {
       
        $tabPanel = new SugarWidgetTabs($this->tabs, $currentKey, 'SUGAR.searchForm.searchFormSelect');
        
        $str = $tabPanel->display();
        $str .= '<script>';
        if(!empty($_REQUEST['displayColumns']))
            $str .= 'SUGAR.savedViews.displayColumns = "' . $_REQUEST['displayColumns'] . '";';
        if(!empty($_REQUEST['hideTabs']))
            $str .= 'SUGAR.savedViews.hideTabs = "' . $_REQUEST['hideTabs'] . '";';
        if(!empty($_REQUEST['orderBy']))
            $str .= 'SUGAR.savedViews.selectedOrderBy = "' . $_REQUEST['orderBy'] . '";';
        if(!empty($_REQUEST['sortOrder']))
            $str .= 'SUGAR.savedViews.selectedSortOrder = "' . $_REQUEST['sortOrder'] . '";';
            
        $str .= '</script>';
        
        return $str;
    }
 	
 	/*
	 * Generate the data
	 */
	function _build_field_defs(){
		$this->formData = array();
		
		$size = (!empty($this->searchdefs['templateMeta']['widths']['field']) ? $this->searchdefs['templateMeta']['widths']['field'] : 30);
		$this->fieldDefs = array();
		foreach($this->searchdefs['layout'][$this->displayView] as $data){
			if(is_array($data)){				
				$data['name'] = $data['name'].'_'.$this->parsedView;
				$this->formData[] = array('field' => $data);
				$value = '';
				$this->fieldDefs[$data['name']]= $data;	         
			}else
				$this->formData[] = array('field' => array('name'=>$data.'_'.$this->parsedView, 'displayParams' => array('size' => $size)));
		}

		if($this->seed){
			$this->seed->fill_in_additional_detail_fields();

	        foreach($this->seed->toArray() as $name => $value) {
	            if(!empty($this->fieldDefs[$name.'_'.$this->parsedView]))
	            	$this->fieldDefs[$name.'_'.$this->parsedView] = array_merge($this->seed->field_defs[$name], $this->fieldDefs[$name.'_'.$this->parsedView]);
	            else{
	            	$this->fieldDefs[$name.'_'.$this->parsedView] = $this->seed->field_defs[$name];
	            	$this->fieldDefs[$name.'_'.$this->parsedView]['name'] = $this->fieldDefs[$name.'_'.$this->parsedView]['name'].'_'.$this->parsedView;
	            }

	            if(isset($this->fieldDefs[$name.'_'.$this->parsedView]['type']) && $this->fieldDefs[$name.'_'.$this->parsedView]['type'] == 'relate') {
	               //$this->fieldDefs[$name.'_'.$this->parsedView]['type'] = 'name';
	            }

	            if(isset($this->fieldDefs[$name.'_'.$this->parsedView]['options']) && isset($GLOBALS['app_list_strings'][$this->fieldDefs[$name.'_'.$this->parsedView]['options']])) {
	                $this->fieldDefs[$name.'_'.$this->parsedView]['options'] = $GLOBALS['app_list_strings'][$this->fieldDefs[$name.'_'.$this->parsedView]['options']]; // fill in enums
	            }

	            if(isset($this->fieldDefs[$name.'_'.$this->parsedView]['function'])) {
	            	$this->fieldDefs[$name.'_'.$this->parsedView]['type']='multienum';
	       	 		
	       	 		if(is_array($this->fieldDefs[$name.'_'.$this->parsedView]['function'])) {
	       	 		   $this->fieldDefs[$name.'_'.$this->parsedView]['function']['preserveFunctionValue']=true;
	       	 		}
	       	 		
	       	 		$function = $this->fieldDefs[$name.'_'.$this->parsedView]['function'];
	       			if(is_array($function) && isset($function['name'])){
	       				$function = $this->fieldDefs[$name.'_'.$this->parsedView]['function']['name'];
	       			}else{
	       				$function = $this->fieldDefs[$name.'_'.$this->parsedView]['function'];
	       			}
	       			
					if(!empty($this->fieldDefs[$name.'_'.$this->parsedView]['function']['returns']) && $this->fieldDefs[$name.'_'.$this->parsedView]['function']['returns'] == 'html'){
						if(!empty($this->fieldDefs[$name.'_'.$this->parsedView]['function']['include'])){
								require_once($this->fieldDefs[$name.'_'.$this->parsedView]['function']['include']);
						}
						$value = $function($this->seed, $name, $value, $this->view);
						$this->fieldDefs[$name.'_'.$this->parsedView]['value'] = $value;
					}else{
						if(!isset($function['params'])) {
							$this->fieldDefs[$name.'_'.$this->parsedView]['options'] = $function($this->seed, $name, $value, $this->view);
						} else {
							$this->fieldDefs[$name.'_'.$this->parsedView]['options'] = call_user_func_array($function, $function['params']);	
						}
					}
	       	 	}
	       	 	if(isset($this->fieldDefs[$name]['type']) && $this->fieldDefs[$name.'_'.$this->parsedView]['type'] == 'function' && isset($this->fieldDefs[$name.'_'.$this->parsedView]['function_name'])){
	       	 		$value = $this->callFunction($this->fieldDefs[$name.'_'.$this->parsedView]);
	       	 		$this->fieldDefs[$name.'_'.$this->parsedView]['value'] = $value;
	       	 	}
	       	 	
	            $this->fieldDefs[$name]['value'] = $value;
	            
	            if(!empty($_REQUEST[$name.'_'.$this->parsedView]) && empty($this->fieldDefs[$name.'_'.$this->parsedView]['function']['preserveFunctionValue'])) {
	            	$value = $_REQUEST[$name.'_'.$this->parsedView];
	            	$this->fieldDefs[$name.'_'.$this->parsedView]['value'] = $value;
	            }
	            
	            
	        }
	        
		}

	}
	
	    /**
     * Populate the searchFields from an array
     * 
     * @param array $array array to search through
     * @param string $switchVar variable to use in switch statement
     * @param bool $addAllBeanFields true to process at all bean fields
     */
    function populateFromArray(&$array, $switchVar = null, $addAllBeanFields = true) {
       if((!empty($array['searchFormTab']) || !empty($switchVar)) && !empty($this->searchFields)) {
            
       		$arrayKeys = array_keys($array);
			
			
            $searchFieldsKeys = array_keys($this->searchFields);

            if(empty($switchVar)) $switchVar = $array['searchFormTab'];
            switch($switchVar) {
                case 'basic_search':
                    foreach($this->searchFields as $name => $params) {
                        if(!empty($array[$name . '_basic'])) {  
                            $this->searchFields[$name]['value'] = $array[$name . '_basic'];
							if(empty($this->fieldDefs[$name . '_basic']['value'])) $this->fieldDefs[$name . '_basic']['value'] = $array[$name . '_basic'];
                        }
		
                    }
                    if($addAllBeanFields) {
                        foreach($this->seed->field_name_map as $key => $params) {

                        	if(in_array($key . '_basic' , $arrayKeys) && !in_array($key, $searchFieldsKeys)) {
                                
                                $this->searchFields[$key] = array('query_type' => 'default', 
                                                                  'value'      => $array[$key . '_basic']);
                            }
                        }
                    }
                    break;
                case 'advanced_search':
                   foreach($this->searchFields as $name => $params) {
                        if(!empty($array[$name.'_advanced'])) {  
                            $this->searchFields[$name]['value'] = $array[$name.'_advanced'];
                            if(empty($this->fieldDefs[$name . '_advanced']['value'])) $this->fieldDefs[$name . '_advanced']['value'] = $array[$name . '_advanced'];
                        }else if(!empty($array[$name])) {  
                            $this->searchFields[$name]['value'] = $array[$name];
                            if(empty($this->fieldDefs[$name . '_advanced']['value'])) $this->fieldDefs[$name . '_advanced']['value'] = $array[$name];
                        }
                    }
                    if((empty($array['massupdate']) || $array['massupdate'] == 'false') && $addAllBeanFields) {
                        foreach($this->seed->field_name_map as $key => $params) {
                            if(in_array($key.'_advanced', $arrayKeys) && !in_array($key, $searchFieldsKeys)) {
                                $this->searchFields[$key] = array('query_type' => 'default', 
                                                                  'value'      => $array[$key.'_advanced']);
                            }
                        }
                    }
                    break;
                case 'saved_views':
                    foreach($this->searchFields as $name => $params) {
                        if(!empty($array[$name . '_basic'])) {  // save basic first
                            $this->searchFields[$name]['value'] = $array[$name . '_basic'];
                             if(empty($this->fieldDefs[$name . '_basic']['value'])) $this->fieldDefs[$name . '_basic']['value'] = $array[$name . '_basic'];
                        }
                        if(!empty($array[$name.'_advanced'])) {  // overwrite by advanced if available
                            $this->searchFields[$name]['value'] = $array[$name.'_advanced'];
                             if(empty($this->fieldDefs[$name . '_advanced']['value'])) $this->fieldDefs[$name . '_advanced']['value'] = $array[$name . '_advanced'];
                        }
                    }
                    if($addAllBeanFields) {
                        foreach($this->seed->field_name_map as $key => $params) {
                            if(!in_array($key, $searchFieldsKeys)) {
                                if(in_array($key . '_basic', $arrayKeys) ) {
                                    $this->searchFields[$key] = array('query_type' => 'default', 
                                                                      'value'      => $array[$key . '_basic']);
                                }
                                if(in_array($key.'_advanced', $arrayKeys)) {
                                    $this->searchFields[$key] = array('query_type' => 'default', 
                                                                      'value'      => $array[$key.'_advanced']);
                                }
                            }
                        }
                    }
            }
        }
    }
    
    /**
     * Populate the searchFields from $_REQUEST
     * 
     * @param string $switchVar variable to use in switch statement
     * @param bool $addAllBeanFields true to process at all bean fields
     */
    function populateFromRequest($switchVar = null, $addAllBeanFields = true) {
        $this->populateFromArray($_REQUEST, $switchVar, $addAllBeanFields);
    }
	
	function generateSearchWhere($add_custom_fields = false, $module='') {
        global $timedate;
        $values = $this->searchFields;
        $this->searchColumns = array () ;
        
        $where_clauses = array();
        $like_char = '%';
        $table_name = $this->seed->object_name;
        $this->seed->fill_in_additional_detail_fields();
        foreach($this->searchFields as $field=>$parms) {
			$customField = false;
            // Jenny - Bug 7462: We need a type check here to avoid database errors
            // when searching for numeric fields. This is a temporary fix until we have 
            // a generic search form validation mechanism.
            $type = (!empty($this->seed->field_name_map[$field]['type']))?$this->seed->field_name_map[$field]['type']:'';

        	if(!empty($this->seed->field_name_map[$field]['source']) && $this->seed->field_name_map[$field]['source'] == 'custom_fields'){
                $customField = true;	
              }
              
            if ($type == 'int') {
                if (!empty($parms['value'])) {
                    $tempVal = explode(',', $parms['value']);
                    $newVal = '';
                    foreach($tempVal as $key => $val) {
                        if (!empty($newVal))    
                            $newVal .= ',';
                        if(!empty($val) && !(is_numeric($val))) 
                            $newVal .= -1;
                        else 
                            $newVal .= $val;
                    }
                    $parms['value'] = $newVal;
                }
            }
            // do not include where clause for custom fields with checkboxes that are unchecked
            elseif($type == 'bool' && empty($parms['value']) && $customField) { 
                continue; 
            }
			
            if(isset($parms['value']) && $parms['value'] != "") {
               $operator = 'like';
                if(!empty($parms['operator'])) {
                    $operator = $parms['operator'];
                }

                if(is_array($parms['value'])) {
                    $field_value = '';
                    
                     if($GLOBALS['db']->dbType != 'mysql' && !empty($this->seed->field_name_map[$field]['isMultiSelect']) && $this->seed->field_name_map[$field]['isMultiSelect']) { 
                        // construct the query for multenums
                        // use the 'like' query for all mssql and oracle examples as both custom and OOB multienums are implemented with types that cannot be used with an 'in'
                        $operator = 'custom_enum';
                        $table_name = $this->seed->table_name ;
                        if ($customField)
                            $table_name .= "_cstm" ;
                        $db_field = $table_name . "." . $field;
                        
	                    foreach($parms['value'] as $key => $val) {

	                        if($val != ' ' and $val != '') {
	                               $qVal = $GLOBALS['db']->quote($val);
	                               if (!empty($field_value)) {
	                                   $field_value .= ' or ';
	                               }
	                               $field_value .= "$db_field like '$qVal' or $db_field like '%$qVal^%' or $db_field like '%^$qVal%' or $db_field like '%^$qVal^%'";
	                        }                            
	                    }
          
                    } else { 
                        $operator = 'in';
	                    foreach($parms['value'] as $key => $val) {
	                        if($val != ' ' and $val != '') {
	                            if (!empty($field_value)) {
	                                $field_value .= ',';
	                            }
	                            $field_value .= "'" . $GLOBALS['db']->quote($val) . "'";
	                        }
	                    }
                    }

                }
                else {
                    $field_value = $GLOBALS['db']->quote($parms['value']);
                }                
                //set db_fields array.
                if(!isset($parms['db_field'])) {
                    $parms['db_field'] = array($field);
                }
               
                if(isset($parms['my_items']) and $parms['my_items'] == true) {
                    global $current_user;
                    $field_value = $GLOBALS['db']->quote($current_user->id);
                    $operator = '=';
                }
                     
                $where = '';
                $itr = 0;
                if($field_value != '') {
                	$this->searchColumns [ strtoupper($field) ] = $field ;
                    foreach ($parms['db_field'] as $db_field) {
                    	if (strstr($db_field, '.') === false) {
                        	//Try to get the table for relate fields from link defs
                        	if ($type == 'relate' && !empty($this->seed->field_name_map[$field]['link'])
                        		&& !empty($this->seed->field_name_map[$field]['rname'])) {
                        			$link = $this->seed->field_name_map[$field]['link'];
                        			if (($this->seed->load_relationship($link))){
                        				$db_field = $this->seed->$link->getRelatedTableName() .  '.' . $this->seed->field_name_map[$field]['rname'];
                        			} else {
                        				//Best Guess for table name if we can't load the relationship
                        				$db_field = strtolower($link['module']) . '.' . $db_field;
                        			}
                        	}
                        	else if(!$customField){
                               if ( !empty($this->seed->field_name_map[$field]['db_concat_fields']) )
                                   $db_field = db_concat($this->seed->table_name, $this->seed->field_name_map[$db_field]['db_concat_fields']);
                               else
                            	   $db_field = $this->seed->table_name .  "." . $db_field;
                        	}else{
                        		if ( !empty($this->seed->field_name_map[$field]['db_concat_fields']) )
                                   $db_field = db_concat($this->seed->table_name .  "_cstm.", $this->seed->field_name_map[$db_field]['db_concat_fields']);
                               else
                            	   $db_field = $this->seed->table_name .  "_cstm." . $db_field;
                        	}
                           
                        }

                        if($type == 'date') {
                           // Collin - Have mysql as first because it's usually the case
                           // The regular expression check is to circumvent special case YYYY-MM
                           if($GLOBALS['db']->dbType == 'mysql') {
                                 if(preg_match('/^\d{4}.\d{1,2}$/', $field_value) == 0) {
                                    $field_value = $timedate->to_db_date($field_value, false);
                                    $operator = '=';  
                                 } else {
                                    $operator = 'db_date';	
                                 }                          	
                           } else if($GLOBALS['db']->dbType == 'oci8') {
                            	 if(preg_match('/^\d{4}.\d{1,2}$/', $field_value) == 0) {
                                    $field_value = $timedate->to_db_date($field_value, false);
                                    $field_value = "to_date('" . $field_value . "', 'YYYY-MM-DD hh24:mi:ss')";
                            	 }
                                 $operator = 'db_date';                           	
                           } else if($GLOBALS['db']->dbType == 'mssql') {
                                 if(preg_match('/^\d{4}.\d{1,2}$/', $field_value) == 0) {
                                    $field_value = "Convert(DateTime, '".$timedate->to_db_date($field_value, false)."')";
                                 }
                                 $operator = 'db_date';                            	
                           } else {
                           	     $field_value = $timedate->to_db_date($field_value, false);
                           	     $operator = '=';
                           }
                        } 
                        
                       
                        if($GLOBALS['db']->dbType == 'oci8' && isset($parms['query_type']) && $parms['query_type'] == 'case_insensitive') {
                              $db_field = 'upper(' . $db_field . ")";
                              $field_value = strtoupper($field_value);	 
                        } 
                        	
                        $itr++;
                        if(!empty($where)) {
                            $where .= " OR ";
                        }

                        switch(strtolower($operator)) {
                        	case 'subquery':
                        		$where .= "{$db_field} IN ({$parms['subquery']} '{$field_value}%')";
    	                    	break;
	                        	
                            case 'like':
                                $where .=  $db_field . " like '".$field_value.$like_char."'";
                                break;
                            case 'in':
                                $where .=  $db_field . " in (".$field_value.')';
                                break;
                            case '=':
                                $where .=  $db_field . " = '".$field_value ."'";
                                break;  
                            case 'db_date':
                                if(preg_match('/^\d{4}.\d{1,2}$/', $field_value) == 0) {
                                  $where .=  $db_field . " = ". $field_value;
                                } else {
                                  // Create correct date_format conversion String
                                  if($GLOBALS['db']->dbType == 'oci8') {
                                  	$where .= db_convert($db_field,'date_format',array("'YYYY-MM'")) . " = '" . $field_value . "'";	
                                  } else {
                                  	$where .= db_convert($db_field,'date_format',array("'%Y-%m'")) . " = '" . $field_value . "'";	
                                  }
                                }
                                break;
                            // tyoung bug 15971 - need to add these special cases into the $where query
                            case 'custom_enum':
                            	$where .= $field_value;
                            	break;
                        }
                    }
                }
                if(!empty($where)) {
                    if($itr > 1) {
                        array_push($where_clauses, '( '.$where.' )');
                    } 
                    else {
                        array_push($where_clauses, $where);
                    }                   
                }
            }
        }

        return $where_clauses;
    }
 }
 
?>
