<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
require_once('modules/InboundEmail/InboundEmail.php');
require_once('include/DetailView/DetailView.php');
require_once('modules/Emails/Email.php');
require_once('include/SugarFolders/SugarFolders.php');

global $mod_strings;
global $app_strings;
global $sugar_config;
global $timedate;
global $theme;

/* start standard DetailView layout process */
$GLOBALS['log']->info("InboundEmails DetailView");
$focus = new InboundEmail();
$focus->retrieve($_REQUEST['record']);
$focus->checkImap();
$detailView = new DetailView();
$offset=0;

echo "\n<p>\n";
echo get_module_title($mod_strings['LBL_MODULE_TITLE'], $mod_strings['LBL_MODULE_NAME'].": ".$focus->name, true);
echo "\n</p>\n";

$theme_path="themes/".$theme."/";
$image_path=$theme_path."images/";
/* end standard DetailView layout process */
$exServ = explode('::',$focus->service);
if($focus->delete_seen == 1) {
	$delete_seen = $mod_strings['LBL_MARK_READ_NO'];
} else {
	$delete_seen = $mod_strings['LBL_MARK_READ_YES'];
}

// deferred
//$r = $focus->db->query("SELECT id, name FROM queues WHERE owner_id = '".$focus->id."'");
//$a = $focus->db->fetchByAssoc($r);
//$queue = '<a href="index.php?module=Queues&action=EditView&record='.$a['id'].'">'.$a['name'].'</a>';
$groupName = '';
if($focus->group_id) {
	require_once('modules/Groups/Group.php');
	$group = new Group();
	$group->retrieve($focus->group_id);
	$groupName = $group->user_name;
}

if($focus->template_id) {
	require_once('modules/EmailTemplates/EmailTemplate.php');
	$et = new EmailTemplate();
	$et->retrieve($focus->template_id);
	$emailTemplate = $et->name;
} else {
	$emailTemplate = $mod_strings['LBL_NONE'];
}
if($focus->tls == 'tls') {
	$tls = $app_list_strings['dom_email_bool']['bool_true'];
} else {
	$tls = $app_list_strings['dom_email_bool']['bool_false'];
}
if($focus->ssl == 'ssl') {
	$ssl = $app_list_strings['dom_email_bool']['bool_true'];
} else {
	$ssl = $app_list_strings['dom_email_bool']['bool_false'];
}
if($focus->ca == 'validate-cert') {
	$ca = $app_list_strings['dom_email_bool']['bool_true'];
} else {
	$ca = $app_list_strings['dom_email_bool']['bool_false'];
}


// FROM NAME FROM ADDRESS STRINGS
$email = new Email();
$from = $email->getSystemDefaultEmail();
$fromName = $from['name'];
$fromNameAddr = $fromName.' &lt;'.$from['email'].'&gt; <br><em>('.$mod_strings['LBL_SYSTEM_DEFAULT'].')</em>';
$replyNameAddr = $mod_strings['LBL_SAME_AS_ABOVE'];
$onlySince = $mod_strings['LBL_ONLY_SINCE_NO'];

if(!empty($focus->stored_options)) {
	// FROM NAME and Address
	$storedOptions = unserialize(base64_decode($focus->stored_options));
	if(!empty($storedOptions['from_name']) && !empty($storedOptions['from_addr'])) {
		$fromName = $storedOptions['from_name'];
		$fromNameAddr = $storedOptions['from_name'].' &lt;'.$storedOptions['from_addr'].'&gt;';
	}
	
	// Reply-to Name/addr
	if(isset($storedOptions['reply_to_addr']) && !empty($storedOptions['reply_to_addr'])) {
		$fromName = (!empty($storedOptions['reply_to_name'])) ? $storedOptions['reply_to_name'] : $fromName;
		$replyNameAddr = $fromName.' &lt;'.$storedOptions['reply_to_addr'].'&gt;';
	}
	// only-since option
	if($storedOptions['only_since']) {
		$onlySince = $mod_strings['LBL_ONLY_SINCE_YES'];
	} else {
		$onlySince = $mod_strings['LBL_ONLY_SINCE_NO'];
	}
	// filter-domain
	if(isset($storedOptions['filter_domain']) && !empty($storedOptions['filter_domain'])) {
		$filterDomain = $storedOptions['filter_domain'];
	} else {
		$filterDomain = $app_strings['NTC_NO_ITEMS_DISPLAY'];
	}
}	

$xtpl = new XTemplate('modules/InboundEmail/DetailView.html');
////	ERRORS from Save
if(isset($_REQUEST['error'])) {
	$xtpl->assign('ERROR', "<div class='error'>".$mod_strings['ERR_NO_OPTS_SAVED']."</div>");	
}

//cma, June 24,2008 - Fix bug 21670. User status and group/personal statements are not localized.
$userStatus = $mod_strings['LBL_STATUS_ACTIVE'];
if('Inactive' == $focus->status) {
    $userStatus = $mod_strings['LBL_STATUS_INACTIVE'];
}

$xtpl->assign('MOD', $mod_strings);
$xtpl->assign('APP', $app_strings);
$xtpl->assign('CREATED_BY', $focus->created_by_name);
$xtpl->assign('MODIFIED_BY', $focus->modified_by_name);
$xtpl->assign('THEME', $theme);
$xtpl->assign('GRIDLINE', $gridline);
$xtpl->assign('IMAGE_PATH', $image_path);$xtpl->assign('PRINT_URL', 'index.php?'.$GLOBALS['request_string']);
$xtpl->assign('ID', $focus->id);
$xtpl->assign('STATUS', $userStatus);
$xtpl->assign('SERVER_URL', $focus->server_url);
$xtpl->assign('USER', $focus->email_user);
$xtpl->assign('NAME', $focus->name);
$xtpl->assign('MAILBOX', $focus->mailbox);
$xtpl->assign('SERVER_TYPE', $app_list_strings['dom_email_server_type'][$focus->protocol]);
$xtpl->assign('SSL', $ssl);
$xtpl->assign('TLS', $tls);
$xtpl->assign('CERT', $ca);
$xtpl->assign('MARK_READ', $delete_seen);
// deferred
//$xtpl->assign('QUEUE', $queue);
if ($focus->is_personal) {
	$xtpl->assign('EDIT_GROUP_FOLDER_STYLE', "display:none");
} else {
	$groupFolderName = $app_strings['LBL_LINK_NONE'];
	$folder = new SugarFolder();
	if (!empty($focus->groupfolder_id)) {
		$folder->retrieve($focus->groupfolder_id);
		$groupFolderName = $folder->name;
	} // if
	$xtpl->assign('ASSIGN_TO_FOLDER', $groupFolderName);
	$xtpl->assign('EDIT_GROUP_FOLDER_STYLE', "display:''");
}
$xtpl->assign('GROUP_NAME', $groupName);
$xtpl->assign('MAILBOX_TYPE', $app_list_strings['dom_mailbox_type'][$focus->mailbox_type]);
$xtpl->assign('EMAIL_TEMPLATE', $emailTemplate);
$xtpl->assign('FROM_NAME_ADDR', $fromNameAddr);
$xtpl->assign('REPLY_NAME_ADDR', $replyNameAddr);
$xtpl->assign('ONLY_SINCE', $onlySince);
$xtpl->assign('FILTER_DOMAIN', $filterDomain);













if($focus->handleIsPersonal()) {
	$xtpl->assign('LBL_GROUP_QUEUE', $mod_strings['LBL_ASSIGN_TO_USER']);
} else {
	$xtpl->assign('LBL_GROUP_QUEUE', $mod_strings['LBL_GROUP_QUEUE']);
}
$xtpl->parse('main');
$xtpl->out('main');
?>
