<?php
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2007 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
//require_once('include/SubPanel/SubPanel.php');
class StudioModule
{
	var $name ;
	var $subpanels = array ( ) ;
	var $views = array ( ) ;
	var $popups = array ( ) ;
	var $providedSubpanels = array ( ) ;
	var $search = array ( ) ;



	

	function StudioModule ( $module )
	{
		global $app_list_strings ;
		$moduleNames = array_change_key_case ( $app_list_strings [ 'moduleList' ] ) ;
		
		$this->name = isset($moduleNames [ strtolower ( $module ) ]) ? $moduleNames [ strtolower ( $module ) ] : strtolower ( $module ) ;
		$this->module = $module ;
		$this->getViews () ;
		$this->getSubpanels () ;
		$this->getPopups () ;
		$this->getSearch () ;



	}
	
	/**
	 * Gets a list of views available
	 * ListView/EditView/DetailView
	 *
	 */
	function getViews ()
	{
		$views = array ( 'editviewdefs.php' => array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_EDITVIEW' ] , 'type' => 'editView' ) , 'detailviewdefs.php' => array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_DETAILVIEW' ] , 'type' => 'detailView' ) , 'listviewdefs.php' => array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_LISTVIEW' ] , 'type' => 'list' ) ) ;
		$path = 'modules/' . $this->module . '/metadata' ;
		foreach ( $views as $file => $name )
		{
			if (file_exists ( $path . '/' . $file ))
			{
				$this->views [ $file ] = $name ;
			}
		}
		$this->views [ 'quickcreatedefs.php' ] = array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_QUICKCREATE' ] , 'type' => 'quickCreate' ) ;
	}
	function getSearch ()
	{
		$path = 'modules/' . $this->module . '/metadata' ;
		if (file_exists ( $path . '/searchdefs.php' ))
		{
			$this->search [ $GLOBALS [ 'mod_strings' ] [ 'LBL_BASIC_SEARCH' ] ] = 'basic_search' ;
			$this->search [ $GLOBALS [ 'mod_strings' ] [ 'LBL_ADVANCED_SEARCH' ] ] = 'advanced_search' ;
		}
	}
	














	

	/**
	 * Gets a list of popups available
	 *
	 */
	function getPopups ()
	{
		$path = 'modules/' . $this->module . '/metadata' ;
	
	}
	/**
	 * Gets a list of subpanels used by the current module
	 */
	function getSubpanels ()
	{
		global $modListHeader, $beanList, $beanFiles ;
		if (! isset ( $modListHeader ))
		{
			$modListHeader = array ( ) ;
		}
		$this->subpanels = array(); // initialize as some modules do not have subpanels
		require_once ('include/SubPanel/SubPanel.php') ;
		if (file_exists ( "modules/$this->module/metadata/subpaneldefs.php" ))
		{
			$GLOBALS [ 'log' ]->debug ( "StudioModule->getSubpanels(): getting subpanels for " . $this->module ) ;

			$layout_def = SubPanel::getModuleSubpanels ( $this->module ) ;

			foreach ( $layout_def as $sub => $label )
			{
				if ($sub == 'users')
					continue ;

				$name = (! empty ($label)) ? translate ( $label, $this->module ) : $sub ;
				$this->subpanels [ $sub ] = ucfirst ( $name ) ;
			}

		}

	
	}
	/**
	 * gets a list of subpanels provided to other modules
	 *
	 */
	function getProvidedSubpanels ()
	{
		if (file_exists ( 'modules/' . $this->module . '/metadata/subpanels' ))
		{
			$d = dir ( 'modules/' . $this->module . '/metadata/subpanels' ) ;
			while ( $e = $d->read () )
			{
				if (substr ( $e, 0, 1 ) != '.')
				{
					$this->providedSubpanels [ $e ] = $e ;
				}
			}
		}
	}
	
	function getNodes ()
	{
		$nodes = array ( 'name' => $this->name , 'module' => $this->module , 'type' => 'StudioModule' , 'action' => 'module=ModuleBuilder&action=wizard&editModule=' . $this->module , 'children' => array ( array ( 'name' => 'labels' , 'label' => $GLOBALS [ 'mod_strings' ] [ 'LBL_LABELS' ] , 'action' => 'module=ModuleBuilder&action=editLabels&editModule=' . $this->module ) , array ( 'name' => 'fields' , 'label' => $GLOBALS [ 'mod_strings' ] [ 'LBL_FIELDS' ] , 'action' => 'module=ModuleBuilder&action=modulefields&view_package=studio&view_module=' . $this->module ) ) ) ;
		$layouts = array ( ) ;
		foreach ( $this->views as $file => $def )
		{
			$file = str_replace ( $file, '.php', '' ) ;
			$viewType = ($def [ 'type' ] == 'list') ? "ListView" : ucfirst ( $def [ 'type' ] ) ;
			$layouts [] = array ( 'name' => $def [ 'name' ] , 'action' => 'module=ModuleBuilder&action=editLayout&view=' . $viewType . '&editModule=' . $this->module ) ;
		}
		
		$search = array ( ) ;
		foreach ( $this->search as $searchName => $searchType )
		{
			$search [] = array ( 'name' => $searchName , 'action' => 'module=ModuleBuilder&action=editLayout&view=SearchView&editModule=' . $this->module . '&searchlayout=' . $searchType ) ;
		}
		if (! empty ( $search ))
		{
			$layouts [] = array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_SEARCH' ] , 'type' => 'Folder' , 'children' => $search , 'action' => 'module=ModuleBuilder&action=wizard&search=1&editModule=' . $this->module ) ;
		}
		
		if (! empty ( $layouts ))
		{
			$nodes [ 'children' ] [] = array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_LAYOUTS' ] , 'type' => 'Folder' , 'children' => $layouts , 'action' => 'module=ModuleBuilder&action=wizard&layouts=1&editModule=' . $this->module ) ;
		}
		
		$subpanels = array ( ) ;
		foreach ( $this->subpanels as $sub => $subname )
		{
			$subpanels [] = array ( 'label' => $subname, 'name' => $sub , 'action' => 'module=ModuleBuilder&action=editLayout&view=ListView&editModule=' . $this->module . '&subpanel=' . $sub . '&subpanelLabel=' . $subname ) ;
		}
		if (! empty ( $subpanels ))
		{
			$nodes [ 'children' ] [] = array ( 'name' => $GLOBALS [ 'mod_strings' ] [ 'LBL_SUBPANELS' ] , 'type' => 'Folder' , 'children' => $subpanels , 'action' => 'module=ModuleBuilder&action=wizard&subpanels=1&editModule=' . $this->module ) ;
		}
		













		

		return $nodes ;
	}

}
?>
