<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004 - 2009 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/
/*********************************************************************************

 * Description: Bean class for the users_last_import table
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 ********************************************************************************/

require_once('data/SugarBean.php');
require_once('modules/Import/Forms.php');

class UsersLastImport extends SugarBean
{
	/**
     * Fields in the table
     */
	public $id;
	public $assigned_user_id;
	public $import_module;
	public $bean_type;
	public $bean_id;
	public $deleted;
    
    /**
     * Set the default settings from Sugarbean
     */
    public $module_dir = 'Import';
    public $table_name = "users_last_import";
    public $object_name = "UsersLastImport";
    public $column_fields = array(
        "id",
        "assigned_user_id",
        "bean_type",
        "bean_id",
        "deleted"
		);
    public $new_schema = true;
    public $additional_column_fields = Array();

    /**
     * Constructor
     */
    public function __construct() 
    {
        parent::SugarBean();



	}

	/**
     * Extends SugarBean::listviewACLHelper
     *
     * @return array
     */
    public function listviewACLHelper()
    {
		$array_assign = parent::listviewACLHelper();
		$is_owner = false;
		if ( !ACLController::moduleSupportsACL('Accounts') 
                || ACLController::checkAccess('Accounts', 'view', $is_owner) ) {
			$array_assign['ACCOUNT'] = 'a';
		}
        else {
			$array_assign['ACCOUNT'] = 'span';
		}
		return $array_assign;
	}

	/**
     * Delete all the records for a particular user
     *
     * @param string $user_id user id of the user doing the import
     */
    public function mark_deleted_by_user_id(
        $user_id
        )
    {
        $query = "DELETE FROM $this->table_name 
                    WHERE assigned_user_id = '$user_id'";
        $this->db->query($query,true,"Error marking last imported records deleted: ");
    }

    /**
     * Undo an import
     *
     * @param string $user_id user id of the user doing the import
     * @param string $module  module being imported into
     */
    public function undo(
        $user_id, 
        $module
        )
	{
        $query1 = "SELECT bean_id, bean_type 
                        FROM users_last_import
                        WHERE assigned_user_id = '$user_id'
                            AND import_module = '$module'
                            AND deleted=0";

		$result1 = $this->db->query($query1);
        if ( !$result1 )
            return false;

        $focus = null;
        while ( $row1 = $this->db->fetchByAssoc($result1)) {
            // load bean
            if ( !( $focus instanceof $row1['bean_type']) ) {
                require_once($GLOBALS['beanFiles'][$row1['bean_type']]);
                $focus = new $row1['bean_type'];
            }
            
            $result = $this->db->query(
                "DELETE FROM {$focus->table_name} 
                    WHERE id = '{$row1['bean_id']}'"
                );
            if (!$result)
                return false;
            // Bug 26318: Remove all created e-mail addresses ( from jchi )
            $result2 = $this->db->query(
                "SELECT email_address_id
                    FROM email_addr_bean_rel
                    WHERE email_addr_bean_rel.bean_id='{$row1['bean_id']}'
                        AND email_addr_bean_rel.bean_module='{$focus->module_dir}'");
            $this->db->query(
                "DELETE FROM email_addr_bean_rel
                    WHERE email_addr_bean_rel.bean_id='{$row1['bean_id']}'
                        AND email_addr_bean_rel.bean_module='{$focus->module_dir}'"
                );
            
            while ( $row2 = $this->db->fetchByAssoc($result2)) {
                if ( !$this->db->getOne(
                        "SELECT email_address_id 
                            FROM email_addr_bean_rel 
                            WHERE email_address_id = '{$row2['email_address_id']}'") )
                    $this->db->query(
                        "DELETE FROM email_addresses 
                            WHERE id = '{$row2['email_address_id']}'");
            }
            
            if ($focus->hasCustomFields())
                $this->db->query(
                    "DELETE FROM {$focus->table_name}_cstm 
                        WHERE id_c = '{$row1['bean_id']}'");
        }
    
        return true;
	}
    
    /**
     * Get a list of bean types created in the import
     *
     * @param string $user_id user id of the user doing the import
     * @param string $module  module being imported into
     */
    public static function getBeansByImport(
        $user_id, 
        $module
        )
	{
        $query1 = "SELECT DISTINCT bean_type 
                        FROM users_last_import
                        WHERE assigned_user_id = '$user_id'
                            AND import_module = '$module'
                            AND deleted=0";

		$result1 = $GLOBALS['db']->query($query1);
        if ( !$result1 )
            return array($module);

        $returnarray = array();
        while ( $row1 = $GLOBALS['db']->fetchByAssoc($result1))
            $returnarray[] = $row1['bean_type'];
        
        return $returnarray;
    }

}
?>
