/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.tester.ActionFailedException;
import abbot.tester.ComponentTester;
import abbot.util.ExtendedComparator;
import abbot.util.Properties;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.ItemEvent;

public class ChoiceTester
extends ComponentTester {
    private int CHOICE_DELAY = Properties.getProperty("abbot.tester.choice_delay", 30000, 0, 60000);

    public void actionSelectIndex(Component c, int index) {
        Choice choice = (Choice)c;
        int current = choice.getSelectedIndex();
        if (current == index) {
            return;
        }
        Listener listener = new Listener(index);
        new WeakAWTEventListener(listener, 512L);
        choice.select(index);
        ItemEvent ie = new ItemEvent(choice, 701, choice.getSelectedObjects()[0], 1);
        this.postEvent(choice, ie);
        long now = System.currentTimeMillis();
        while (!listener.gotChange) {
            if (System.currentTimeMillis() - now > (long)this.CHOICE_DELAY) {
                throw new ActionFailedException("Choice didn't fire for index " + index);
            }
            this.sleep();
        }
        this.waitForIdle();
    }

    public void actionSelectItem(Component c, String item) {
        Choice choice = (Choice)c;
        for (int i = 0; i < choice.getItemCount(); ++i) {
            if (!ExtendedComparator.stringsMatch(choice.getItem(i), item)) continue;
            try {
                this.actionSelectIndex(c, i);
                return;
            }
            catch (ActionFailedException e) {
                throw new ActionFailedException("Choice didn't fire for item '" + item + "'");
            }
        }
        throw new ActionFailedException("Item '" + item + "' not found in Choice");
    }

    private class Listener
    implements AWTEventListener {
        public volatile boolean gotChange;
        private int targetIndex = -1;

        public Listener(int index) {
            this.targetIndex = index;
        }

        public void eventDispatched(AWTEvent e) {
            if (e.getID() == 701 && e.getSource() instanceof Choice) {
                this.gotChange = ((Choice)e.getSource()).getSelectedIndex() == this.targetIndex;
            }
        }
    }
}

