/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.LocationUnavailableException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class ComponentLocation {
    public static final String CENTER = "(center)";
    private Point where = null;

    public ComponentLocation() {
    }

    public ComponentLocation(Point where) {
        this.where = new Point(where);
    }

    public Point getPoint(Component c) throws LocationUnavailableException {
        return this.where != null ? new Point(this.where) : new Point(c.getWidth() / 2, c.getHeight() / 2);
    }

    public Rectangle getBounds(Component c) throws LocationUnavailableException {
        if (this.where == null) {
            return new Rectangle(0, 0, c.getWidth(), c.getHeight());
        }
        return new Rectangle(this.where.x, this.where.y, 1, 1);
    }

    public boolean equals(Object o) {
        if (o instanceof ComponentLocation) {
            ComponentLocation loc = (ComponentLocation)o;
            return this.where == null && loc.where == null || this.where != null && this.where.equals(loc.where);
        }
        return false;
    }

    public String toString() {
        if (this.where != null) {
            return "(" + this.where.x + "," + this.where.y + ")";
        }
        return CENTER;
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.component.bad_format", new Object[]{encoded});
    }

    protected String encodeIndex(int index) {
        return "[" + index + "]";
    }

    protected boolean isIndex(String encoded) {
        return encoded.startsWith("[") && encoded.endsWith("]");
    }

    protected int parseIndex(String encoded) {
        try {
            return Integer.parseInt(encoded.substring(1, encoded.length() - 1).trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.badFormat(encoded));
        }
    }

    protected String encodeValue(String value) {
        return "\"" + value + "\"";
    }

    protected boolean isValue(String encoded) {
        return encoded.startsWith("\"") && encoded.endsWith("\"");
    }

    protected String parseValue(String encoded) {
        return encoded.substring(1, encoded.length() - 1);
    }

    public ComponentLocation parse(String encoded) {
        StringTokenizer st;
        if ((encoded = encoded.trim()).equals(CENTER)) {
            this.where = null;
            return this;
        }
        if (encoded.startsWith("(") && encoded.endsWith(")") && (st = new StringTokenizer(encoded.substring(1, encoded.length() - 1), ",")).countTokens() == 2) {
            try {
                int x = Integer.parseInt(st.nextToken().trim());
                int y = Integer.parseInt(st.nextToken().trim());
                this.where = new Point(x, y);
                return this;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(this.badFormat(encoded));
    }
}

