/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.IntBitfield;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.ScreenModeListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;
import jogamp.nativewindow.SurfaceUpdatedHelper;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.OffscreenWindow;
import jogamp.newt.ScreenImpl;

public abstract class WindowImpl
implements Window,
NEWTEventConsumer {
    public static final boolean DEBUG_TEST_REPARENT_INCOMPATIBLE = Debug.isPropertyDefined("newt.test.Window.reparent.incompatible", true);
    static final long QUEUED_EVENT_TO = 1200L;
    private volatile long windowHandle = 0L;
    private volatile boolean visible = false;
    private RecursiveLock windowLock = LockFactory.createRecursiveLock();
    private int surfaceLockCount = 0;
    private ScreenImpl screen;
    private boolean screenReferenceAdded = false;
    private NativeWindow parentWindow = null;
    private long parentWindowHandle = 0L;
    private AbstractGraphicsConfiguration config = null;
    protected CapabilitiesImmutable capsRequested = null;
    protected CapabilitiesChooser capabilitiesChooser = null;
    private boolean fullscreen = false;
    private boolean hasFocus = false;
    private boolean brokenFocusChange = false;
    private int width = 128;
    private int height = 128;
    private int x = 64;
    private int y = 64;
    private boolean autoPosition = true;
    private Insets insets = new Insets();
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private NativeWindow nfs_parent = null;
    private String title = "Newt Window";
    private boolean undecorated = false;
    private boolean alwaysOnTop = false;
    private boolean pointerVisible = true;
    private boolean pointerConfined = false;
    private LifecycleHook lifecycleHook = null;
    private boolean handleDestroyNotify = true;
    private Window.FocusRunnable focusAction = null;
    private KeyListener keyboardFocusHandler = null;
    private SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private Object childWindowsLock = new Object();
    private ArrayList<NativeWindow> childWindows = new ArrayList();
    private ArrayList<MouseListener> mouseListeners = new ArrayList();
    private int mouseButtonPressed = 0;
    private long lastMousePressed = 0L;
    private int lastMouseClickCount = 0;
    private boolean mouseInWindow = false;
    private Point lastMousePosition = new Point();
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private ArrayList<WindowListener> windowListeners = new ArrayList();
    private boolean repaintQueued = false;
    private Object closingListenerLock = new Object();
    private WindowClosingProtocol.WindowClosingMode defaultCloseOperation = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    public static final int FLAG_CHANGE_PARENTING = 1;
    public static final int FLAG_CHANGE_DECORATION = 2;
    public static final int FLAG_CHANGE_FULLSCREEN = 4;
    public static final int FLAG_CHANGE_ALWAYSONTOP = 8;
    public static final int FLAG_CHANGE_VISIBILITY = 16;
    public static final int FLAG_HAS_PARENT = 256;
    public static final int FLAG_IS_UNDECORATED = 512;
    public static final int FLAG_IS_FULLSCREEN = 1024;
    public static final int FLAG_IS_ALWAYSONTOP = 2048;
    public static final int FLAG_IS_VISIBLE = 4096;
    private final DestroyAction destroyAction = new DestroyAction();
    private final ReparentActionRecreate reparentActionRecreate = new ReparentActionRecreate();
    private final Runnable requestFocusAction = new Runnable(){

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: force 0 - (" + WindowImpl.getThreadName() + "): " + WindowImpl.this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(false);
        }
    };
    private final Runnable requestFocusActionForced = new Runnable(){

        @Override
        public final void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: force 1 - (" + WindowImpl.getThreadName() + "): " + WindowImpl.this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(true);
        }
    };
    private final FullScreenAction fullScreenAction = new FullScreenAction();
    private final ScreenModeListenerImpl screenModeListenerImpl = new ScreenModeListenerImpl();
    protected IntBitfield keyPressedState = new IntBitfield(526L);
    protected IntBitfield keyRepeatState = new IntBitfield(526L);
    protected boolean keyboardVisible = false;

    public static void init(String string) {
        if (NativeWindowFactory.TYPE_MACOSX.equals(string)) {
            try {
                WindowImpl.getWindowClass(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Class<?> getWindowClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "WindowDriver");
        if (null == clazz) {
            throw new ClassNotFoundException("Failed to find NEWT Window Class <" + string + ".WindowDriver>");
        }
        return clazz;
    }

    public static WindowImpl create(NativeWindow nativeWindow, long l, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class clazz = capabilitiesImmutable.isOnscreen() ? WindowImpl.getWindowClass(screen.getDisplay().getType()) : OffscreenWindow.class;
            WindowImpl windowImpl = (WindowImpl)clazz.newInstance();
            windowImpl.parentWindow = nativeWindow;
            windowImpl.parentWindowHandle = l;
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.setUndecorated(0L != l);
            windowImpl.instantiationFinished();
            return windowImpl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    public static WindowImpl create(Object[] objectArray, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class<?> clazz = WindowImpl.getWindowClass(screen.getDisplay().getType());
            Class[] classArray = WindowImpl.getCustomConstructorArgumentTypes(clazz);
            if (null == classArray) {
                throw new NativeWindowException("WindowClass " + clazz + " doesn't support custom arguments in constructor");
            }
            int n = WindowImpl.verifyConstructorArgumentTypes(classArray, objectArray);
            if (n < objectArray.length) {
                throw new NativeWindowException("WindowClass " + clazz + " constructor mismatch at argument #" + n + "; Constructor: " + WindowImpl.getTypeStrList(classArray) + ", arguments: " + WindowImpl.getArgsStrList(objectArray));
            }
            WindowImpl windowImpl = (WindowImpl)ReflectionUtil.createInstance(clazz, (Class[])classArray, (Object[])objectArray);
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            return windowImpl;
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    protected final void setGraphicsConfiguration(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.config = abstractGraphicsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNative() {
        boolean bl;
        long l;
        block15: {
            if (DEBUG_IMPLEMENTATION) {
                l = System.nanoTime();
                System.err.println("Window.createNative() START (" + WindowImpl.getThreadName() + ", " + this + ")");
            } else {
                l = 0L;
            }
            if (null != this.parentWindow && 1 >= this.parentWindow.lockSurface()) {
                throw new NativeWindowException("Parent surface lock: not ready: " + this.parentWindow);
            }
            if (null != this.parentWindow && (this.autoPosition || 0 > this.getX() || 0 > this.getY())) {
                this.definePosition(0, 0);
            }
            bl = false;
            try {
                if (!this.validateParentWindowHandle()) break block15;
                if (this.screenReferenceAdded) {
                    throw new InternalError("XXX");
                }
                if (!this.canCreateNativeImpl()) break block15;
                this.screen.addReference();
                this.screenReferenceAdded = true;
                this.createNativeImpl();
                this.screen.addScreenModeListener(this.screenModeListenerImpl);
                this.setTitleImpl(this.title);
                this.setPointerVisibleImpl(this.pointerVisible);
                this.confinePointerImpl(this.pointerConfined);
                this.setKeyboardVisible(this.keyboardVisible);
                if (!this.waitForVisible(true, false)) break block15;
                if (this.isFullscreen()) {
                    FullScreenAction fullScreenAction = this.fullScreenAction;
                    synchronized (fullScreenAction) {
                        this.fullscreen = false;
                        this.fullScreenAction.init(true);
                        this.fullScreenAction.run();
                    }
                }
                bl = true;
            }
            finally {
                if (null != this.parentWindow) {
                    this.parentWindow.unlockSurface();
                }
            }
        }
        if (bl) {
            this.requestFocusInt(this.isFullscreen());
            ((DisplayImpl)this.screen.getDisplay()).dispatchMessagesNative();
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.createNative() END (" + WindowImpl.getThreadName() + ", " + this + ") total " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
        }
        return this.isNativeValid();
    }

    private void removeScreenReference() {
        if (this.screenReferenceAdded) {
            this.screenReferenceAdded = false;
            this.screen.removeReference();
        }
    }

    private boolean validateParentWindowHandle() {
        if (null != this.parentWindow) {
            this.parentWindowHandle = WindowImpl.getNativeWindowHandle(this.parentWindow);
            return 0L != this.parentWindowHandle;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNativeWindowHandle(NativeWindow nativeWindow) {
        long l = 0L;
        if (null != nativeWindow) {
            boolean bl = false;
            if (1 < nativeWindow.lockSurface()) {
                bl = true;
                try {
                    l = nativeWindow.getWindowHandle();
                    if (0L == l) {
                        throw new NativeWindowException("Parent native window handle is NULL, after succesful locking: " + nativeWindow);
                    }
                }
                catch (NativeWindowException nativeWindowException) {
                    if (DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.getNativeWindowHandle: not successful yet: " + nativeWindowException);
                    }
                }
                finally {
                    nativeWindow.unlockSurface();
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.getNativeWindowHandle: locked " + bl + ", " + nativeWindow);
            }
        }
        return l;
    }

    protected int lockSurfaceImpl() {
        return 3;
    }

    protected void unlockSurfaceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        Object object = this.closingListenerLock;
        synchronized (object) {
            return this.defaultCloseOperation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        Object object = this.closingListenerLock;
        synchronized (object) {
            WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.defaultCloseOperation;
            this.defaultCloseOperation = windowClosingMode;
            return windowClosingMode2;
        }
    }

    protected void instantiationFinished() {
    }

    protected boolean canCreateNativeImpl() {
        return true;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    protected abstract void requestFocusImpl(boolean var1);

    protected abstract boolean reconfigureWindowImpl(int var1, int var2, int var3, int var4, int var5);

    protected int getReconfigureFlags(int n, boolean bl) {
        return n |= (0L != this.getParentWindowHandle() ? 256 : 0) | (this.isUndecorated() ? 512 : 0) | (this.isFullscreen() ? 1024 : 0) | (this.isAlwaysOnTop() ? 2048 : 0) | (bl ? 4096 : 0);
    }

    protected static String getReconfigureFlagsAsString(StringBuilder stringBuilder, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        if (0 != (1 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("PARENT_");
        stringBuilder.append(0 != (0x100 & n));
        stringBuilder.append(", ");
        if (0 != (4 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("FS_");
        stringBuilder.append(0 != (0x400 & n));
        stringBuilder.append(", ");
        if (0 != (2 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("UNDECOR_");
        stringBuilder.append(0 != (0x200 & n));
        stringBuilder.append(", ");
        if (0 != (8 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("ALWAYSONTOP_");
        stringBuilder.append(0 != (0x800 & n));
        stringBuilder.append(", ");
        if (0 != (0x10 & n)) {
            stringBuilder.append("*");
        }
        stringBuilder.append("VISIBLE_");
        stringBuilder.append(0 != (0x1000 & n));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected void setTitleImpl(String string) {
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    protected abstract void updateInsetsImpl(Insets var1);

    protected boolean setPointerVisibleImpl(boolean bl) {
        return false;
    }

    protected boolean confinePointerImpl(boolean bl) {
        return false;
    }

    protected void warpPointerImpl(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        block9: {
            RecursiveLock recursiveLock = this.windowLock;
            recursiveLock.lock();
            ++this.surfaceLockCount;
            int n2 = n = 1 == this.surfaceLockCount ? 1 : 3;
            if (1 == n) {
                try {
                    if (!this.isNativeValid()) break block9;
                    AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                    abstractGraphicsDevice.lock();
                    try {
                        n = this.lockSurfaceImpl();
                    }
                    finally {
                        if (1 >= n) {
                            abstractGraphicsDevice.unlock();
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        recursiveLock.unlock();
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        RecursiveLock recursiveLock = this.windowLock;
        recursiveLock.validateLocked();
        if (1 == this.surfaceLockCount) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        --this.surfaceLockCount;
        recursiveLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.windowLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.windowLock.getOwner();
    }

    public final RecursiveLock getLock() {
        return this.windowLock;
    }

    @Override
    public long getSurfaceHandle() {
        return this.windowHandle;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config.getNativeGraphicsConfiguration();
    }

    @Override
    public long getDisplayHandle() {
        return this.screen.getDisplay().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.screen.getIndex();
    }

    @Override
    public final NativeWindow getParent() {
        return this.parentWindow;
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen(Point point) {
        if (this.isNativeValid()) {
            Point point2;
            RecursiveLock recursiveLock = this.windowLock;
            recursiveLock.lock();
            try {
                point2 = this.getLocationOnScreenImpl(0, 0);
            }
            finally {
                recursiveLock.unlock();
            }
            if (null != point2) {
                if (null != point) {
                    point.translate(point2.getX(), point2.getY());
                    return point;
                }
                return point2;
            }
        }
        if (null != point) {
            point.translate(this.getX(), this.getY());
        } else {
            point = new Point(this.getX(), this.getY());
        }
        if (null != this.parentWindow) {
            this.parentWindow.getLocationOnScreen(point);
        }
        return point;
    }

    @Override
    public final boolean isNativeValid() {
        return 0L != this.windowHandle;
    }

    @Override
    public final Screen getScreen() {
        return this.screen;
    }

    protected final void setVisibleImpl(boolean bl, int n, int n2, int n3, int n4) {
        this.reconfigureWindowImpl(n, n2, n3, n4, this.getReconfigureFlags(16, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setVisibleActionImpl(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        RecursiveLock recursiveLock = this.windowLock;
        recursiveLock.lock();
        try {
            NativeWindow nativeWindow;
            int n;
            Object object;
            if (null != this.lifecycleHook) {
                this.lifecycleHook.resetCounter();
            }
            if (!bl && null != this.childWindows && this.childWindows.size() > 0) {
                object = this.childWindowsLock;
                synchronized (object) {
                    for (n = 0; n < this.childWindows.size(); ++n) {
                        nativeWindow = this.childWindows.get(n);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(false);
                    }
                }
            }
            if (!this.isNativeValid() && bl) {
                if (0 < this.getWidth() * this.getHeight()) {
                    bl3 = bl2 = this.createNative();
                }
                this.visible = true;
            } else if (this.visible != bl && this.isNativeValid()) {
                this.setVisibleImpl(bl, this.getX(), this.getY(), this.getWidth(), this.getHeight());
                this.waitForVisible(bl, true);
                bl3 = bl;
            }
            if (null != this.lifecycleHook) {
                this.lifecycleHook.setVisibleActionPost(bl, bl2);
            }
            if (this.isNativeValid() && bl && null != this.childWindows && this.childWindows.size() > 0) {
                object = this.childWindowsLock;
                synchronized (object) {
                    for (n = 0; n < this.childWindows.size(); ++n) {
                        nativeWindow = this.childWindows.get(n);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).setVisible(true);
                    }
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window setVisible: END (" + WindowImpl.getThreadName() + ") " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + ", nativeWindowCreated: " + bl2 + ", madeVisible: " + bl3);
            }
        }
        finally {
            recursiveLock.unlock();
        }
        if (bl2 || bl3) {
            this.sendWindowEvent(100);
        }
    }

    protected void setVisible(boolean bl, boolean bl2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window setVisible: START (" + WindowImpl.getThreadName() + ") " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + " -> " + bl2 + ", parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + ", parentWindow " + (null != this.parentWindow));
        }
        this.runOnEDTIfAvail(bl, new VisibleAction(bl2));
    }

    @Override
    public void setVisible(boolean bl) {
        this.setVisible(true, bl);
    }

    @Override
    public void setSize(int n, int n2) {
        this.runOnEDTIfAvail(true, new SetSizeAction(n, n2));
    }

    @Override
    public void setTopLevelSize(int n, int n2) {
        this.setSize(n - this.getInsets().getTotalWidth(), n2 - this.getInsets().getTotalHeight());
    }

    @Override
    public void destroy() {
        this.visible = false;
        this.runOnEDTIfAvail(true, this.destroyAction);
    }

    protected static boolean isOffscreenInstance(NativeWindow nativeWindow, NativeWindow nativeWindow2) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        boolean bl = false;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = nativeWindow.getGraphicsConfiguration();
        if (null != abstractGraphicsConfiguration2) {
            boolean bl2 = bl = !abstractGraphicsConfiguration2.getChosenCapabilities().isOnscreen();
        }
        if (!bl && null != nativeWindow2 && null != (abstractGraphicsConfiguration = nativeWindow2.getGraphicsConfiguration())) {
            bl = !abstractGraphicsConfiguration.getChosenCapabilities().isOnscreen();
        }
        return bl;
    }

    @Override
    public final Window.ReparentOperation reparentWindow(NativeWindow nativeWindow) {
        return this.reparentWindow(nativeWindow, false);
    }

    @Override
    public Window.ReparentOperation reparentWindow(NativeWindow nativeWindow, boolean bl) {
        ReparentAction reparentAction = new ReparentAction(nativeWindow, bl);
        this.runOnEDTIfAvail(true, reparentAction);
        return reparentAction.getOp();
    }

    @Override
    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        CapabilitiesChooser capabilitiesChooser2 = this.capabilitiesChooser;
        this.capabilitiesChooser = capabilitiesChooser;
        return capabilitiesChooser2;
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        return this.getGraphicsConfiguration().getChosenCapabilities();
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.capsRequested;
    }

    @Override
    public void setUndecorated(boolean bl) {
        this.runOnEDTIfAvail(true, new DecorationAction(bl));
    }

    @Override
    public final boolean isUndecorated() {
        return 0L != this.parentWindowHandle || this.undecorated || this.fullscreen;
    }

    @Override
    public final void setAlwaysOnTop(boolean bl) {
        this.runOnEDTIfAvail(true, new AlwaysOnTopAction(bl));
    }

    @Override
    public final boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
        if (0L != this.getWindowHandle()) {
            this.setTitleImpl(string);
        }
    }

    @Override
    public boolean isPointerVisible() {
        return this.pointerVisible;
    }

    @Override
    public void setPointerVisible(boolean bl) {
        if (this.pointerVisible != bl) {
            boolean bl2;
            boolean bl3 = bl2 = 0L == this.getWindowHandle();
            if (!bl2) {
                bl2 = this.setPointerVisibleImpl(bl);
            }
            if (bl2) {
                this.pointerVisible = bl;
            }
        }
    }

    @Override
    public boolean isPointerConfined() {
        return this.pointerConfined;
    }

    @Override
    public void confinePointer(boolean bl) {
        if (this.pointerConfined != bl) {
            boolean bl2;
            boolean bl3 = bl2 = 0L == this.getWindowHandle();
            if (!bl2) {
                if (bl) {
                    this.requestFocus();
                    this.warpPointer(this.getWidth() / 2, this.getHeight() / 2);
                }
                bl2 = this.confinePointerImpl(bl);
                if (bl) {
                    try {
                        Thread.sleep(3L * this.screen.getDisplay().getEDTUtil().getPollPeriod());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (bl2) {
                this.pointerConfined = bl;
            }
        }
    }

    @Override
    public void warpPointer(int n, int n2) {
        if (0L != this.getWindowHandle()) {
            this.warpPointerImpl(n, n2);
        }
    }

    @Override
    public final InsetsImmutable getInsets() {
        if (this.isUndecorated()) {
            return Insets.getZero();
        }
        this.updateInsetsImpl(this.insets);
        return this.insets;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    protected final boolean autoPosition() {
        return this.autoPosition;
    }

    protected final void definePosition(int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("definePosition: " + this.x + "/" + this.y + " -> " + n + "/" + n2);
        }
        this.autoPosition = false;
        this.x = n;
        this.y = n2;
    }

    protected final void defineSize(int n, int n2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("defineSize: " + this.width + "x" + this.height + " -> " + n + "x" + n2);
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean hasDeviceChanged() {
        return false;
    }

    public LifecycleHook getLifecycleHook() {
        return this.lifecycleHook;
    }

    public LifecycleHook setLifecycleHook(LifecycleHook lifecycleHook) {
        LifecycleHook lifecycleHook2 = this.lifecycleHook;
        this.lifecycleHook = lifecycleHook;
        return lifecycleHook2;
    }

    public Object getWrappedWindow() {
        return null;
    }

    @Override
    public final Window getDelegatedWindow() {
        return this;
    }

    public void setHandleDestroyNotify(boolean bl) {
        this.handleDestroyNotify = bl;
    }

    public final AbstractGraphicsConfiguration getPrivateGraphicsConfiguration() {
        return this.config;
    }

    protected final long getParentWindowHandle() {
        return this.isFullscreen() ? 0L : this.parentWindowHandle;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName() + "[Config " + this.config + "\n, " + this.screen + "\n, ParentWindow " + this.parentWindow + "\n, ParentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + " (" + (0L != this.getParentWindowHandle()) + ")" + "\n, WindowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + "\n, SurfaceHandle " + WindowImpl.toHexString(this.getSurfaceHandle()) + " (lockedExt window " + this.windowLock.isLockedByOtherThread() + ", surface " + this.isSurfaceLockedByOtherThread() + ")" + "\n, Pos " + this.getX() + "/" + this.getY() + " (auto " + this.autoPosition() + "), size " + this.getWidth() + "x" + this.getHeight() + "\n, Visible " + this.isVisible() + ", focus " + this.hasFocus() + "\n, Undecorated " + this.undecorated + " (" + this.isUndecorated() + ")" + "\n, AlwaysOnTop " + this.alwaysOnTop + ", Fullscreen " + this.fullscreen + "\n, WrappedWindow " + this.getWrappedWindow() + "\n, ChildWindows " + this.childWindows.size());
        stringBuilder.append(", SurfaceUpdatedListeners num " + this.surfaceUpdatedHelper.size() + " [");
        for (n = 0; n < this.surfaceUpdatedHelper.size(); ++n) {
            stringBuilder.append(this.surfaceUpdatedHelper.get(n) + ", ");
        }
        stringBuilder.append("], WindowListeners num " + this.windowListeners.size() + " [");
        for (n = 0; n < this.windowListeners.size(); ++n) {
            stringBuilder.append(this.windowListeners.get(n) + ", ");
        }
        stringBuilder.append("], MouseListeners num " + this.mouseListeners.size() + " [");
        for (n = 0; n < this.mouseListeners.size(); ++n) {
            stringBuilder.append(this.mouseListeners.get(n) + ", ");
        }
        stringBuilder.append("], KeyListeners num " + this.keyListeners.size() + " [");
        for (n = 0; n < this.keyListeners.size(); ++n) {
            stringBuilder.append(this.keyListeners.get(n) + ", ");
        }
        stringBuilder.append("], windowLock " + this.windowLock + "]");
        return stringBuilder.toString();
    }

    protected final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    @Override
    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        if (this.windowLock.isOwner(Thread.currentThread())) {
            runnable.run();
        } else {
            Screen screen = this.getScreen();
            if (null == screen) {
                throw new RuntimeException("Null screen of inner class: " + this);
            }
            DisplayImpl displayImpl = (DisplayImpl)screen.getDisplay();
            displayImpl.runOnEDTIfAvail(bl, runnable);
        }
    }

    @Override
    public final boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public void requestFocus() {
        this.requestFocus(true);
    }

    @Override
    public void requestFocus(boolean bl) {
        this.requestFocus(bl, false, this.brokenFocusChange);
    }

    private void requestFocus(boolean bl, boolean bl2, boolean bl3) {
        if (!(!this.isNativeValid() || !bl3 && this.hasFocus() || !bl2 && this.focusAction())) {
            this.runOnEDTIfAvail(bl, bl3 ? this.requestFocusActionForced : this.requestFocusAction);
        }
    }

    private void requestFocusInt(boolean bl) {
        if (bl || !this.focusAction()) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusInt: forcing - (" + WindowImpl.getThreadName() + "): " + this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.requestFocusImpl(true);
        }
    }

    @Override
    public void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.focusAction = focusRunnable;
    }

    private boolean focusAction() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() START - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()));
        }
        boolean bl = null != this.focusAction ? this.focusAction.run() : false;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() END - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + ", res: " + bl);
        }
        return bl;
    }

    protected void setBrokenFocusChange(boolean bl) {
        this.brokenFocusChange = bl;
    }

    @Override
    public void setKeyboardFocusHandler(KeyListener keyListener) {
        this.keyboardFocusHandler = keyListener;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.autoPosition = false;
        this.runOnEDTIfAvail(true, new SetPositionAction(n, n2));
    }

    @Override
    public void setTopLevelPosition(int n, int n2) {
        this.setPosition(n + this.getInsets().getLeftWidth(), n2 + this.getInsets().getTopHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFullscreen(boolean bl) {
        FullScreenAction fullScreenAction = this.fullScreenAction;
        synchronized (fullScreenAction) {
            if (this.fullScreenAction.init(bl)) {
                if (this.fullScreenAction.fsOn() && WindowImpl.isOffscreenInstance(this, this.parentWindow)) {
                    if (null != this.parentWindow) {
                        this.nfs_parent = this.parentWindow;
                        this.reparentWindow(null, true);
                    } else {
                        throw new InternalError("Offscreen instance w/o parent unhandled");
                    }
                }
                this.runOnEDTIfAvail(true, this.fullScreenAction);
                if (!this.fullScreenAction.fsOn() && null != this.nfs_parent) {
                    this.reparentWindow(this.nfs_parent, true);
                    this.nfs_parent = null;
                }
                if (this.isVisible()) {
                    this.requestFocus(true, this.fullscreen, true);
                }
            }
            return this.fullscreen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeChild(NativeWindow nativeWindow) {
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.remove(nativeWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addChild(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            return false;
        }
        Object object = this.childWindowsLock;
        synchronized (object) {
            return this.childWindows.add(nativeWindow);
        }
    }

    private void doEvent(boolean bl, boolean bl2, NEWTEvent nEWTEvent) {
        boolean bl3 = false;
        if (!bl) {
            bl2 = bl3 = this.consumeEvent(nEWTEvent);
        }
        if (!bl3) {
            this.enqueueEvent(bl2, nEWTEvent);
        }
    }

    @Override
    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (this.isNativeValid()) {
            ((DisplayImpl)this.getScreen().getDisplay()).enqueueEvent(bl, nEWTEvent);
        }
    }

    @Override
    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        switch (nEWTEvent.getEventType()) {
            case 105: {
                if (null != this.windowLock.getOwner()) {
                    if (!this.repaintQueued) {
                        boolean bl;
                        this.repaintQueued = true;
                        boolean bl2 = bl = 1200L <= System.currentTimeMillis() - nEWTEvent.getWhen();
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.consumeEvent: " + Thread.currentThread().getName() + " - queued " + nEWTEvent + ", discard-to " + bl);
                        }
                        return bl;
                    }
                    return true;
                }
                this.repaintQueued = false;
                break;
            }
            case 100: {
                boolean bl;
                if (null == this.windowLock.getOwner()) break;
                boolean bl3 = bl = 1200L <= System.currentTimeMillis() - nEWTEvent.getWhen();
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.consumeEvent: " + Thread.currentThread().getName() + " - queued " + nEWTEvent + ", discard-to " + bl);
                }
                return bl;
            }
        }
        if (nEWTEvent instanceof WindowEvent) {
            this.consumeWindowEvent((WindowEvent)nEWTEvent);
        } else if (nEWTEvent instanceof KeyEvent) {
            this.consumeKeyEvent((KeyEvent)nEWTEvent);
        } else if (nEWTEvent instanceof MouseEvent) {
            this.consumeMouseEvent((MouseEvent)nEWTEvent);
        } else {
            throw new NativeWindowException("Unexpected NEWTEvent type " + nEWTEvent);
        }
        return true;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    public void sendMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doMouseEvent(false, false, n, n2, n3, n4, n5, n6);
    }

    public void enqueueMouseEvent(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doMouseEvent(true, bl, n, n2, n3, n4, n5, n6);
    }

    protected void doMouseEvent(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == 201 || n == 202) {
            if (n == 202 && n3 == -1 && n4 == -1) {
                n3 = this.lastMousePosition.getX();
                n4 = this.lastMousePosition.getY();
            }
            n3 = Math.min(Math.max(n3, 0), this.getWidth() - 1);
            n4 = Math.min(Math.max(n4, 0), this.getHeight() - 1);
            this.mouseInWindow = n == 201;
            this.lastMousePressed = 0L;
            this.mouseButtonPressed = 0;
        }
        if (n3 < 0 || n4 < 0 || n3 >= this.getWidth() || n4 >= this.getHeight()) {
            return;
        }
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("doMouseEvent: enqueue " + bl + ", wait " + bl2 + ", " + MouseEvent.getEventTypeString(n) + ", mod " + n2 + ", pos " + n3 + "/" + n4 + ", button " + n5 + ", lastMousePosition: " + this.lastMousePosition);
        }
        long l = System.currentTimeMillis();
        MouseEvent mouseEvent = null;
        if (n == 205) {
            if (!this.mouseInWindow) {
                this.mouseInWindow = true;
                mouseEvent = new MouseEvent(201, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
                this.lastMousePressed = 0L;
                this.mouseButtonPressed = 0;
            } else if (this.lastMousePosition.getX() == n3 && this.lastMousePosition.getY() == n4) {
                if (DEBUG_MOUSE_EVENT) {
                    System.err.println("doMouseEvent: skip EVENT_MOUSE_MOVED w/ same position: " + this.lastMousePosition);
                }
                return;
            }
            this.lastMousePosition.setX(n3);
            this.lastMousePosition.setY(n4);
        }
        if (0 > n5 || n5 > 16) {
            throw new NativeWindowException("Invalid mouse button number" + n5);
        }
        n2 |= InputEvent.getButtonMask(n5);
        MouseEvent mouseEvent2 = null;
        MouseEvent mouseEvent3 = null;
        if (this.isPointerConfined()) {
            n2 |= 0x40000000;
        }
        if (!this.isPointerVisible()) {
            n2 |= Integer.MIN_VALUE;
        }
        if (203 == n) {
            this.lastMouseClickCount = l - this.lastMousePressed < (long)MouseEvent.getClickTimeout() ? ++this.lastMouseClickCount : 1;
            this.lastMousePressed = l;
            this.mouseButtonPressed = n5;
            mouseEvent3 = new MouseEvent(n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
        } else if (204 == n) {
            mouseEvent3 = new MouseEvent(n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            if (l - this.lastMousePressed < (long)MouseEvent.getClickTimeout()) {
                mouseEvent2 = new MouseEvent(200, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            } else {
                this.lastMouseClickCount = 0;
                this.lastMousePressed = 0L;
            }
            this.mouseButtonPressed = 0;
        } else {
            mouseEvent3 = 205 == n ? (this.mouseButtonPressed > 0 ? new MouseEvent(206, this, l, n2, n3, n4, 1, this.mouseButtonPressed, 0) : new MouseEvent(n, this, l, n2, n3, n4, 0, n5, 0)) : (207 == n ? new MouseEvent(n, this, l, n2, n3, n4, 0, n5, n6) : new MouseEvent(n, this, l, n2, n3, n4, 0, n5, 0));
        }
        if (null != mouseEvent) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("doMouseEvent: synthesized MOUSE_ENTERED event: " + mouseEvent);
            }
            this.doEvent(bl, bl2, mouseEvent);
        }
        this.doEvent(bl, bl2, mouseEvent3);
        if (null != mouseEvent2) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("doMouseEvent: synthesized MOUSE_CLICKED event: " + mouseEvent2);
            }
            this.doEvent(bl, bl2, mouseEvent2);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.addMouseListener(-1, mouseListener);
    }

    @Override
    public void addMouseListener(int n, MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseListener);
        this.mouseListeners = arrayList;
    }

    @Override
    public MouseListener getMouseListener(int n) {
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (MouseListener)arrayList.get(n);
    }

    @Override
    public MouseListener[] getMouseListeners() {
        return this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]);
    }

    protected void consumeMouseEvent(MouseEvent mouseEvent) {
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("consumeMouseEvent: event:         " + mouseEvent);
        }
        boolean bl = false;
        for (int i = 0; !bl && i < this.mouseListeners.size(); ++i) {
            MouseListener mouseListener = this.mouseListeners.get(i);
            switch (mouseEvent.getEventType()) {
                case 200: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 201: {
                    mouseListener.mouseEntered(mouseEvent);
                    break;
                }
                case 202: {
                    mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 203: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 204: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 205: {
                    mouseListener.mouseMoved(mouseEvent);
                    break;
                }
                case 206: {
                    mouseListener.mouseDragged(mouseEvent);
                    break;
                }
                case 207: {
                    mouseListener.mouseWheelMoved(mouseEvent);
                    break;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
            bl = InputEvent.consumedTag == mouseEvent.getAttachment();
        }
    }

    protected final int isKeyPressed(int n) {
        if (0 <= n && (long)n < this.keyPressedState.capacity()) {
            return this.keyPressedState.get((long)n) ? 1 : 0;
        }
        return -1;
    }

    protected final int isKeyInAutoRepeat(int n) {
        if (0 <= n && (long)n < this.keyRepeatState.capacity()) {
            return this.keyRepeatState.get((long)n) ? 1 : 0;
        }
        return -1;
    }

    protected final boolean isKeyCodeTracked(int n) {
        return 0 <= n && (long)n < this.keyRepeatState.capacity();
    }

    public void sendKeyEvent(int n, int n2, int n3, char c) {
        this.consumeKeyEvent(new KeyEvent(n, this, System.currentTimeMillis(), n2, n3, c));
    }

    public void enqueueKeyEvent(boolean bl, int n, int n2, int n3, char c) {
        this.enqueueEvent(bl, new KeyEvent(n, this, System.currentTimeMillis(), n2, n3, c));
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.addKeyListener(-1, keyListener);
    }

    @Override
    public final void setKeyboardVisible(boolean bl) {
        if (this.isNativeValid()) {
            boolean bl2 = this.setKeyboardVisibleImpl(bl);
            if (DEBUG_IMPLEMENTATION || DEBUG_KEY_EVENT) {
                System.err.println("setKeyboardVisible(native): visible " + this.keyboardVisible + " -> " + bl + " -> " + bl2);
            }
            this.keyboardVisible = bl2;
        } else {
            this.keyboardVisible = bl;
        }
    }

    @Override
    public final boolean isKeyboardVisible() {
        return this.keyboardVisible;
    }

    protected boolean setKeyboardVisibleImpl(boolean bl) {
        return false;
    }

    protected void keyboardVisibilityChanged(boolean bl) {
        if (this.keyboardVisible != bl) {
            if (DEBUG_IMPLEMENTATION || DEBUG_KEY_EVENT) {
                System.err.println("keyboardVisibilityChanged: " + this.keyboardVisible + " -> " + bl);
            }
            this.keyboardVisible = bl;
        }
    }

    @Override
    public void addKeyListener(int n, KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.remove(keyListener);
        this.keyListeners = arrayList;
    }

    @Override
    public KeyListener getKeyListener(int n) {
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (KeyListener)arrayList.get(n);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        return this.keyListeners.toArray(new KeyListener[this.keyListeners.size()]);
    }

    private final boolean propagateKeyEvent(KeyEvent keyEvent, KeyListener keyListener) {
        switch (keyEvent.getEventType()) {
            case 300: {
                keyListener.keyPressed(keyEvent);
                break;
            }
            case 301: {
                keyListener.keyReleased(keyEvent);
                break;
            }
            case 302: {
                keyListener.keyTyped(keyEvent);
                break;
            }
            default: {
                throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
            }
        }
        return InputEvent.consumedTag == keyEvent.getAttachment();
    }

    protected void consumeKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        if (null != this.keyboardFocusHandler) {
            bl = this.propagateKeyEvent(keyEvent, this.keyboardFocusHandler);
            if (DEBUG_KEY_EVENT) {
                System.err.println("consumeKeyEvent: " + keyEvent + ", keyboardFocusHandler consumed: " + bl);
            }
        } else {
            bl = false;
            if (DEBUG_KEY_EVENT) {
                System.err.println("consumeKeyEvent: " + keyEvent);
            }
        }
        for (int i = 0; !bl && i < this.keyListeners.size(); ++i) {
            bl = this.propagateKeyEvent(keyEvent, this.keyListeners.get(i));
        }
    }

    @Override
    public void sendWindowEvent(int n) {
        this.consumeWindowEvent(new WindowEvent(n, this, System.currentTimeMillis()));
    }

    public void enqueueWindowEvent(boolean bl, int n) {
        this.enqueueEvent(bl, new WindowEvent(n, this, System.currentTimeMillis()));
    }

    @Override
    public void addWindowListener(WindowListener windowListener) {
        this.addWindowListener(-1, windowListener);
    }

    @Override
    public void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public final void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        arrayList.remove(windowListener);
        this.windowListeners = arrayList;
    }

    @Override
    public WindowListener getWindowListener(int n) {
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (WindowListener)arrayList.get(n);
    }

    @Override
    public WindowListener[] getWindowListeners() {
        return this.windowListeners.toArray(new WindowListener[this.windowListeners.size()]);
    }

    protected void consumeWindowEvent(WindowEvent windowEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("consumeWindowEvent: " + windowEvent + ", visible " + this.isVisible() + " " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight());
        }
        block9: for (int i = 0; i < this.windowListeners.size(); ++i) {
            WindowListener windowListener = this.windowListeners.get(i);
            switch (windowEvent.getEventType()) {
                case 100: {
                    windowListener.windowResized(windowEvent);
                    continue block9;
                }
                case 101: {
                    windowListener.windowMoved(windowEvent);
                    continue block9;
                }
                case 102: {
                    windowListener.windowDestroyNotify(windowEvent);
                    continue block9;
                }
                case 106: {
                    windowListener.windowDestroyed(windowEvent);
                    continue block9;
                }
                case 103: {
                    windowListener.windowGainedFocus(windowEvent);
                    continue block9;
                }
                case 104: {
                    windowListener.windowLostFocus(windowEvent);
                    continue block9;
                }
                case 105: {
                    windowListener.windowRepaint((WindowUpdateEvent)windowEvent);
                    continue block9;
                }
                default: {
                    throw new NativeWindowException("Unexpected window event type " + windowEvent.getEventType());
                }
            }
        }
    }

    protected void focusChanged(boolean bl, boolean bl2) {
        if (this.brokenFocusChange || this.hasFocus != bl2) {
            int n;
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.focusChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + this.hasFocus + " -> " + bl2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.hasFocus = bl2;
            int n2 = n = bl2 ? 103 : 104;
            if (!bl) {
                this.sendWindowEvent(n);
            } else {
                this.enqueueWindowEvent(false, n);
            }
        }
    }

    protected void visibleChanged(boolean bl, boolean bl2) {
        if (this.visible != bl2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.visibleChanged (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + this.visible + " -> " + bl2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.visible = bl2;
        }
    }

    private boolean waitForVisible(boolean bl, boolean bl2) {
        return this.waitForVisible(bl, bl2, 1000L);
    }

    private boolean waitForVisible(boolean bl, boolean bl2, long l) {
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        for (long i = l; 0L < i && this.visible != bl; i -= 10L) {
            displayImpl.dispatchMessagesNative();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.visible != bl) {
            String string = "Visibility not reached as requested within " + l + "ms : requested " + bl + ", is " + this.visible;
            if (bl2) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
            }
        }
        return this.visible == bl;
    }

    protected void sizeChanged(boolean bl, int n, int n2, boolean bl2) {
        if (bl2 || this.getWidth() != n || this.getHeight() != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.sizeChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") force " + bl2 + ", " + this.getWidth() + "x" + this.getHeight() + " -> " + n + "x" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            if (0 > n || 0 > n2) {
                throw new NativeWindowException("Illegal width or height " + n + "x" + n2 + " (must be >= 0)");
            }
            this.defineSize(n, n2);
            if (this.isNativeValid()) {
                if (!bl) {
                    this.sendWindowEvent(100);
                } else {
                    this.enqueueWindowEvent(false, 100);
                }
            }
        }
    }

    private boolean waitForSize(int n, int n2, boolean bl, long l) {
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        boolean bl2 = false;
        for (long i = l; !bl2 && 0L < i; i -= 10L) {
            if (n == this.getWidth() && n2 == this.getHeight()) {
                bl2 = true;
                continue;
            }
            displayImpl.dispatchMessagesNative();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!bl2) {
            String string = "Size/Pos not reached as requested within " + l + "ms : requested " + n + "x" + n2 + ", is " + this.getWidth() + "x" + this.getHeight();
            if (bl) {
                throw new NativeWindowException(string);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println(string);
                Thread.dumpStack();
            }
        }
        return bl2;
    }

    protected void positionChanged(boolean bl, int n, int n2) {
        if (this.getX() != n || this.getY() != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.positionChanged: (" + WindowImpl.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n + "/" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.definePosition(n, n2);
            if (!bl) {
                this.sendWindowEvent(101);
            } else {
                this.enqueueWindowEvent(false, 101);
            }
        } else {
            this.autoPosition = false;
        }
    }

    protected void insetsChanged(boolean bl, int n, int n2, int n3, int n4) {
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
            if (this.isUndecorated()) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: skip insets change for undecoration mode");
                }
            } else if (n != this.insets.getLeftWidth() || n2 != this.insets.getRightWidth() || n3 != this.insets.getTopHeight() || n4 != this.insets.getBottomHeight()) {
                this.insets.setLeftWidth(n);
                this.insets.setRightWidth(n2);
                this.insets.setTopHeight(n3);
                this.insets.setBottomHeight(n4);
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.insetsChanged: (defer: " + bl + ") " + this.insets);
                }
            }
        }
    }

    protected boolean windowDestroyNotify(boolean bl) {
        boolean bl2;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify(force: " + bl + ") START " + WindowImpl.getThreadName() + ": " + this);
        }
        if (bl) {
            this.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE);
        }
        this.enqueueWindowEvent(true, 102);
        if (this.handleDestroyNotify && WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == this.getDefaultCloseOperation()) {
            this.destroy();
        }
        boolean bl3 = bl2 = !this.isNativeValid();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify(force: " + bl + ") END " + WindowImpl.getThreadName() + ": destroyed " + bl2 + ", " + this);
        }
        return bl2;
    }

    @Override
    public void windowRepaint(int n, int n2, int n3, int n4) {
        this.windowRepaint(false, n, n2, n3, n4);
    }

    protected void windowRepaint(boolean bl, int n, int n2, int n3, int n4) {
        n3 = 0 >= n3 ? this.getWidth() : n3;
        int n5 = n4 = 0 >= n4 ? this.getHeight() : n4;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowRepaint " + WindowImpl.getThreadName() + " (defer: " + bl + ") " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        if (this.isNativeValid()) {
            WindowUpdateEvent windowUpdateEvent = new WindowUpdateEvent(105, this, System.currentTimeMillis(), new Rectangle(n, n2, n3, n4));
            this.doEvent(bl, false, windowUpdateEvent);
        }
    }

    private static Class<?>[] getCustomConstructorArgumentTypes(Class<?> clazz) {
        Class[] classArray = null;
        try {
            Method method = clazz.getDeclaredMethod("getCustomConstructorArgumentTypes", new Class[0]);
            classArray = (Class[])method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classArray;
    }

    private static int verifyConstructorArgumentTypes(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return i;
        }
        return objectArray.length;
    }

    private static String getArgsStrList(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i].getClass());
            if (i >= objectArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private static String getTypeStrList(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(classArray[i]);
            if (i >= classArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    protected final void shouldNotCallThis() {
        throw new NativeWindowException("Should not call this");
    }

    public static String getThreadName() {
        return Display.getThreadName();
    }

    public static String toHexString(int n) {
        return Display.toHexString(n);
    }

    public static String toHexString(long l) {
        return Display.toHexString(l);
    }

    private class AlwaysOnTopAction
    implements Runnable {
        boolean alwaysOnTop;

        private AlwaysOnTopAction(boolean bl) {
            this.alwaysOnTop = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.alwaysOnTop != this.alwaysOnTop) {
                    WindowImpl.this.alwaysOnTop = this.alwaysOnTop;
                    if (WindowImpl.this.isNativeValid()) {
                        int n = WindowImpl.this.getX();
                        int n2 = WindowImpl.this.getY();
                        int n3 = WindowImpl.this.getWidth();
                        int n4 = WindowImpl.this.getHeight();
                        DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(8, WindowImpl.this.isVisible()));
                        displayImpl.dispatchMessagesNative();
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class DecorationAction
    implements Runnable {
        boolean undecorated;

        private DecorationAction(boolean bl) {
            this.undecorated = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (WindowImpl.this.undecorated != this.undecorated) {
                    WindowImpl.this.undecorated = this.undecorated;
                    if (WindowImpl.this.isNativeValid() && !WindowImpl.this.isFullscreen()) {
                        int n = WindowImpl.this.getX();
                        int n2 = WindowImpl.this.getY();
                        int n3 = WindowImpl.this.getWidth();
                        int n4 = WindowImpl.this.getHeight();
                        DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(2, WindowImpl.this.isVisible()));
                        displayImpl.dispatchMessagesNative();
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class DestroyAction
    implements Runnable {
        private DestroyAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            if (null != WindowImpl.this.lifecycleHook) {
                WindowImpl.this.lifecycleHook.destroyActionPreLock();
            }
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window DestroyAction() " + WindowImpl.getThreadName());
                }
                Object object = WindowImpl.this.childWindowsLock;
                synchronized (object) {
                    if (WindowImpl.this.childWindows.size() > 0) {
                        ArrayList arrayList = (ArrayList)WindowImpl.this.childWindows.clone();
                        while (arrayList.size() > 0) {
                            NativeWindow nativeWindow = (NativeWindow)arrayList.remove(0);
                            if (nativeWindow instanceof WindowImpl) {
                                ((WindowImpl)nativeWindow).sendWindowEvent(102);
                                ((WindowImpl)nativeWindow).destroy();
                                continue;
                            }
                            nativeWindow.destroy();
                        }
                    }
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.destroyActionInLock();
                }
                if (null != WindowImpl.this.screen) {
                    if (WindowImpl.this.isNativeValid()) {
                        WindowImpl.this.screen.removeScreenModeListener(WindowImpl.this.screenModeListenerImpl);
                        WindowImpl.this.closeNativeImpl();
                        WindowImpl.this.removeScreenReference();
                    }
                    if (null != (object = WindowImpl.this.screen.getDisplay())) {
                        ((Display)object).validateEDT();
                    }
                }
                WindowImpl.this.sendWindowEvent(106);
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.destroy() END " + WindowImpl.getThreadName());
                }
            }
            finally {
                WindowImpl.this.setWindowHandle(0L);
                WindowImpl.this.visible = false;
                WindowImpl.this.fullscreen = false;
                WindowImpl.this.hasFocus = false;
                WindowImpl.this.parentWindowHandle = 0L;
                recursiveLock.unlock();
            }
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }
    }

    private class FullScreenAction
    implements Runnable {
        boolean fullscreen;

        private FullScreenAction() {
        }

        private boolean init(boolean bl) {
            if (WindowImpl.this.isNativeValid()) {
                this.fullscreen = bl;
                return WindowImpl.this.isFullscreen() != bl;
            }
            WindowImpl.this.fullscreen = bl;
            return false;
        }

        public boolean fsOn() {
            return this.fullscreen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                NativeWindow nativeWindow;
                int n;
                int n2;
                int n3;
                int n4;
                WindowImpl.this.fullscreen = this.fullscreen;
                ScreenMode screenMode = WindowImpl.this.screen.getCurrentScreenMode();
                if (this.fullscreen) {
                    WindowImpl.this.nfs_x = WindowImpl.this.getX();
                    WindowImpl.this.nfs_y = WindowImpl.this.getY();
                    WindowImpl.this.nfs_width = WindowImpl.this.getWidth();
                    WindowImpl.this.nfs_height = WindowImpl.this.getHeight();
                    n4 = WindowImpl.this.screen.getX();
                    n3 = WindowImpl.this.screen.getY();
                    n2 = screenMode.getRotatedWidth();
                    n = screenMode.getRotatedHeight();
                } else {
                    n4 = WindowImpl.this.nfs_x;
                    n3 = WindowImpl.this.nfs_y;
                    n2 = WindowImpl.this.nfs_width;
                    n = WindowImpl.this.nfs_height;
                    if (null != WindowImpl.this.parentWindow) {
                        n4 = 0;
                        n3 = 0;
                        if (n2 > WindowImpl.this.parentWindow.getWidth()) {
                            n2 = WindowImpl.this.parentWindow.getWidth();
                        }
                        if (n > WindowImpl.this.parentWindow.getHeight()) {
                            n = WindowImpl.this.parentWindow.getHeight();
                        }
                    }
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window fs: " + this.fullscreen + " " + n4 + "/" + n3 + " " + n2 + "x" + n + ", " + WindowImpl.this.isUndecorated() + ", virtl-size: " + WindowImpl.this.screen.getWidth() + "x" + WindowImpl.this.screen.getHeight() + ", SM " + screenMode.getRotatedWidth() + "x" + screenMode.getRotatedHeight());
                }
                DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                displayImpl.dispatchMessagesNative();
                boolean bl = WindowImpl.this.isVisible();
                if (null != WindowImpl.this.parentWindow) {
                    nativeWindow = WindowImpl.this.parentWindow;
                    if (1 >= nativeWindow.lockSurface()) {
                        throw new NativeWindowException("Parent surface lock: not ready: " + WindowImpl.this.parentWindow);
                    }
                } else {
                    nativeWindow = null;
                }
                try {
                    WindowImpl.this.reconfigureWindowImpl(n4, n3, n2, n, WindowImpl.this.getReconfigureFlags((null != nativeWindow ? 1 : 0) | 4 | 2, bl));
                }
                finally {
                    if (null != nativeWindow) {
                        nativeWindow.unlockSurface();
                    }
                }
                displayImpl.dispatchMessagesNative();
                if (bl) {
                    WindowImpl.this.setVisibleImpl(true, n4, n3, n2, n);
                    WindowImpl.this.waitForVisible(true, false);
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.waitForSize(n2, n, false, 1000L);
                    displayImpl.dispatchMessagesNative();
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window fs done: " + WindowImpl.this);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    public static interface LifecycleHook {
        public void resetCounter();

        public void setVisibleActionPost(boolean var1, boolean var2);

        public void destroyActionPreLock();

        public void destroyActionInLock();

        public boolean pauseRenderingAction();

        public void resumeRenderingAction();
    }

    private class ReparentAction
    implements Runnable {
        NativeWindow newParentWindow;
        boolean forceDestroyCreate;
        Window.ReparentOperation operation;

        private ReparentAction(NativeWindow nativeWindow, boolean bl) {
            this.newParentWindow = nativeWindow;
            this.forceDestroyCreate = bl | DEBUG_TEST_REPARENT_INCOMPATIBLE;
            this.operation = Window.ReparentOperation.ACTION_INVALID;
        }

        private Window.ReparentOperation getOp() {
            return this.operation;
        }

        private void setScreen(ScreenImpl screenImpl) {
            WindowImpl.this.removeScreenReference();
            WindowImpl.this.screen = screenImpl;
        }

        @Override
        public final void run() {
            boolean bl = false;
            if (null != WindowImpl.this.lifecycleHook) {
                bl = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
            this.reparent();
            if (bl) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reparent() {
            boolean bl;
            int n = WindowImpl.this.getX();
            int n2 = WindowImpl.this.getY();
            int n3 = WindowImpl.this.getWidth();
            int n4 = WindowImpl.this.getHeight();
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                Object object;
                if (WindowImpl.this.isNativeValid()) {
                    this.forceDestroyCreate |= WindowImpl.isOffscreenInstance(WindowImpl.this, this.newParentWindow);
                }
                bl = WindowImpl.this.isVisible();
                Window window = null;
                if (this.newParentWindow instanceof Window) {
                    window = (Window)this.newParentWindow;
                }
                long l = 0L;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: START (" + WindowImpl.getThreadName() + ") valid " + WindowImpl.this.isNativeValid() + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", visible " + bl + ", old parentWindow: " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + ", new parentWindow: " + Display.hashCodeNullSafe(this.newParentWindow) + ", forceDestroyCreate " + this.forceDestroyCreate + ", " + n + "/" + n2 + " " + n3 + "x" + n4);
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.resetCounter();
                }
                if (null != this.newParentWindow) {
                    n = 0;
                    n2 = 0;
                    if (n3 > this.newParentWindow.getWidth()) {
                        n3 = this.newParentWindow.getWidth();
                    }
                    if (n4 > this.newParentWindow.getHeight()) {
                        n4 = this.newParentWindow.getHeight();
                    }
                    if (0L == (l = WindowImpl.getNativeWindowHandle(this.newParentWindow))) {
                        if (null == window) {
                            throw new NativeWindowException("Reparenting with non NEWT Window type only available after it's realized: " + this.newParentWindow);
                        }
                        WindowImpl.this.destroy();
                        this.setScreen((ScreenImpl)window.getScreen());
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                    } else if (this.newParentWindow != WindowImpl.this.getParent()) {
                        if (!WindowImpl.this.isNativeValid()) {
                            if (null != window) {
                                this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                object = NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.getScreen());
                                if (WindowImpl.this.getScreen() != object) {
                                    this.setScreen((ScreenImpl)object);
                                }
                            }
                            this.operation = 0 < n3 && 0 < n4 ? Window.ReparentOperation.ACTION_NATIVE_CREATION : Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                        } else if (this.forceDestroyCreate || !NewtFactory.isScreenCompatible(this.newParentWindow, WindowImpl.this.getScreen())) {
                            WindowImpl.this.destroy();
                            if (null != window) {
                                this.setScreen((ScreenImpl)window.getScreen());
                            } else {
                                this.setScreen((ScreenImpl)NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.getScreen()));
                            }
                            this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION;
                        } else {
                            this.operation = Window.ReparentOperation.ACTION_NATIVE_REPARENTING;
                        }
                    } else {
                        this.operation = Window.ReparentOperation.ACTION_NOP;
                    }
                } else {
                    if (null != WindowImpl.this.parentWindow) {
                        object = WindowImpl.this.getLocationOnScreen(null);
                        n = ((Point)object).getX();
                        n2 = ((Point)object).getY();
                    }
                    if (0L == WindowImpl.this.parentWindowHandle) {
                        this.operation = Window.ReparentOperation.ACTION_NOP;
                    } else if (!WindowImpl.this.isNativeValid() || this.forceDestroyCreate) {
                        WindowImpl.this.destroy();
                        this.operation = 0 < n3 && 0 < n4 ? Window.ReparentOperation.ACTION_NATIVE_CREATION : Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING;
                    } else {
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_REPARENTING;
                    }
                }
                WindowImpl.this.parentWindowHandle = l;
                if (Window.ReparentOperation.ACTION_INVALID == this.operation) {
                    throw new NativeWindowException("Internal Error: reparentAction not set");
                }
                if (Window.ReparentOperation.ACTION_NOP == this.operation) {
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window.reparent: NO CHANGE (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", visible " + bl);
                    }
                    return;
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparent: ACTION (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", reparentAction " + (Object)((Object)this.operation) + ", visible " + bl);
                }
                if (null != WindowImpl.this.parentWindow && WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).removeChild(WindowImpl.this);
                }
                WindowImpl.this.parentWindow = this.newParentWindow;
                if (WindowImpl.this.parentWindow instanceof Window) {
                    ((Window)WindowImpl.this.parentWindow).addChild(WindowImpl.this);
                }
                if (Window.ReparentOperation.ACTION_NATIVE_CREATION_PENDING == this.operation) {
                    WindowImpl.this.definePosition(n, n2);
                    WindowImpl.this.defineSize(n3, n4);
                    return;
                }
                if (Window.ReparentOperation.ACTION_NATIVE_REPARENTING == this.operation) {
                    NativeWindow nativeWindow;
                    object = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    ((DisplayImpl)object).dispatchMessagesNative();
                    if (bl) {
                        WindowImpl.this.setVisibleImpl(false, n, n2, n3, n4);
                        WindowImpl.this.waitForVisible(false, true);
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ((DisplayImpl)object).dispatchMessagesNative();
                    }
                    if (null != WindowImpl.this.parentWindow) {
                        nativeWindow = WindowImpl.this.parentWindow;
                        if (1 >= nativeWindow.lockSurface()) {
                            throw new NativeWindowException("Parent surface lock: not ready: " + nativeWindow);
                        }
                        WindowImpl.this.parentWindowHandle = nativeWindow.getWindowHandle();
                    } else {
                        nativeWindow = null;
                    }
                    boolean bl2 = false;
                    try {
                        bl2 = WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, WindowImpl.this.getReconfigureFlags(3, WindowImpl.this.isVisible()));
                    }
                    finally {
                        if (null != nativeWindow) {
                            nativeWindow.unlockSurface();
                        }
                    }
                    if (bl2) {
                        ((DisplayImpl)object).dispatchMessagesNative();
                        if (bl) {
                            WindowImpl.this.setVisibleImpl(true, n, n2, n3, n4);
                            bl2 = WindowImpl.this.waitForVisible(true, false);
                            ((DisplayImpl)object).dispatchMessagesNative();
                            if (bl2) {
                                bl2 = WindowImpl.this.waitForSize(n3, n4, false, 1000L);
                            }
                            if (bl2) {
                                WindowImpl.this.requestFocusInt(false);
                                ((DisplayImpl)object).dispatchMessagesNative();
                            }
                        }
                    }
                    if (!bl2 || !bl) {
                        WindowImpl.this.definePosition(n, n2);
                        WindowImpl.this.defineSize(n3, n4);
                    }
                    if (!bl2) {
                        if (Window.DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.reparent: native reparenting failed (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + " -> " + WindowImpl.toHexString(l) + " - Trying recreation");
                        }
                        WindowImpl.this.destroy();
                        this.operation = Window.ReparentOperation.ACTION_NATIVE_CREATION;
                    }
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparentWindow: END-1 (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + n + "/" + n2 + " " + n3 + "x" + n4);
                }
            }
            finally {
                recursiveLock.unlock();
            }
            if (bl) {
                switch (this.operation) {
                    case ACTION_NATIVE_REPARENTING: {
                        WindowImpl.this.sendWindowEvent(100);
                        break;
                    }
                    case ACTION_NATIVE_CREATION: {
                        WindowImpl.this.runOnEDTIfAvail(true, WindowImpl.this.reparentActionRecreate);
                        break;
                    }
                }
            }
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.reparentWindow: END-X (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + n + "/" + n2 + " " + n3 + "x" + n4);
            }
        }
    }

    private class ReparentActionRecreate
    implements Runnable {
        private ReparentActionRecreate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                WindowImpl.this.visible = true;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparentWindow: ReparentActionRecreate (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow));
                }
                WindowImpl.this.setVisible(true);
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class ScreenModeListenerImpl
    implements ScreenModeListener {
        boolean animatorPaused = false;

        private ScreenModeListenerImpl() {
        }

        @Override
        public void screenModeChangeNotify(ScreenMode screenMode) {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.screenModeChangeNotify: " + screenMode);
            }
            if (null != WindowImpl.this.lifecycleHook) {
                this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
        }

        @Override
        public void screenModeChanged(ScreenMode screenMode, boolean bl) {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.screenModeChanged: " + screenMode + ", success: " + bl);
            }
            if (bl) {
                if (!this.animatorPaused && null != WindowImpl.this.lifecycleHook) {
                    this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
                }
                DimensionImmutable dimensionImmutable = screenMode.getMonitorMode().getSurfaceSize().getResolution();
                if (WindowImpl.this.getHeight() > dimensionImmutable.getHeight() || WindowImpl.this.getWidth() > dimensionImmutable.getWidth()) {
                    WindowImpl.this.setSize(dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
                }
            }
            if (this.animatorPaused) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    private class SetPositionAction
    implements Runnable {
        int x;
        int y;

        private SetPositionAction(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setPosition: " + WindowImpl.this.getX() + "/" + WindowImpl.this.getY() + " -> " + this.x + "/" + this.y + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle));
                }
                if (!(WindowImpl.this.isFullscreen() || WindowImpl.this.getX() == this.x && WindowImpl.this.getY() == this.y)) {
                    if (WindowImpl.this.isNativeValid()) {
                        WindowImpl.this.reconfigureWindowImpl(this.x, this.y, WindowImpl.this.getWidth(), WindowImpl.this.getHeight(), WindowImpl.this.getReconfigureFlags(0, WindowImpl.this.isVisible()));
                    } else {
                        WindowImpl.this.definePosition(this.x, this.y);
                    }
                }
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class SetSizeAction
    implements Runnable {
        int width;
        int height;

        private SetSizeAction(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            RecursiveLock recursiveLock = WindowImpl.this.windowLock;
            recursiveLock.lock();
            try {
                int n;
                if (WindowImpl.this.isFullscreen()) return;
                if (WindowImpl.this.getWidth() == this.width) {
                    if (WindowImpl.this.getHeight() == this.height) return;
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: START " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight() + " -> " + this.width + "x" + this.height + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible " + WindowImpl.this.visible);
                }
                if (WindowImpl.this.visible && WindowImpl.this.isNativeValid() && (0 >= this.width || 0 >= this.height)) {
                    n = 1;
                    WindowImpl.this.defineSize(0, 0);
                } else if (WindowImpl.this.visible && !WindowImpl.this.isNativeValid() && 0 < this.width && 0 < this.height) {
                    n = 2;
                    WindowImpl.this.defineSize(this.width, this.height);
                } else if (WindowImpl.this.isNativeValid()) {
                    n = 0;
                    WindowImpl.this.reconfigureWindowImpl(WindowImpl.this.getX(), WindowImpl.this.getY(), this.width, this.height, WindowImpl.this.getReconfigureFlags(0, WindowImpl.this.isVisible()));
                } else {
                    n = 0;
                    WindowImpl.this.defineSize(this.width, this.height);
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setSize: END " + WindowImpl.this.getWidth() + "x" + WindowImpl.this.getHeight() + ", visibleAction " + n);
                }
                switch (n) {
                    case 1: {
                        WindowImpl.this.setVisibleActionImpl(false);
                        return;
                    }
                    case 2: {
                        WindowImpl.this.setVisibleActionImpl(true);
                        return;
                    }
                }
                return;
            }
            finally {
                recursiveLock.unlock();
            }
        }
    }

    private class VisibleAction
    implements Runnable {
        boolean visible;

        private VisibleAction(boolean bl) {
            this.visible = bl;
        }

        @Override
        public final void run() {
            WindowImpl.this.setVisibleActionImpl(this.visible);
        }
    }
}

