/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import com.jogamp.common.os.Platform;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.awt.AWTUtil;

public class Java2D {
    private static boolean DEBUG = Debug.debug("Java2D");
    private static boolean isHeadless;
    private static boolean isOGLPipelineActive;
    private static Method invokeWithOGLContextCurrentMethod;
    private static Method isQueueFlusherThreadMethod;
    private static Method getOGLViewportMethod;
    private static Method getOGLScissorBoxMethod;
    private static Method getOGLSurfaceIdentifierMethod;
    private static Method getOGLTextureTypeMethod;
    private static boolean fbObjectSupportInitialized;
    private static Method invokeWithOGLSharedContextCurrentMethod;
    private static Method getOGLSurfaceTypeMethod;
    public static final int UNDEFINED;
    public static final int WINDOW;
    public static final int PBUFFER;
    public static final int TEXTURE;
    public static final int FLIP_BACKBUFFER;
    public static final int FBOBJECT;
    private static boolean initializedJ2DFBOShareContext;
    private static GLContext j2dFBOShareContext;
    private static Method createOGLContextOnSurfaceMethod;
    private static Method makeOGLContextCurrentOnSurfaceMethod;
    private static Method destroyOGLContextMethod;

    public static boolean isOGLPipelineActive() {
        return isOGLPipelineActive;
    }

    public static boolean isFBOEnabled() {
        return fbObjectSupportInitialized;
    }

    public static boolean isQueueFlusherThread() {
        Java2D.checkActive();
        try {
            return (Boolean)isQueueFlusherThreadMethod.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeWithOGLContextCurrent(Graphics graphics, Runnable runnable) throws GLException {
        Java2D.checkActive();
        try {
            Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
            AWTUtil.lockToolkit();
            try {
                invokeWithOGLContextCurrentMethod.invoke(null, graphics, runnable);
            }
            finally {
                AWTUtil.unlockToolkit();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean invokeWithOGLSharedContextCurrent(GraphicsConfiguration graphicsConfiguration, Runnable runnable) throws GLException {
        boolean bl;
        Java2D.checkActive();
        AWTUtil.lockToolkit();
        try {
            bl = (Boolean)invokeWithOGLSharedContextCurrentMethod.invoke(null, graphicsConfiguration, runnable);
        }
        catch (Throwable throwable) {
            try {
                AWTUtil.unlockToolkit();
                throw throwable;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new GLException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw (InternalError)new InternalError().initCause(exception);
            }
        }
        AWTUtil.unlockToolkit();
        return bl;
    }

    public static Rectangle getOGLViewport(Graphics graphics, int n, int n2) {
        Java2D.checkActive();
        try {
            return (Rectangle)getOGLViewportMethod.invoke(null, graphics, new Integer(n), new Integer(n2));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Rectangle getOGLScissorBox(Graphics graphics) {
        Java2D.checkActive();
        try {
            return (Rectangle)getOGLScissorBoxMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static Object getOGLSurfaceIdentifier(Graphics graphics) {
        Java2D.checkActive();
        try {
            return getOGLSurfaceIdentifierMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLSurfaceType(Graphics graphics) {
        Java2D.checkActive();
        try {
            if (!fbObjectSupportInitialized) {
                return 0;
            }
            return (Integer)getOGLSurfaceTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static int getOGLTextureType(Graphics graphics) {
        Java2D.checkActive();
        if (getOGLTextureTypeMethod == null) {
            return 3553;
        }
        try {
            return (Integer)getOGLTextureTypeMethod.invoke(null, graphics);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static GLContext filterShareContext(GLContext gLContext) {
        if (isHeadless) {
            return gLContext;
        }
        Java2D.initFBOShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        if (j2dFBOShareContext != null) {
            return j2dFBOShareContext;
        }
        return gLContext;
    }

    public static GLContext getShareContext(GraphicsDevice graphicsDevice) {
        Java2D.initFBOShareContext(graphicsDevice);
        return j2dFBOShareContext;
    }

    public static long createOGLContextOnSurface(Graphics graphics, long l) {
        Java2D.checkActive();
        try {
            return (Long)createOGLContextOnSurfaceMethod.invoke(null, graphics, new Long(l));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static boolean makeOGLContextCurrentOnSurface(Graphics graphics, long l) {
        Java2D.checkActive();
        try {
            return (Boolean)makeOGLContextCurrentOnSurfaceMethod.invoke(null, graphics, new Long(l));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    public static void destroyOGLContext(long l) {
        Java2D.checkActive();
        try {
            destroyOGLContextMethod.invoke(null, new Long(l));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GLException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError().initCause(exception);
        }
    }

    private static void checkActive() {
        if (!Java2D.isOGLPipelineActive()) {
            throw new GLException("Java2D OpenGL pipeline not active (or necessary support not present)");
        }
    }

    private static int getOGLUtilitiesIntField(final String string) {
        Integer n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    Class<?> clazz = Class.forName("sun.java2d.opengl.OGLUtilities");
                    Field field = clazz.getField(string);
                    field.setAccessible(true);
                    return (Integer)field.get(null);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                    return null;
                }
            }
        });
        if (n == null) {
            return 0;
        }
        if (DEBUG) {
            System.err.println("OGLUtilities." + string + " = " + n);
        }
        return n;
    }

    private static void initFBOShareContext(GraphicsDevice graphicsDevice) {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled() && !initializedJ2DFBOShareContext) {
            initializedJ2DFBOShareContext = true;
            if (DEBUG) {
                System.err.println("Starting initialization of J2D FBO share context");
            }
            Java2D.invokeWithOGLSharedContextCurrent(graphicsDevice.getDefaultConfiguration(), new Runnable(){

                @Override
                public void run() {
                    j2dFBOShareContext = GLDrawableFactory.getFactory(GLProfile.getDefault(GLProfile.getDefaultDevice())).createExternalGLContext();
                }
            });
            if (DEBUG) {
                System.err.println("Ending initialization of J2D FBO share context");
            }
        }
    }

    static {
        UNDEFINED = Java2D.getOGLUtilitiesIntField("UNDEFINED");
        WINDOW = Java2D.getOGLUtilitiesIntField("WINDOW");
        PBUFFER = Java2D.getOGLUtilitiesIntField("PBUFFER");
        TEXTURE = Java2D.getOGLUtilitiesIntField("TEXTURE");
        FLIP_BACKBUFFER = Java2D.getOGLUtilitiesIntField("FLIP_BACKBUFFER");
        FBOBJECT = Java2D.getOGLUtilitiesIntField("FBOBJECT");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Throwable throwable;
                block17: {
                    if (DEBUG) {
                        System.err.println("Checking for Java2D/OpenGL support");
                    }
                    throwable = null;
                    try {
                        isHeadless = true;
                        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                        isHeadless = false;
                        String string = graphicsConfiguration.getClass().getName();
                        if (DEBUG) {
                            System.err.println("Java2D support: default GraphicsConfiguration = " + string);
                        }
                        isOGLPipelineActive = Platform.OS_TYPE != Platform.OSType.MACOS && string.startsWith("sun.java2d.opengl");
                        if (!isOGLPipelineActive) break block17;
                        try {
                            Class<?> clazz;
                            block20: {
                                block19: {
                                    Class<?> clazz2;
                                    block18: {
                                        clazz2 = Class.forName("sun.java2d.opengl.OGLUtilities");
                                        invokeWithOGLContextCurrentMethod = clazz2.getDeclaredMethod("invokeWithOGLContextCurrent", Graphics.class, Runnable.class);
                                        invokeWithOGLContextCurrentMethod.setAccessible(true);
                                        isQueueFlusherThreadMethod = clazz2.getDeclaredMethod("isQueueFlusherThread", new Class[0]);
                                        isQueueFlusherThreadMethod.setAccessible(true);
                                        getOGLViewportMethod = clazz2.getDeclaredMethod("getOGLViewport", Graphics.class, Integer.TYPE, Integer.TYPE);
                                        getOGLViewportMethod.setAccessible(true);
                                        getOGLScissorBoxMethod = clazz2.getDeclaredMethod("getOGLScissorBox", Graphics.class);
                                        getOGLScissorBoxMethod.setAccessible(true);
                                        getOGLSurfaceIdentifierMethod = clazz2.getDeclaredMethod("getOGLSurfaceIdentifier", Graphics.class);
                                        getOGLSurfaceIdentifierMethod.setAccessible(true);
                                        fbObjectSupportInitialized = true;
                                        try {
                                            invokeWithOGLSharedContextCurrentMethod = clazz2.getDeclaredMethod("invokeWithOGLSharedContextCurrent", GraphicsConfiguration.class, Runnable.class);
                                            invokeWithOGLSharedContextCurrentMethod.setAccessible(true);
                                            getOGLSurfaceTypeMethod = clazz2.getDeclaredMethod("getOGLSurfaceType", Graphics.class);
                                            getOGLSurfaceTypeMethod.setAccessible(true);
                                        }
                                        catch (Exception exception) {
                                            fbObjectSupportInitialized = false;
                                            if (!DEBUG) break block18;
                                            exception.printStackTrace();
                                            System.err.println("Info: Disabling Java2D/JOGL FBO support");
                                        }
                                    }
                                    try {
                                        getOGLTextureTypeMethod = clazz2.getDeclaredMethod("getOGLTextureType", Graphics.class);
                                        getOGLTextureTypeMethod.setAccessible(true);
                                    }
                                    catch (Exception exception) {
                                        if (!DEBUG) break block19;
                                        exception.printStackTrace();
                                        System.err.println("Info: GL_ARB_texture_rectangle FBO support disabled");
                                    }
                                }
                                clazz = null;
                                try {
                                    clazz = Class.forName("sun.java2d.opengl.CGLSurfaceData");
                                }
                                catch (Exception exception) {
                                    if (!DEBUG) break block20;
                                    exception.printStackTrace();
                                    System.err.println("Info: Unable to find class sun.java2d.opengl.CGLSurfaceData for OS X");
                                }
                            }
                            if (clazz != null) {
                                fbObjectSupportInitialized = false;
                                createOGLContextOnSurfaceMethod = clazz.getDeclaredMethod("createOGLContextOnSurface", Graphics.class, Long.TYPE);
                                createOGLContextOnSurfaceMethod.setAccessible(true);
                                makeOGLContextCurrentOnSurfaceMethod = clazz.getDeclaredMethod("makeOGLContextCurrentOnSurface", Graphics.class, Long.TYPE);
                                makeOGLContextCurrentOnSurfaceMethod.setAccessible(true);
                                destroyOGLContextMethod = clazz.getDeclaredMethod("destroyOGLContext", Long.TYPE);
                                destroyOGLContextMethod.setAccessible(true);
                            }
                        }
                        catch (Exception exception) {
                            throwable = exception;
                            if (DEBUG) {
                                System.err.println("Info: Disabling Java2D/JOGL integration");
                            }
                            isOGLPipelineActive = false;
                        }
                    }
                    catch (HeadlessException headlessException) {
                    }
                    catch (Error error) {
                        throwable = error;
                    }
                }
                if (DEBUG) {
                    if (null != throwable) {
                        throwable.printStackTrace();
                    }
                    System.err.println("JOGL/Java2D integration " + (isOGLPipelineActive ? "enabled" : "disabled"));
                }
                return null;
            }
        });
    }
}

