/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLProfile;
import jogamp.opengl.util.av.GLMediaPlayerImpl;

public class NullGLMediaPlayer
extends GLMediaPlayerImpl {
    private TextureData texData = null;
    private TextureSequence.TextureFrame frame = null;
    private int pos_ms = 0;
    private int pos_start = 0;

    public NullGLMediaPlayer() {
        this.setTextureCount(1);
    }

    @Override
    protected boolean setPlaySpeedImpl(float f) {
        return false;
    }

    @Override
    protected boolean startImpl() {
        this.pos_start = (int)System.currentTimeMillis();
        return true;
    }

    @Override
    protected boolean pauseImpl() {
        return true;
    }

    @Override
    protected boolean stopImpl() {
        return true;
    }

    @Override
    protected int seekImpl(int n) {
        this.pos_ms = n;
        this.validatePos();
        return this.pos_ms;
    }

    @Override
    protected TextureSequence.TextureFrame getLastTextureImpl() {
        return this.frame;
    }

    @Override
    protected TextureSequence.TextureFrame getNextTextureImpl(GL gL, boolean bl) {
        return this.frame;
    }

    @Override
    protected int getCurrentPositionImpl() {
        this.pos_ms = (int)System.currentTimeMillis() - this.pos_start;
        this.validatePos();
        return this.pos_ms;
    }

    @Override
    protected void destroyImpl(GL gL) {
    }

    @Override
    protected void initGLStreamImpl(GL gL, int[] nArray) throws IOException {
        Object object;
        try {
            object = IOUtil.getResource((String)"jogl/util/data/av/test-ntsc01-160x90.png", (ClassLoader)this.getClass().getClassLoader());
            if (null != object) {
                this.texData = TextureIO.newTextureData(GLProfile.getGL2ES2(), ((URLConnection)object).getInputStream(), false, "png");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (null != this.texData) {
            this.width = this.texData.getWidth();
            this.height = this.texData.getHeight();
        } else {
            this.width = 640;
            this.height = 480;
            object = Buffers.newDirectByteBuffer((int)(this.width * this.height * 4));
            while (((Buffer)object).hasRemaining()) {
                ((ByteBuffer)object).put((byte)-22);
                ((ByteBuffer)object).put((byte)-22);
                ((ByteBuffer)object).put((byte)-22);
                ((ByteBuffer)object).put((byte)-22);
            }
            ((ByteBuffer)object).rewind();
            this.texData = new TextureData(GLProfile.getGL2ES2(), 6408, this.width, this.height, 0, 6408, 5121, false, false, false, (Buffer)object, null);
        }
        this.fps = 24.0f;
        this.duration = 600000;
        this.totalFrames = (int)((float)(this.duration / 1000) * this.fps);
        this.vcodec = "png-static";
    }

    @Override
    protected TextureSequence.TextureFrame createTexImage(GL gL, int n, int[] nArray) {
        Texture texture = super.createTexImageImpl(gL, n, nArray, this.width, this.height, false);
        if (null != this.texData) {
            texture.updateImage(gL, this.texData);
            this.texData.destroy();
            this.texData = null;
        }
        this.frame = new TextureSequence.TextureFrame(texture);
        return this.frame;
    }

    @Override
    protected void destroyTexImage(GL gL, TextureSequence.TextureFrame textureFrame) {
        this.frame = null;
        super.destroyTexImage(gL, textureFrame);
    }

    private void validatePos() {
        boolean bl = false;
        if (0 > this.pos_ms) {
            this.pos_ms = 0;
            bl = true;
        } else if (this.pos_ms > this.getDuration()) {
            this.pos_ms = this.getDuration();
            bl = true;
        }
        if (bl && this.state == GLMediaPlayer.State.Playing) {
            this.state = GLMediaPlayer.State.Paused;
        }
    }
}

