/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjBadCrcException;
import jogamp.opengl.util.pngj.PngjInputException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;

class PngIDatChunkInputStream
extends InputStream {
    private final InputStream inputStream;
    private final CRC32 crcEngine;
    private int lenLastChunk;
    private byte[] idLastChunk = new byte[4];
    private int toReadThisChunk = 0;
    private boolean ended = false;
    private long offset;
    List<IdatChunkInfo> foundChunksInfo = new ArrayList<IdatChunkInfo>();

    PngIDatChunkInputStream(InputStream inputStream, int n, int n2) {
        this.offset = n2;
        this.inputStream = inputStream;
        this.crcEngine = new CRC32();
        this.lenLastChunk = n;
        this.toReadThisChunk = n;
        System.arraycopy(ChunkHelper.b_IDAT, 0, this.idLastChunk, 0, 4);
        this.crcEngine.update(this.idLastChunk, 0, 4);
        this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, n2 - 8));
        if (this.lenLastChunk == 0) {
            this.endChunkGoForNext();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void endChunkGoForNext() {
        do {
            int n = PngHelper.readInt4(this.inputStream);
            this.offset += 4L;
            int n2 = (int)this.crcEngine.getValue();
            if (this.lenLastChunk > 0 && n != n2) {
                throw new PngjBadCrcException("error reading idat; offset: " + this.offset);
            }
            this.crcEngine.reset();
            this.lenLastChunk = PngHelper.readInt4(this.inputStream);
            if (this.lenLastChunk < 0) {
                throw new PngjInputException("invalid len for chunk: " + this.lenLastChunk);
            }
            this.toReadThisChunk = this.lenLastChunk;
            PngHelper.readBytes(this.inputStream, this.idLastChunk, 0, 4);
            this.offset += 8L;
            boolean bl = this.ended = !Arrays.equals(this.idLastChunk, ChunkHelper.b_IDAT);
            if (this.ended) continue;
            this.foundChunksInfo.add(new IdatChunkInfo(this.lenLastChunk, (int)(this.offset - 8L)));
            this.crcEngine.update(this.idLastChunk, 0, 4);
        } while (this.lenLastChunk == 0 && !this.ended);
    }

    void forceChunkEnd() {
        if (!this.ended) {
            byte[] byArray = new byte[this.toReadThisChunk];
            PngHelper.readBytes(this.inputStream, byArray, 0, this.toReadThisChunk);
            this.crcEngine.update(byArray, 0, this.toReadThisChunk);
            this.endChunkGoForNext();
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.toReadThisChunk == 0) {
            throw new RuntimeException("this should not happen");
        }
        int n3 = this.inputStream.read(byArray, n, n2 >= this.toReadThisChunk ? this.toReadThisChunk : n2);
        if (n3 > 0) {
            this.crcEngine.update(byArray, n, n3);
            this.offset += (long)n3;
            this.toReadThisChunk -= n3;
        }
        if (this.toReadThisChunk == 0) {
            this.endChunkGoForNext();
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n < 0 ? -1 : byArray[0];
    }

    int getLenLastChunk() {
        return this.lenLastChunk;
    }

    byte[] getIdLastChunk() {
        return this.idLastChunk;
    }

    long getOffset() {
        return this.offset;
    }

    boolean isEnded() {
        return this.ended;
    }

    static class IdatChunkInfo {
        public final int len;
        public final int offset;

        private IdatChunkInfo(int n, int n2) {
            this.len = n;
            this.offset = n2;
        }
    }
}

