/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds.chunks;

import com.microcrowd.loader.java3d.max3ds.ChunkChopper;
import com.microcrowd.loader.java3d.max3ds.ChunkMap;
import com.microcrowd.loader.java3d.max3ds.chunks.Chunk;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.picking.PickTool;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class FacesDescriptionChunk
extends Chunk {
    public static final Appearance DEFAULT_APPEARANCE = new Appearance();
    private Point3f[] currentVertices;
    private TexCoord2f[] textureTriangles;
    private PointMapper shareMap;

    public void loadData(ChunkChopper chopper) {
        int numFaces = chopper.getUnsignedShort();
        this.shareMap = new PointMapper(numFaces * 3);
        Point3f[] coordinates = (Point3f[])chopper.popData(ChunkMap.VERTEX_LIST);
        TexCoord2f[] texturePoints = (TexCoord2f[])chopper.popData(ChunkMap.TEXTURE_COORDINATES);
        this.currentVertices = new Point3f[numFaces * 3];
        chopper.pushData(chopper.getID(), this.currentVertices);
        if (texturePoints != null) {
            this.textureTriangles = new TexCoord2f[numFaces * 3];
        }
        for (int i = 0; i < numFaces; ++i) {
            int vertexIndex = i * 3;
            int index0 = chopper.getUnsignedShort();
            int index1 = chopper.getUnsignedShort();
            int index2 = chopper.getUnsignedShort();
            this.currentVertices[vertexIndex] = coordinates[index0];
            this.currentVertices[vertexIndex + 1] = coordinates[index1];
            this.currentVertices[vertexIndex + 2] = coordinates[index2];
            this.shareMap.addCoordinate(coordinates[index0], vertexIndex);
            this.shareMap.addCoordinate(coordinates[index1], vertexIndex + 1);
            this.shareMap.addCoordinate(coordinates[index2], vertexIndex + 2);
            if (this.textureTriangles != null) {
                this.textureTriangles[vertexIndex] = texturePoints[index0];
                this.textureTriangles[vertexIndex + 1] = texturePoints[index1];
                this.textureTriangles[vertexIndex + 2] = texturePoints[index2];
            }
            chopper.getUnsignedShort();
        }
    }

    public void initialize(ChunkChopper chopper) {
        String materialName = (String)chopper.popData(ChunkMap.FACES_MATERIAL);
        int[] smoothGroups = (int[])chopper.popData(ChunkMap.SMOOTH);
        Shape3D shape = new Shape3D();
        GeometryInfo geometryInfo = new GeometryInfo(1);
        geometryInfo.setCoordinates(this.currentVertices);
        TransformGroup transformGroup = chopper.getGroup();
        transformGroup.addChild((Node)shape);
        if (this.textureTriangles != null) {
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, this.textureTriangles);
        }
        if (materialName != null) {
            shape.setAppearance((Appearance)chopper.getNamedObject(materialName));
        } else {
            shape.setAppearance(DEFAULT_APPEARANCE);
        }
        if (smoothGroups == null) {
            NormalGenerator normalGenerator = new NormalGenerator();
            geometryInfo.recomputeIndices();
            normalGenerator.generateNormals(geometryInfo);
        } else {
            Vector3f[] normals = this.generateNormals(this.currentVertices);
            Vector3f[] smoothNormals = this.smoothNormals(normals, this.shareMap, smoothGroups);
            geometryInfo.setNormals(smoothNormals);
        }
        new Stripifier().stripify(geometryInfo);
        shape.setGeometry((Geometry)geometryInfo.getGeometryArray());
        shape.setCapability(18);
        PickTool.setCapabilities((Node)shape, (int)4100);
        this.currentVertices = null;
        this.textureTriangles = null;
    }

    public Vector3f[] smoothNormals(Vector3f[] currentNormals, PointMapper sharedPoints, int[] smoothGroups) {
        Vector3f[] smoothNormals = new Vector3f[currentNormals.length];
        for (int i = 0; i < currentNormals.length; ++i) {
            Set otherPoints = sharedPoints.getSharedCoordinates(i, smoothGroups);
            if (otherPoints != null) {
                Vector3f[] sharedNormals = new Vector3f[otherPoints.size()];
                Iterator pointIterator = otherPoints.iterator();
                for (int j = 0; j < sharedNormals.length; ++j) {
                    sharedNormals[j] = currentNormals[(Integer)pointIterator.next()];
                }
                smoothNormals[i] = this.averageNormals(sharedNormals);
                continue;
            }
            smoothNormals[i] = currentNormals[i];
        }
        return smoothNormals;
    }

    public Vector3f averageNormals(Vector3f[] normals) {
        Vector3f newNormal = new Vector3f();
        for (int i = 0; i < normals.length; ++i) {
            newNormal.add((Tuple3f)normals[i]);
        }
        newNormal.normalize();
        return newNormal;
    }

    private Vector3f[] generateNormals(Point3f[] points) {
        Vector3f[] normals = new Vector3f[points.length];
        int i = 0;
        while (i < normals.length) {
            Vector3f normal = new Vector3f();
            Vector3f v1 = new Vector3f();
            Vector3f v2 = new Vector3f();
            v1.sub((Tuple3f)points[i + 1], (Tuple3f)points[i]);
            v2.sub((Tuple3f)points[i + 2], (Tuple3f)points[i]);
            normal.cross(v1, v2);
            normal.normalize();
            normals[i++] = new Vector3f(normal);
            normals[i++] = new Vector3f(normal);
            normals[i++] = new Vector3f(normal);
        }
        return normals;
    }

    static {
        Material defaultMaterial = new Material();
        defaultMaterial.setAmbientColor(new Color3f(0.5f, 0.5f, 0.5f));
        DEFAULT_APPEARANCE.setMaterial(defaultMaterial);
    }

    private class PointMapper
    extends HashMap {
        private Set[] coordinateSet;

        public PointMapper(int size) {
            this.coordinateSet = new Set[size];
        }

        public void addCoordinate(Point3f coordinate, int vertexNum) {
            HashSet<Integer> sharedCoordinates = (HashSet<Integer>)this.get(coordinate);
            if (sharedCoordinates == null) {
                sharedCoordinates = new HashSet<Integer>();
                this.put(coordinate, sharedCoordinates);
            }
            sharedCoordinates.add(new Integer(vertexNum));
            this.coordinateSet[vertexNum] = sharedCoordinates;
        }

        public Set getSharedCoordinates(int coordinateNum, int[] smoothGroups) {
            HashSet<Integer> returnSet = new HashSet<Integer>();
            Set sharingVertices = this.coordinateSet[coordinateNum];
            Iterator vertices = sharingVertices.iterator();
            int coordinateMask = smoothGroups[coordinateNum];
            while (vertices.hasNext()) {
                Integer vertex = (Integer)vertices.next();
                int nextMask = smoothGroups[vertex];
                if ((nextMask & coordinateMask) == 0) continue;
                returnSet.add(vertex);
            }
            return returnSet;
        }
    }
}

