/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jdepend.framework.ClassFileParser;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;

public class ClassFileParserTest
extends JDependTestCase {
    private ClassFileParser parser;

    public ClassFileParserTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        PackageFilter filter = new PackageFilter(new ArrayList());
        this.parser = new ClassFileParser(filter);
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testInvalidClassFile() {
        File f = new File(this.getTestDir() + this.getPackageSubDir() + "ExampleTest.java");
        try {
            this.parser.parse(f);
            ClassFileParserTest.fail((String)"Invalid class file: Should raise IOException");
        }
        catch (IOException expected) {
            ClassFileParserTest.assertTrue((boolean)true);
        }
    }

    public void testInterfaceClass() throws IOException {
        File f = new File(this.getBuildDir() + this.getPackageSubDir() + "ExampleInterface.class");
        JavaClass clazz = this.parser.parse(f);
        ClassFileParserTest.assertTrue((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.ExampleInterface", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"ExampleInterface.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)6, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.math")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.text")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.io")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.rmi")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util")));
    }

    public void testAbstractClass() throws IOException {
        File f = new File(this.getBuildDir() + this.getPackageSubDir() + "ExampleAbstractClass.class");
        JavaClass clazz = this.parser.parse(f);
        ClassFileParserTest.assertTrue((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.ExampleAbstractClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"ExampleAbstractClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)7, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.math")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.text")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang.reflect")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.io")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.rmi")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util")));
    }

    public void testConcreteClass() throws IOException {
        File f = new File(this.getBuildDir() + this.getPackageSubDir() + "ExampleConcreteClass.class");
        JavaClass clazz = this.parser.parse(f);
        ClassFileParserTest.assertFalse((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.ExampleConcreteClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"ExampleConcreteClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)9, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.net")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.text")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.sql")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.io")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.rmi")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.util.jar")));
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.math")));
    }

    public void testInnerClass() throws IOException {
        File f = new File(this.getBuildDir() + this.getPackageSubDir() + "ExampleConcreteClass$ExampleInnerClass.class");
        JavaClass clazz = this.parser.parse(f);
        ClassFileParserTest.assertFalse((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.ExampleConcreteClass$ExampleInnerClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"ExampleConcreteClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)1, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
    }

    public void testPackageClass() throws IOException {
        File f = new File(this.getBuildDir() + this.getPackageSubDir() + "ExamplePackageClass.class");
        JavaClass clazz = this.parser.parse(f);
        ClassFileParserTest.assertFalse((boolean)clazz.isAbstract());
        ClassFileParserTest.assertEquals((String)"jdepend.framework.ExamplePackageClass", (String)clazz.getName());
        ClassFileParserTest.assertEquals((String)"ExampleConcreteClass.java", (String)clazz.getSourceFile());
        Collection imports = clazz.getImportedPackages();
        ClassFileParserTest.assertEquals((int)1, (int)imports.size());
        ClassFileParserTest.assertTrue((boolean)imports.contains(new JavaPackage("java.lang")));
    }
}

