/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import jdepend.framework.JDepend;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaPackage;
import jdepend.framework.PropertyConfigurator;

public class PropertyConfiguratorTest
extends JDependTestCase {
    public PropertyConfiguratorTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        System.setProperty("user.home", this.getTestDataDir());
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testDefaultFilters() {
        PropertyConfigurator c = new PropertyConfigurator();
        this.assertFiltersExist(c.getFilteredPackages());
        PropertyConfiguratorTest.assertFalse((boolean)c.getAnalyzeInnerClasses());
    }

    public void testFiltersFromFile() throws IOException {
        String file = this.getTestDataDir() + "jdepend.properties";
        PropertyConfigurator c = new PropertyConfigurator(new File(file));
        this.assertFiltersExist(c.getFilteredPackages());
        PropertyConfiguratorTest.assertFalse((boolean)c.getAnalyzeInnerClasses());
    }

    private void assertFiltersExist(Collection filters) {
        PropertyConfiguratorTest.assertEquals((int)5, (int)filters.size());
        PropertyConfiguratorTest.assertTrue((boolean)filters.contains("java.*"));
        PropertyConfiguratorTest.assertTrue((boolean)filters.contains("javax.*"));
        PropertyConfiguratorTest.assertTrue((boolean)filters.contains("sun.*"));
        PropertyConfiguratorTest.assertTrue((boolean)filters.contains("com.sun.*"));
        PropertyConfiguratorTest.assertTrue((boolean)filters.contains("com.xyz.tests.*"));
    }

    public void testDefaultPackages() throws IOException {
        JDepend j = new JDepend();
        JavaPackage pkg = j.getPackage("com.xyz.a.neverchanges");
        PropertyConfiguratorTest.assertNotNull((Object)pkg);
        PropertyConfiguratorTest.assertEquals((int)0, (int)pkg.getVolatility());
        pkg = j.getPackage("com.xyz.b.neverchanges");
        PropertyConfiguratorTest.assertNotNull((Object)pkg);
        PropertyConfiguratorTest.assertEquals((int)0, (int)pkg.getVolatility());
        pkg = j.getPackage("com.xyz.c.neverchanges");
        PropertyConfiguratorTest.assertNull((Object)pkg);
    }
}

