/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.font;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontSet;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.security.AccessControlContext;
import jogamp.graph.font.FontConstructor;
import jogamp.graph.font.JavaFontLoader;
import jogamp.graph.font.UbuntuFontLoader;

public class FontFactory {
    public static final int UBUNTU = 0;
    public static final int JAVA = 1;
    private static final FontConstructor fontConstr;

    public static final FontSet getDefault() {
        return FontFactory.get(0);
    }

    public static final FontSet get(int n) {
        switch (n) {
            case 1: {
                return JavaFontLoader.get();
            }
        }
        return UbuntuFontLoader.get();
    }

    public static final Font get(File file) throws IOException {
        return fontConstr.create(file);
    }

    public static final Font get(URLConnection uRLConnection) throws IOException {
        return fontConstr.create(uRLConnection);
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\u0000' && unicodeBlock != null && unicodeBlock != Character.UnicodeBlock.SPECIALS;
    }

    static {
        String string = PropertyAccess.getProperty((String)"FontImpl", (boolean)true, (AccessControlContext)SecurityUtil.getCommonAccessControlContext(FontFactory.class));
        if (null == string) {
            string = "jogamp.graph.font.typecast.TypecastFontConstructor";
        }
        fontConstr = (FontConstructor)ReflectionUtil.createInstance((String)string, (ClassLoader)FontFactory.class.getClassLoader());
    }
}

