/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkGAMA
extends PngChunk {
    private double gamma;

    public PngChunkGAMA(ImageInfo imageInfo) {
        super("gAMA", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public boolean mustGoBeforePLTE() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(4, true);
        int n = (int)(this.gamma * 100000.0 + 0.5);
        PngHelper.writeInt4tobytes(n, chunkRaw.data, 0);
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 4) {
            throw new PngjException("bad chunk " + chunkRaw);
        }
        int n = PngHelper.readInt4fromBytes(chunkRaw.data, 0);
        this.gamma = (double)n / 100000.0;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        this.gamma = ((PngChunkGAMA)pngChunk).gamma;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        this.gamma = d;
    }
}

