/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;

public class PngChunkPHYS
extends PngChunk {
    private long pixelsxUnitX;
    private long pixelsxUnitY;
    private int units;

    public PngChunkPHYS(ImageInfo imageInfo) {
        super("pHYs", imageInfo);
    }

    @Override
    public boolean mustGoBeforeIDAT() {
        return true;
    }

    @Override
    public ChunkRaw createChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(9, true);
        PngHelper.writeInt4tobytes((int)this.pixelsxUnitX, chunkRaw.data, 0);
        PngHelper.writeInt4tobytes((int)this.pixelsxUnitY, chunkRaw.data, 4);
        chunkRaw.data[8] = (byte)this.units;
        return chunkRaw;
    }

    @Override
    public void parseFromChunk(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 9) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        this.pixelsxUnitX = PngHelper.readInt4fromBytes(chunkRaw.data, 0);
        if (this.pixelsxUnitX < 0L) {
            this.pixelsxUnitX += 0x100000000L;
        }
        this.pixelsxUnitY = PngHelper.readInt4fromBytes(chunkRaw.data, 4);
        if (this.pixelsxUnitY < 0L) {
            this.pixelsxUnitY += 0x100000000L;
        }
        this.units = PngHelper.readInt1fromByte(chunkRaw.data, 8);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkPHYS pngChunkPHYS = (PngChunkPHYS)pngChunk;
        this.pixelsxUnitX = pngChunkPHYS.pixelsxUnitX;
        this.pixelsxUnitY = pngChunkPHYS.pixelsxUnitY;
        this.units = pngChunkPHYS.units;
    }

    public long getPixelsxUnitX() {
        return this.pixelsxUnitX;
    }

    public void setPixelsxUnitX(long l) {
        this.pixelsxUnitX = l;
    }

    public long getPixelsxUnitY() {
        return this.pixelsxUnitY;
    }

    public void setPixelsxUnitY(long l) {
        this.pixelsxUnitY = l;
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public double getAsDpi() {
        if (this.units != 1 || this.pixelsxUnitX != this.pixelsxUnitY) {
            return -1.0;
        }
        return (double)this.pixelsxUnitX * 0.0254;
    }

    public double[] getAsDpi2() {
        if (this.units != 1) {
            return new double[]{-1.0, -1.0};
        }
        return new double[]{(double)this.pixelsxUnitX * 0.0254, (double)this.pixelsxUnitY * 0.0254};
    }

    public void setAsDpi(double d) {
        this.units = 1;
        this.pixelsxUnitY = this.pixelsxUnitX = (long)(d / 0.0254 + 0.5);
    }

    public void setAsDpi2(double d, double d2) {
        this.units = 1;
        this.pixelsxUnitX = (long)(d / 0.0254 + 0.5);
        this.pixelsxUnitY = (long)(d2 / 0.0254 + 0.5);
    }
}

